/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.HywZombieEntity;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywFastZombieEntity
extends HywZombieEntity {
    private static final float ATTACK_REACH = 2.2f;
    private static final float MOVEMENT_SPEED = 0.32f;

    public HywFastZombieEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createHywFastZombieAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, (double)0.32f).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22278_, 0.35).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), (double)2.2f);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 10;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 3;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 3 + random.nextInt(6);
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_FAST_ZOMBIE.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_FAST_ZOMBIE_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_FAST_ZOMBIE_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_FAST_ZOMBIE_3.get();
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        AttributeInstance movementSpeed;
        AttributeInstance attackDamage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 3.0);
            this.m_5634_(3.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.4);
        }
        if ((movementSpeed = this.m_21051_(Attributes.f_22279_)) != null) {
            movementSpeed.m_22100_(movementSpeed.m_22115_() + 0.01);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount *= 1.05f);
    }

    @Override
    protected String getEquipmentJsonPath() {
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/hyw_zombie/" + equipmentFile;
    }
}

