/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.json.EnchantmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class HywHorseEntity
extends Horse
implements BaseCombatSupport {
    private UUID ownerUUID;
    private BaseCombatEntity riderEntity;
    private int equipmentLevel = 1;
    private BlockPos homePosition;
    private static final EntityDataAccessor<Boolean> IS_NPC_HORSE = SynchedEntityData.m_135353_(HywHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_RANDOMIZED_APPEARANCE = SynchedEntityData.m_135353_(HywHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> REQUIRES_SUPPLY = SynchedEntityData.m_135353_(HywHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean deferredSaddleEquip = false;
    private static EquipmentData equipmentData;
    private final Random random = new Random();

    private void setDeferredSaddleEquip(boolean defer) {
        this.deferredSaddleEquip = defer;
    }

    public HywHorseEntity(EntityType<? extends Horse> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.m_21530_();
        this.m_30651_(true);
        this.m_30649_(this.m_7555_());
        if (!world.f_46443_) {
            this.setDeferredSaddleEquip(true);
        }
        this.randomizeIfNeeded();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_NPC_HORSE, (Object)false);
        this.f_19804_.m_135372_(HAS_RANDOMIZED_APPEARANCE, (Object)false);
        this.f_19804_.m_135372_(REQUIRES_SUPPLY, (Object)true);
    }

    public static AttributeSupplier.Builder createHorseAttributes() {
        return Horse.m_30627_();
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.syncSupplyRequirementWithRider();
        }
        if (!this.m_9236_().f_46443_ && this.deferredSaddleEquip) {
            this.f_30520_.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
            this.m_7493_();
            this.deferredSaddleEquip = false;
        }
        if (!this.m_9236_().f_46443_ && this.requiresSupply() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SupplyManager.tryEstablishSupply(this, (Level)serverLevel);
        }
    }

    public void setRiderEntity(BaseCombatEntity rider) {
        this.riderEntity = rider;
        if (!this.m_9236_().f_46443_) {
            this.syncSupplyRequirementWithRider();
        }
    }

    public BaseCombatEntity getRiderEntity() {
        return this.riderEntity;
    }

    private void syncSupplyRequirementWithRider() {
        if (this.riderEntity == null || this.m_9236_() == null || this.m_9236_().f_46443_) {
            return;
        }
        boolean riderRequiresSupply = this.riderEntity.requiresSupply();
        if (this.requiresSupply() != riderRequiresSupply) {
            this.setRequiresSupply(riderRequiresSupply);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ItemStack playerItem;
        Player player;
        if (this.m_9236_().f_46443_) {
            return super.m_6469_(source, amount);
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange() && this.isHorseArmor(playerItem = player.m_21120_(InteractionHand.MAIN_HAND))) {
            ItemStack currentArmor;
            ItemStack itemStack = currentArmor = this.f_30520_ != null ? this.f_30520_.m_8020_(1) : ItemStack.f_41583_;
            if (this.f_30520_ != null) {
                this.f_30520_.m_6836_(1, playerItem.m_41777_());
                this.m_7493_();
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!currentArmor.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, currentArmor);
                }
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            Entity entity;
            if (this.isNpcHorse() && (entity = this.m_146895_()) instanceof BaseCombatEntity) {
                BaseCombatEntity rider = (BaseCombatEntity)entity;
                return rider.m_6071_(player, hand);
            }
            if (this.isNpcHorse()) {
                return InteractionResult.PASS;
            }
            if (player.m_6144_()) {
                if (this.getScrollType() != null) {
                    boolean canRecall = false;
                    if (player.m_7500_()) {
                        canRecall = CreativeModeSettings.canControlAllUnits(player);
                    } else {
                        boolean bl = canRecall = ServerModConfig.INSTANCE.isAllowSoldierRecall() && ServerRelationHelper.hasControlOver(player, (Entity)this);
                    }
                    if (canRecall) {
                        ItemStack stack = new ItemStack((ItemLike)this.getScrollType());
                        CompoundTag entityData = new CompoundTag();
                        this.m_20240_(entityData);
                        ((BaseScrollItem)stack.m_41720_()).saveEntityDataToItem(stack, entityData);
                        if (!player.m_150109_().m_36054_(stack)) {
                            player.m_36176_(stack, false);
                        }
                        this.spawnParticles(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                        this.m_146870_();
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        compound.m_128379_("DeferredSaddleEquip", this.deferredSaddleEquip);
        compound.m_128379_("IsNpcHorse", this.isNpcHorse());
        compound.m_128379_("HasRandomizedAppearance", this.hasRandomizedAppearance());
        compound.m_128405_("EquipmentLevel", this.equipmentLevel);
        compound.m_128379_("RequiresSupply", this.requiresSupply());
        if (this.homePosition != null) {
            compound.m_128356_("HomePosition", this.homePosition.m_121878_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128441_("DeferredSaddleEquip")) {
            this.deferredSaddleEquip = compound.m_128471_("DeferredSaddleEquip");
        }
        if (compound.m_128441_("IsNpcHorse")) {
            this.setNpcHorse(compound.m_128471_("IsNpcHorse"));
        }
        if (compound.m_128441_("HasRandomizedAppearance")) {
            this.setHasRandomizedAppearance(compound.m_128471_("HasRandomizedAppearance"));
        }
        if (compound.m_128441_("EquipmentLevel")) {
            this.equipmentLevel = compound.m_128451_("EquipmentLevel");
        }
        if (compound.m_128441_("RequiresSupply")) {
            this.setRequiresSupply(compound.m_128471_("RequiresSupply"));
        }
        if (compound.m_128441_("HomePosition")) {
            this.homePosition = BlockPos.m_122022_((long)compound.m_128454_("HomePosition"));
        }
    }

    public boolean isNpcHorse() {
        return (Boolean)this.f_19804_.m_135370_(IS_NPC_HORSE);
    }

    public void setNpcHorse(boolean isNpcHorse) {
        this.f_19804_.m_135381_(IS_NPC_HORSE, (Object)isNpcHorse);
    }

    public boolean m_6094_() {
        return true;
    }

    protected boolean m_7341_(Entity entity) {
        if (this.isNpcHorse()) {
            if (entity instanceof Player) {
                return false;
            }
            return entity instanceof BaseCombatEntity;
        }
        return super.m_7341_(entity);
    }

    public boolean m_7998_(Entity entity, boolean force) {
        if (this.isNpcHorse() && this.m_146895_() instanceof Player) {
            return false;
        }
        return super.m_7998_(entity, force);
    }

    protected void m_20348_(Entity passenger) {
        if (this.isNpcHorse() && passenger instanceof Player) {
            return;
        }
        if (this.isNpcHorse() && !this.m_20197_().isEmpty() && passenger instanceof Player) {
            return;
        }
        super.m_20348_(passenger);
    }

    @Override
    public void setEquipment(int level) {
        this.loadEquipmentData();
        if (equipmentData != null) {
            EquipmentLevelData levelData = equipmentData.getLevels().get(String.valueOf(level));
            if (levelData == null) {
                this.setDefaultEquipment();
                return;
            }
            this.setEquipmentFromLevelData(levelData);
            this.setEquipmentLevel(level);
        } else {
            this.setDefaultEquipment();
        }
    }

    @Override
    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    @Override
    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    @Override
    public void m_30586_(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    @Override
    public void setHomePosition(BlockPos homePosition) {
        this.homePosition = homePosition;
    }

    @Override
    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_HORSE.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_HORSE_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_HORSE_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_HORSE_3.get();
            default -> null;
        };
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    protected String getEquipmentJsonPath() {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_());
        if (entityId == null) {
            return null;
        }
        String entityName = entityId.m_135815_();
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/" + entityName + "/" + equipmentFile;
    }

    protected void loadEquipmentData() {
        String configResourcePath = this.getEquipmentJsonPath();
        if (configResourcePath == null) {
            return;
        }
        String[] parts = configResourcePath.split(":");
        if (parts.length != 2) {
            return;
        }
        String namespace = parts[0];
        String path = parts[1];
        String fullPath = "/assets/" + namespace + "/" + path;
        InputStream is = this.getClass().getResourceAsStream(fullPath);
        if (is == null) {
            return;
        }
        try (InputStream inputStream = is;
             InputStreamReader reader = new InputStreamReader(inputStream);){
            Gson gson = new Gson();
            equipmentData = (EquipmentData)gson.fromJson((Reader)reader, EquipmentData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected EquipmentOption selectRandomItem(List<EquipmentOption> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        double totalProbability = 0.0;
        for (EquipmentOption option : options) {
            totalProbability += option.getProbability();
        }
        double randomValue = this.random.nextDouble() * totalProbability;
        double cumulativeProbability = 0.0;
        for (EquipmentOption option : options) {
            if (!(randomValue <= (cumulativeProbability += option.getProbability()))) continue;
            return option;
        }
        return null;
    }

    protected ItemStack createItemStack(EquipmentOption option) {
        if (option == null || option.getItem() == null) {
            return ItemStack.f_41583_;
        }
        ResourceLocation itemId = new ResourceLocation(option.getItem());
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item == Items.f_41852_) {
            System.err.println("missing\uff1a" + option.getItem());
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (option.getEnchantments() != null) {
            for (EnchantmentData enchantmentData : option.getEnchantments()) {
                ResourceLocation enchantmentId = new ResourceLocation(enchantmentData.getEnchantment());
                Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(enchantmentId);
                if (enchantment != null) {
                    itemStack.m_41663_(enchantment, enchantmentData.getLevel());
                    continue;
                }
                System.err.println("missing\uff1a" + enchantmentData.getEnchantment());
            }
        }
        return itemStack;
    }

    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption horseArmorOption;
        ItemStack horseArmor;
        if (levelData.getHorseArmor() != null && !levelData.getHorseArmor().isEmpty() && !(horseArmor = this.createItemStack(horseArmorOption = this.selectRandomItem(levelData.getHorseArmor()))).m_41619_() && this.f_30520_ != null) {
            this.f_30520_.m_6836_(1, horseArmor);
            this.m_7493_();
        }
    }

    protected void setDefaultEquipment() {
    }

    private boolean isHorseArmor(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof HorseArmorItem;
    }

    private void spawnParticles(Level world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = world.f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    protected void m_5907_() {
        if (ServerModConfig.INSTANCE.isAllowEquipmentDrop()) {
            super.m_5907_();
        }
    }

    public void randomizeIfNeeded() {
        if (!this.m_9236_().f_46443_ && !this.hasRandomizedAppearance()) {
            RandomSource randomSource = this.m_9236_().m_213780_();
            Variant[] variants = Variant.values();
            Variant variant = variants[randomSource.m_188503_(variants.length)];
            Markings[] markingsArray = Markings.values();
            Markings markings = markingsArray[randomSource.m_188503_(markingsArray.length)];
            this.m_28464_(variant);
            try {
                Method setVariantAndMarkingsMethod = Horse.class.getDeclaredMethod("setVariantAndMarkings", Variant.class, Markings.class);
                setVariantAndMarkingsMethod.setAccessible(true);
                setVariantAndMarkingsMethod.invoke((Object)this, variant, markings);
            }
            catch (Exception e) {
                this.m_28464_(variant);
            }
            this.m_214179_(this.m_217043_());
            this.setHasRandomizedAppearance(true);
        }
    }

    public boolean hasRandomizedAppearance() {
        return (Boolean)this.f_19804_.m_135370_(HAS_RANDOMIZED_APPEARANCE);
    }

    public void setHasRandomizedAppearance(boolean hasRandomized) {
        this.f_19804_.m_135381_(HAS_RANDOMIZED_APPEARANCE, (Object)hasRandomized);
    }

    @Override
    public boolean requiresSupply() {
        return (Boolean)this.f_19804_.m_135370_(REQUIRES_SUPPLY);
    }

    @Override
    public void setRequiresSupply(boolean requires) {
        this.f_19804_.m_135381_(REQUIRES_SUPPLY, (Object)requires);
    }

    @Override
    public double getDailySupplyConsumption() {
        return 2.0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, AbstractHorse.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.m_245259_()) {
            this.f_21345_.m_25352_(9, (Goal)new RandomStandGoal((AbstractHorse)this));
        }
        this.m_7509_();
    }
}

