/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.BackItemHolder;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class HywSkeletonEntity
extends BaseCombatEntity
implements BackItemHolder,
LightUnit,
CounterLight,
Mountable {
    private static final float ATTACK_REACH = 2.5f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private int noTargetTicks = 0;
    private static final int WEAPON_CHANGE_THRESHOLD = 100;
    private static final EntityDataAccessor<Boolean> WEAPON_ON_BACK = SynchedEntityData.m_135353_(HywSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> BACK_ITEM = SynchedEntityData.m_135353_(HywSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public HywSkeletonEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WEAPON_ON_BACK, (Object)false);
        this.f_19804_.m_135372_(BACK_ITEM, (Object)ItemStack.f_41583_);
    }

    public boolean isWeaponOnBack() {
        return (Boolean)this.f_19804_.m_135370_(WEAPON_ON_BACK);
    }

    public void setWeaponOnBack(boolean weaponOnBack) {
        boolean wasWeaponOnBack = this.isWeaponOnBack();
        this.f_19804_.m_135381_(WEAPON_ON_BACK, (Object)weaponOnBack);
        if (wasWeaponOnBack != weaponOnBack) {
            ItemStack mainHandItem = this.m_6844_(EquipmentSlot.MAINHAND);
            if (weaponOnBack) {
                if (!mainHandItem.m_41619_()) {
                    this.setBackItem(mainHandItem.m_41777_());
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                }
            } else {
                ItemStack backItem = this.getBackItem();
                if (!backItem.m_41619_()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, backItem.m_41777_());
                    this.setBackItem(ItemStack.f_41583_);
                }
            }
        }
    }

    @Override
    public ItemStack getBackItem() {
        return (ItemStack)this.f_19804_.m_135370_(BACK_ITEM);
    }

    @Override
    public void setBackItem(ItemStack itemStack) {
        this.f_19804_.m_135381_(BACK_ITEM, (Object)itemStack);
    }

    @Override
    public boolean shouldRenderBackItem() {
        return this.isWeaponOnBack() && !this.getBackItem().m_41619_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.getHywTarget() == null && this.m_5448_() == null) {
                ++this.noTargetTicks;
                if (this.noTargetTicks >= 100 && !this.isWeaponOnBack()) {
                    this.setWeaponOnBack(true);
                }
            } else {
                this.noTargetTicks = 0;
                if (this.isWeaponOnBack()) {
                    this.setWeaponOnBack(false);
                }
            }
        }
    }

    public static AttributeSupplier.Builder createHywSkeletonAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.5);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("WeaponOnBack", this.isWeaponOnBack());
        CompoundTag backItemTag = new CompoundTag();
        this.getBackItem().m_41739_(backItemTag);
        compound.m_128365_("BackItem", (Tag)backItemTag);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WeaponOnBack")) {
            this.setWeaponOnBack(compound.m_128471_("WeaponOnBack"));
        }
        if (compound.m_128441_("BackItem")) {
            ItemStack backItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("BackItem"));
            this.setBackItem(backItem);
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 6;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 1 + random.nextInt(5);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            ArmorItem armorItem;
            EquipmentSlot slot;
            ItemStack playerItem = player.m_6844_(EquipmentSlot.MAINHAND);
            Item item = playerItem.m_41720_();
            if (item instanceof ArmorItem && ((slot = (armorItem = (ArmorItem)item).m_40402_()) == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET)) {
                return false;
            }
            if (playerItem.m_41720_() instanceof SwordItem || playerItem.m_41720_() instanceof AxeItem) {
                ItemStack entityItem = this.m_6844_(EquipmentSlot.MAINHAND);
                if (this.isWeaponOnBack()) {
                    ItemStack backItem = this.getBackItem();
                    this.setBackItem(playerItem.m_41777_());
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    if (!backItem.m_41619_()) {
                        player.m_21008_(InteractionHand.MAIN_HAND, backItem);
                    }
                } else {
                    this.m_8061_(EquipmentSlot.MAINHAND, playerItem.m_41777_());
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    if (!entityItem.m_41619_()) {
                        player.m_21008_(InteractionHand.MAIN_HAND, entityItem);
                    }
                }
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_SKELETON.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_SKELETON_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_SKELETON_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_SKELETON_3.get();
            default -> null;
        };
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.8;
    }
}

