/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywSkeletonHorseEntity
extends HywHorseEntity {
    private int equipmentLevel = 1;
    private UUID ownerUUID;
    private BlockPos homePosition;
    private static EquipmentData equipmentData;
    private final Random random = new Random();
    private boolean requiresSupply = true;

    public HywSkeletonHorseEntity(EntityType<? extends HywHorseEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createSkeletonHorseAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.225).m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22288_, 0.8).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12425_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12427_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12426_;
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_SKELETON_HORSE.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_SKELETON_HORSE_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_SKELETON_HORSE_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_SKELETON_HORSE_3.get();
            default -> null;
        };
    }

    @Override
    public void setEquipment(int level) {
        this.equipmentLevel = level;
        this.loadEquipmentData();
        this.applyEquipment(level);
    }

    @Override
    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    @Override
    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    @Override
    public void m_30586_(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    @Override
    public void setHomePosition(BlockPos homePosition) {
        this.homePosition = homePosition;
    }

    @Override
    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Override
    protected String getEquipmentJsonPath() {
        String entityName = "hyw_horse";
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/" + entityName + "/" + equipmentFile;
    }

    @Override
    protected void loadEquipmentData() {
        String configResourcePath = this.getEquipmentJsonPath();
        if (configResourcePath == null) {
            return;
        }
        String[] parts = configResourcePath.split(":");
        if (parts.length != 2) {
            return;
        }
        String namespace = parts[0];
        String path = parts[1];
        String fullPath = "/assets/" + namespace + "/" + path;
        try (InputStream is = this.getClass().getResourceAsStream(fullPath);){
            if (is == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                Gson gson = new Gson();
                equipmentData = (EquipmentData)gson.fromJson((Reader)reader, EquipmentData.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected EquipmentOption selectRandomItem(List<EquipmentOption> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        double total = 0.0;
        for (EquipmentOption option : options) {
            total += option.getProbability();
        }
        double value = this.random.nextDouble() * total;
        double cumulative = 0.0;
        for (EquipmentOption option : options) {
            if (!(value <= (cumulative += option.getProbability()))) continue;
            return option;
        }
        return null;
    }

    private void applyEquipment(int level) {
        Item armorItem;
        EquipmentOption armorOption;
        if (equipmentData == null) {
            return;
        }
        EquipmentLevelData levelData = equipmentData.getLevels().get(String.valueOf(level));
        if (levelData == null) {
            return;
        }
        List<EquipmentOption> horseArmor = levelData.getHorseArmor();
        if (horseArmor != null && (armorOption = this.selectRandomItem(horseArmor)) != null && armorOption.getItem() != null && (armorItem = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(armorOption.getItem())).orElse(Items.f_41852_)) != Items.f_41852_ && this.f_30520_ != null) {
            this.f_30520_.m_6836_(1, new ItemStack((ItemLike)armorItem));
            this.m_7493_();
        }
    }

    @Override
    public boolean requiresSupply() {
        return this.requiresSupply;
    }

    @Override
    public void setRequiresSupply(boolean requires) {
        this.requiresSupply = requires;
    }

    @Override
    public double getDailySupplyConsumption() {
        return 2.0;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EquipmentLevel", this.equipmentLevel);
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        if (this.homePosition != null) {
            compound.m_128405_("HomeX", this.homePosition.m_123341_());
            compound.m_128405_("HomeY", this.homePosition.m_123342_());
            compound.m_128405_("HomeZ", this.homePosition.m_123343_());
        }
        compound.m_128379_("RequiresSupply", this.requiresSupply);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("EquipmentLevel")) {
            this.equipmentLevel = compound.m_128451_("EquipmentLevel");
        }
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128441_("HomeX")) {
            this.homePosition = new BlockPos(compound.m_128451_("HomeX"), compound.m_128451_("HomeY"), compound.m_128451_("HomeZ"));
        }
        this.requiresSupply = compound.m_128471_("RequiresSupply");
    }
}

