/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywSkeletonArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class HywSkeletonMountedArcherEntity
extends HywSkeletonArcherEntity
implements HorseRider,
CavalryUnit {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.32f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.5f;
    private static final int SWITCH_THRESHOLD = 100;
    private boolean horseSpawned = false;
    private AbstractHorse mountedHorse;
    private UUID horseUUID;
    private CompoundTag savedHorseData;
    private boolean needsHorseSpawn = false;
    private int noTargetTicks = 0;
    private static final double RIDING_OFFSET_FACTOR = 0.4;

    public HywSkeletonMountedArcherEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSkeletonMountedArcherAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.32f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 2.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.getHywTarget() != null) {
                this.noTargetTicks = 0;
                this.setUsingRanged(this.m_20280_((Entity)this.getHywTarget()) > 30.0);
            } else if (!this.isUsingRanged()) {
                ++this.noTargetTicks;
                if (this.noTargetTicks >= 100) {
                    this.setUsingRanged(true);
                    this.noTargetTicks = 0;
                }
            }
        }
        if (!this.m_9236_().f_46443_ && this.needsHorseSpawn && this.m_6084_()) {
            this.spawnHorse();
            this.needsHorseSpawn = false;
        } else if (!this.m_9236_().f_46443_ && !this.horseSpawned && this.m_6084_() && !this.m_20159_()) {
            this.spawnHorse();
        }
        if (!this.m_9236_().f_46443_ && this.horseSpawned && this.mountedHorse == null && this.horseUUID != null) {
            for (Entity entity : this.m_9236_().m_45976_(AbstractHorse.class, this.m_20191_().m_82400_(10.0))) {
                if (!entity.m_20148_().equals(this.horseUUID)) continue;
                this.mountedHorse = (AbstractHorse)entity;
                if (this.m_20159_()) break;
                this.m_7998_((Entity)this.mountedHorse, true);
                break;
            }
        }
    }

    @Override
    public float getAttackReach() {
        if (this.isUsingRanged()) {
            return super.getAttackReach();
        }
        return this.getMeleeAttackReach();
    }

    @Override
    public double getRidingOffsetFactor() {
        return 0.4;
    }

    private void spawnHorse() {
        this.mountedHorse = this.createHorseEntity();
        if (this.mountedHorse != null) {
            this.mountedHorse.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            AbstractHorse abstractHorse = this.mountedHorse;
            if (abstractHorse instanceof BaseCombatSupport) {
                BaseCombatSupport support = (BaseCombatSupport)abstractHorse;
                support.m_30586_(this.m_21805_());
                support.setEquipment(this.getEquipmentLevel());
            }
            if ((abstractHorse = this.mountedHorse) instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)abstractHorse;
                hywHorse.setRiderEntity(this);
                hywHorse.setNpcHorse(true);
            }
            if (this.savedHorseData != null) {
                try {
                    this.mountedHorse.m_7378_(this.savedHorseData);
                    this.savedHorseData = null;
                }
                catch (Exception e) {
                    System.err.println("Failed to restore horse data: " + e.getMessage());
                }
            }
            this.m_9236_().m_7967_((Entity)this.mountedHorse);
            this.m_7998_((Entity)this.mountedHorse, true);
            this.horseSpawned = true;
            this.horseUUID = this.mountedHorse.m_20148_();
        }
    }

    protected AbstractHorse createHorseEntity() {
        return (AbstractHorse)((EntityType)HywEntityRegistry.HYW_SKELETON_HORSE.get()).m_20615_(this.m_9236_());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HorseSpawned", this.horseSpawned);
        if (this.horseUUID != null) {
            compound.m_128362_("HorseUUID", this.horseUUID);
        }
        if (this.savedHorseData != null) {
            compound.m_128365_("SavedHorseData", (Tag)this.savedHorseData);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.horseSpawned = compound.m_128471_("HorseSpawned");
        if (compound.m_128403_("HorseUUID")) {
            this.horseUUID = compound.m_128342_("HorseUUID");
        }
        if (compound.m_128441_("SavedHorseData")) {
            this.savedHorseData = compound.m_128469_("SavedHorseData");
            this.needsHorseSpawn = true;
            this.horseSpawned = false;
        }
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER_3.get();
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        AttributeInstance rangedAttackDamage = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedAttackDamage != null) {
            rangedAttackDamage.m_22100_(rangedAttackDamage.m_22115_() + 0.1);
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            if ((ServerModConfig.INSTANCE.isAllowSoldierRecall() || player.m_7500_() && CreativeModeSettings.canControlAllUnits(player)) && this.getScrollType() != null) {
                return this.handleScrollConversion(player);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    private InteractionResult handleScrollConversion(Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.getScrollType());
        CompoundTag entityData = new CompoundTag();
        if (this.mountedHorse != null && this.mountedHorse.m_6084_()) {
            CompoundTag horseData = new CompoundTag();
            this.m_8127_();
            AbstractHorse abstractHorse = this.mountedHorse;
            if (abstractHorse instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)abstractHorse;
                hywHorse.setRiderEntity(null);
            }
            this.mountedHorse.m_20240_(horseData);
            entityData.m_128365_("SavedHorseData", (Tag)horseData);
            this.mountedHorse.m_146870_();
            this.mountedHorse = null;
        }
        this.m_20240_(entityData);
        ((BaseScrollItem)stack.m_41720_()).saveEntityDataToItem(stack, entityData);
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
        this.spawnDespawnParticles();
        this.m_146870_();
        return InteractionResult.SUCCESS;
    }

    private void spawnDespawnParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 40; ++i) {
                double offsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = this.m_9236_().f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    @Override
    public void addTargetSelector() {
        Predicate<LivingEntity> unifiedPredicate = this::isValidTarget;
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, unifiedPredicate));
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        if (this.mountedHorse != null && this.mountedHorse.m_6084_()) {
            this.mountedHorse.m_6074_();
        }
        super.m_6667_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.mountedHorse != null && this.mountedHorse.m_6084_()) {
            this.mountedHorse.m_6469_(source, 0.0f);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public float getRotationLimit() {
        return 30.0f;
    }
}

