/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.bandits.BanditWarHoundEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditBeastmasterEntity
extends BaseCombatEntity
implements LightUnit {
    private static final int SUMMON_COOLDOWN_TICKS = 300;
    private static final int HOUND_LIFETIME_TICKS = 1200;
    private static final int PACK_SIZE = 8;
    private static final int SUMMON_INTERVAL_TICKS = 8;
    private static final double SUMMON_RADIUS = 2.5;
    private static final double MIN_OBSERVE_DISTANCE = 6.0;
    private static final double MAX_OBSERVE_DISTANCE = 10.0;
    private int summonCooldown = 0;
    private final Set<UUID> activeHounds = new HashSet<UUID>();
    private int pendingSummons = 0;
    private int summonInterval = 0;
    private static final EntityDataAccessor<Boolean> SUMMONING = SynchedEntityData.m_135353_(BanditBeastmasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public BanditBeastmasterEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONING, (Object)false);
    }

    public static AttributeSupplier.Builder createBanditBeastmasterAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), (double)2.2f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.removeAttackGoal();
        this.f_21345_.m_25352_(2, (Goal)new ObserveTargetGoal(this, 1.0, 6.0, 10.0));
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            this.cleanupSummons();
            this.handleSummonSequence();
        }
    }

    private void cleanupSummons() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Iterator<UUID> iterator = this.activeHounds.iterator();
        while (iterator.hasNext()) {
            BanditWarHoundEntity hound;
            UUID id = iterator.next();
            Entity entity = serverLevel.m_8791_(id);
            if (entity instanceof BanditWarHoundEntity && (hound = (BanditWarHoundEntity)entity).m_6084_()) continue;
            iterator.remove();
        }
    }

    private boolean shouldSummonPack() {
        return this.getValidSummonTarget() != null;
    }

    private void handleSummonSequence() {
        if (this.pendingSummons > 0) {
            if (this.summonInterval <= 0) {
                this.summonOne(this.pendingSummons - 1);
                --this.pendingSummons;
                this.summonInterval = 8;
                if (this.pendingSummons == 0) {
                    this.f_19804_.m_135381_(SUMMONING, (Object)false);
                }
            } else {
                --this.summonInterval;
            }
            return;
        }
        if (this.summonCooldown == 0 && this.shouldSummonPack()) {
            this.pendingSummons = 8;
            this.summonInterval = 0;
            this.summonCooldown = 300;
            this.f_19804_.m_135381_(SUMMONING, (Object)true);
        }
    }

    private void summonOne(int indexFromEnd) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity target = this.getHywTarget();
        BlockPos origin = this.m_20183_();
        RandomSource random = this.m_217043_();
        int sequenceIndex = 8 - indexFromEnd - 1;
        BanditWarHoundEntity hound = (BanditWarHoundEntity)((EntityType)HywEntityRegistry.BANDIT_WAR_HOUND.get()).m_20615_(this.m_9236_());
        if (hound == null) {
            return;
        }
        double angle = 0.7853981633974483 * (double)sequenceIndex;
        double radius = Mth.m_216263_((RandomSource)random, (double)1.5, (double)2.5);
        double offsetX = Math.cos(angle += Mth.m_216263_((RandomSource)random, (double)-0.19634954084936207, (double)0.19634954084936207)) * radius;
        double offsetZ = Math.sin(angle) * radius;
        hound.m_7678_((double)origin.m_123341_() + 0.5 + offsetX, origin.m_123342_(), (double)origin.m_123343_() + 0.5 + offsetZ, this.m_146908_(), 0.0f);
        hound.m_30586_(this.m_21805_());
        hound.setHomePosition(origin);
        hound.setRequiresSupply(false);
        hound.setEquipment(1);
        hound.setTemporaryLifetime(1200);
        if (target != null) {
            hound.setHywTarget(target);
        }
        serverLevel.m_7967_((Entity)hound);
        this.activeHounds.add(hound.m_20148_());
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, hound.m_20185_(), hound.m_20186_() + 0.2, hound.m_20189_(), 8, 0.15, 0.0, 0.15, 0.01);
    }

    public boolean isSummoning() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONING);
    }

    private void removeAttackGoal() {
        this.f_21345_.m_148105_().stream().filter(wrapped -> wrapped.m_26015_() instanceof BaseCombatEntityAttackGoal).map(WrappedGoal::m_26015_).toList().forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
    }

    private LivingEntity getValidSummonTarget() {
        LivingEntity target = this.getHywTarget();
        if (target == null || target.m_213877_() || !target.m_6084_()) {
            return null;
        }
        return this.isValidTarget(target) ? target : null;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 6;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 18;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_BANDIT_BEASTMASTER.get();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SummonCooldown", this.summonCooldown);
        compound.m_128405_("ActiveHounds", this.activeHounds.size());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.summonCooldown = compound.m_128451_("SummonCooldown");
        this.activeHounds.clear();
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public int getSkinCounts() {
        return 1;
    }

    private static class ObserveTargetGoal
    extends Goal {
        private final BanditBeastmasterEntity beastmaster;
        private final double speed;
        private final double minDistanceSq;
        private final double maxDistanceSq;

        private ObserveTargetGoal(BanditBeastmasterEntity beastmaster, double speed, double minDistance, double maxDistance) {
            this.beastmaster = beastmaster;
            this.speed = speed;
            this.minDistanceSq = minDistance * minDistance;
            this.maxDistanceSq = maxDistance * maxDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.beastmaster.getHywTarget();
            return target != null && target.m_6084_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.beastmaster.getHywTarget();
            return target != null && target.m_6084_();
        }

        public void m_8041_() {
            this.beastmaster.m_21573_().m_26573_();
        }

        public void m_8037_() {
            LivingEntity target = this.beastmaster.getHywTarget();
            if (target == null) {
                return;
            }
            this.beastmaster.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distanceSq = this.beastmaster.m_20280_((Entity)target);
            if (distanceSq < this.minDistanceSq) {
                double dz;
                double dx = this.beastmaster.m_20185_() - target.m_20185_();
                double len = Math.sqrt(dx * dx + (dz = this.beastmaster.m_20189_() - target.m_20189_()) * dz);
                if (len > 1.0E-4) {
                    double destX = this.beastmaster.m_20185_() + (dx /= len) * 2.0;
                    double destZ = this.beastmaster.m_20189_() + (dz /= len) * 2.0;
                    this.beastmaster.m_21573_().m_26519_(destX, this.beastmaster.m_20186_(), destZ, this.speed);
                }
            } else if (distanceSq > this.maxDistanceSq) {
                this.beastmaster.m_21573_().m_5624_((Entity)target, this.speed);
            } else {
                this.beastmaster.m_21573_().m_26573_();
            }
        }
    }
}

