/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditDemolitionistEntity
extends BaseCombatEntity
implements LightUnit,
PositionAttackable {
    private static final int DETONATION_DELAY = 120;
    private static final EntityDataAccessor<Boolean> PRIMING = SynchedEntityData.m_135353_(BanditDemolitionistEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_POSITION_TARGET = SynchedEntityData.m_135353_(BanditDemolitionistEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int detonationTimer = -1;
    private Vec3 positionTarget;

    public BanditDemolitionistEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createBanditDemolitionistAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.32).m_22268_(Attributes.f_22281_, 200.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22278_, 0.6).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PRIMING, (Object)false);
        this.f_19804_.m_135372_(HAS_POSITION_TARGET, (Object)false);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.85));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.handleDetonation();
        } else if (this.isPriming()) {
            this.spawnSmoke();
        }
    }

    private void handleDetonation() {
        if (this.isPriming()) {
            if (this.detonationTimer > 0) {
                --this.detonationTimer;
            } else if (this.detonationTimer == 0) {
                this.explode();
            }
        } else if (this.shouldPrime()) {
            this.startPriming();
        }
    }

    private boolean shouldPrime() {
        boolean hasEntityTarget = this.getHywTarget() != null && this.m_20280_((Entity)this.getHywTarget()) < 20.25;
        boolean hasPositionTarget = this.hasPositionTarget() && this.positionTarget != null && this.m_20182_().m_82557_(this.positionTarget) < 20.25;
        return hasEntityTarget || hasPositionTarget;
    }

    private void startPriming() {
        this.detonationTimer = 120;
        this.setPriming(true);
        this.m_21573_().m_26573_();
    }

    private void spawnSmoke() {
        float bodyYaw = Mth.m_14189_((float)1.0f, (float)this.f_20884_, (float)this.f_20883_);
        double yawRad = Math.toRadians(bodyYaw);
        double forwardX = -Math.sin(yawRad);
        double forwardZ = Math.cos(yawRad);
        double offsetX = forwardX * 0.5;
        double offsetZ = forwardZ * 0.5;
        double y = this.m_20186_() + 1.5;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, y, this.m_20189_() + offsetZ, 2, 0.05, 0.0, 0.05, 0.01);
        } else {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, y, this.m_20189_() + offsetZ, 0.0, 0.05, 0.0);
        }
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.applyAreaDamage();
        }
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.5f, Level.ExplosionInteraction.MOB);
        this.m_146870_();
    }

    private void applyAreaDamage() {
        double damageRadius = 3.5;
        float damageAmount = (float)this.m_21133_(Attributes.f_22281_);
        AABB damageArea = new AABB(this.m_20185_() - damageRadius, this.m_20186_() - damageRadius, this.m_20189_() - damageRadius, this.m_20185_() + damageRadius, this.m_20186_() + damageRadius, this.m_20189_() + damageRadius);
        Holder.Reference explosionDamageType = this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_);
        DamageSource damageSource = new DamageSource((Holder)explosionDamageType, (Entity)this);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, damageArea)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this || !this.isValidTarget(livingEntity)) continue;
            double distance = livingEntity.m_20182_().m_82554_(this.m_20182_());
            float distanceFactor = Math.max(0.4f, 1.0f - (float)(distance / damageRadius));
            float finalDamage = damageAmount * distanceFactor;
            livingEntity.m_6469_(damageSource, finalDamage);
        }
    }

    @Override
    public void performPositionAttack(Vec3 targetPosition, float pullProgress) {
        if (targetPosition != null && !this.isPriming()) {
            this.startPriming();
        }
    }

    @Override
    public boolean canFireAtPosition(Vec3 targetPosition) {
        return targetPosition != null;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_POSITION_TARGET);
    }

    @Override
    public Vec3 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(Vec3 targetPosition) {
        this.positionTarget = targetPosition;
        this.f_19804_.m_135381_(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
    }

    @Override
    public void PerformRangedAttackBoth(Vec3 targetPosition, LivingEntity target) {
        if (targetPosition == null && target != null) {
            targetPosition = target.m_20182_();
        }
        this.performPositionAttack(targetPosition, 1.0f);
    }

    private void setPriming(boolean priming) {
        this.f_19804_.m_135381_(PRIMING, (Object)priming);
    }

    public boolean isPriming() {
        return (Boolean)this.f_19804_.m_135370_(PRIMING);
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_BANDIT_DEMOLITIONIST.get();
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 10;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 14;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("DetonationTimer", this.detonationTimer);
        compoundTag.m_128379_("Priming", this.isPriming());
        compoundTag.m_128379_("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compoundTag.m_128347_("PositionTargetX", this.positionTarget.f_82479_);
            compoundTag.m_128347_("PositionTargetY", this.positionTarget.f_82480_);
            compoundTag.m_128347_("PositionTargetZ", this.positionTarget.f_82481_);
        }
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.detonationTimer = compoundTag.m_128451_("DetonationTimer");
        this.setPriming(compoundTag.m_128471_("Priming"));
        if (compoundTag.m_128471_("HasPositionTarget")) {
            double x = compoundTag.m_128459_("PositionTargetX");
            double y = compoundTag.m_128459_("PositionTargetY");
            double z = compoundTag.m_128459_("PositionTargetZ");
            this.setPositionTarget(new Vec3(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
    }

    @Override
    public int getSkinCounts() {
        return 1;
    }
}

