/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditWarHoundEntity
extends BaseCombatEntity
implements LightUnit,
CounterLight {
    private static final float ATTACK_REACH = 1.8f;
    private static final float MOVEMENT_SPEED = 0.4f;
    private int lifetimeTicks = -1;

    public BanditWarHoundEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createBanditWarHoundAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), (double)1.8f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.lifetimeTicks >= 0) {
            --this.lifetimeTicks;
            if (this.lifetimeTicks <= 0) {
                this.spawnDismissParticles();
                this.m_146870_();
            }
        }
    }

    private void spawnDismissParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 6, 0.2, 0.0, 0.2, 0.01);
        }
    }

    public void setTemporaryLifetime(int ticks) {
        this.lifetimeTicks = ticks;
    }

    public boolean hasLimitedLifetime() {
        return this.lifetimeTicks >= 0;
    }

    public boolean isHoundSitting() {
        return false;
    }

    public boolean isEnraged() {
        return this.getHywTarget() != null;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.9));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 8;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 4;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 8;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_BANDIT_WAR_HOUND.get();
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.8;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    public float getTailAnimation(float partialTick) {
        return ((float)this.f_19797_ + partialTick) * 0.3f;
    }
}

