/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.utils.ProjectileHitUtils;

public class BulletEntity
extends AbstractArrow {
    public BulletEntity(EntityType<? extends BulletEntity> entityType, LivingEntity livingEntity, Level level) {
        super(entityType, livingEntity, level);
    }

    public BulletEntity(EntityType<BulletEntity> bulletEntityType, Level level) {
        super(bulletEntityType, level);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            if (this.m_9236_() instanceof ServerLevel) {
                Vec3 hitPos = ProjectileHitUtils.getPreciseHitLocation(hitResult, (Projectile)this);
                this.sendParticlesToAllNearby((ServerLevel)this.m_9236_(), ParticleTypes.f_123762_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 8, 0.0, 0.0, 0.0, 0.05);
            }
            if (this.m_36796_() == 0) {
                this.m_146870_();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected ItemStack m_7941_() {
        return null;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12064_;
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 65536.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }
}

