/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.SpringaldBulletEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class SpringaldEntity
extends BaseCombatEntity
implements RangedAttackMob,
SiegeUnit {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.22f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 7.0f;
    private float leftWheelRotation;
    private float rightWheelRotation;
    private static final EntityDataAccessor<Boolean> SHOW_BULLETS = SynchedEntityData.m_135353_(SpringaldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(SpringaldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private int bulletHideTimer = 0;

    public SpringaldEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(SHOW_BULLETS, (Object)true);
    }

    public static AttributeSupplier.Builder createSpringaldAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.22f).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 7.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.bulletHideTimer > 0) {
            --this.bulletHideTimer;
            if (this.bulletHideTimer == 0 && !this.m_9236_().f_46443_) {
                this.setShowBullets(true);
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().m_20183_());
            } else {
                this.setTargetPosition(BlockPos.f_121853_);
            }
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 60;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 2;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return random.nextInt(20);
    }

    @Override
    public float getRotationLimit() {
        return 1.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        if (!this.canFireAtTarget(target)) {
            return;
        }
        SpringaldBulletEntity bullet = new SpringaldBulletEntity((EntityType<? extends SpringaldBulletEntity>)((EntityType)HywEntityRegistry.SPRINGALD_BULLET_ENTITY.get()), (LivingEntity)this, this.m_9236_());
        bullet.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        bullet.m_36767_((byte)3);
        bullet.m_36740_(SoundEvents.f_12514_);
        bullet.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        bullet.m_20242_(false);
        bullet.m_36762_(false);
        bullet.m_36735_(0);
        float yBodyRot = this.getTrueYBodyRot() + 90.0f;
        double offsetX = Math.cos(Math.toRadians(yBodyRot)) * 2.5;
        double offsetZ = Math.sin(Math.toRadians(yBodyRot)) * 2.5;
        bullet.m_6034_(this.m_20185_() + offsetX, this.m_20186_(), this.m_20189_() + offsetZ);
        bullet.m_146884_(bullet.m_20182_().m_82549_(new Vec3(0.0, 1.5, 0.0)));
        double dx = target.m_20185_() - bullet.m_20185_();
        double dz = target.m_20189_() - bullet.m_20189_();
        double dy = target.m_20227_(0.5) - bullet.m_20186_();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 4.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float miss = 1.5f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        double randomSpeedOffset = SpringaldEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
        double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - bullet.m_20185_()) * (predictedX - bullet.m_20185_()) + (predictedZ - bullet.m_20189_()) * (predictedZ - bullet.m_20189_()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[1];
        dx = predictedX - this.m_20185_();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.m_20189_()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        bullet.m_6686_(velocityX, velocityY, velocityZ, speed, miss);
        this.m_5496_(SoundEvents.f_12520_, 5.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)bullet);
        this.setShowBullets(false);
        this.bulletHideTimer = 80;
        this.m_5810_();
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        if (this.isObstructed(target)) {
            return false;
        }
        float allowedRotationDifference = 15.0f;
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        float actualTargetRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = Mth.m_14177_((float)(actualTargetRot - this.currentRot));
        float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        double minimumAttackDistance = 5.0;
        double allowedVerticalDistance = 30.0;
        double distanceToTarget = this.m_20275_(potentialTarget.m_20185_(), potentialTarget.m_20186_(), potentialTarget.m_20189_());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        double verticalDistance = Math.abs(potentialTarget.m_20186_() - this.m_20186_());
        if (verticalDistance > allowedVerticalDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    @Override
    public float getCurrentRot() {
        return this.currentRot;
    }

    @Override
    public float getTargetRot() {
        return this.targetRot;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ShowBullets", this.shouldShowBullets());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ShowBullets")) {
            this.setShowBullets(compound.m_128471_("ShowBullets"));
        }
    }

    public float getLeftWheelRotation() {
        return this.leftWheelRotation;
    }

    public void setLeftWheelRotation(float leftWheelRotation) {
        this.leftWheelRotation = leftWheelRotation;
    }

    public float getRightWheelRotation() {
        return this.rightWheelRotation;
    }

    public void setRightWheelRotation(float rightWheelRotation) {
        this.rightWheelRotation = rightWheelRotation;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SPRINGALD.get();
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    public boolean shouldShowBullets() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_BULLETS);
    }

    public void setShowBullets(boolean showBullets) {
        this.f_19804_.m_135381_(SHOW_BULLETS, (Object)showBullets);
    }
}

