/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.woodelf;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class WoodElfArcherEntity
extends ArcherEntity {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;

    public WoodElfArcherEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createWoodElfArcherAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22276_, 36.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 2.5);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_WOOD_ELF_ARCHER.get();
    }

    @Override
    public int getSkinCounts() {
        return 3;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public void m_6504_(LivingEntity target, float pullProgress) {
        double dy;
        double dz;
        double dx;
        double distance;
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)new ItemStack((ItemLike)Items.f_42412_), (float)pullProgress);
        arrow.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        ItemStack bowStack = this.m_21120_(InteractionHand.MAIN_HAND);
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack);
        int flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if (punchLevel > 0) {
            arrow.m_36735_(punchLevel);
        }
        if (flameLevel > 0) {
            arrow.m_20254_(100);
        }
        if (arrow instanceof Arrow) {
            Arrow tipped = (Arrow)arrow;
            tipped.m_36870_(new MobEffectInstance(MobEffects.f_19614_, 120, 0));
        }
        if ((distance = Math.sqrt((dx = target.m_20185_() - this.m_20185_()) * dx + (dz = target.m_20189_() - this.m_20189_()) * dz + (dy = target.m_20227_(0.5) - arrow.m_20186_()) * dy)) == 0.0) {
            return;
        }
        float speed = 2.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float maxArrowSpeed = 3.0f;
        float miss = 2.5f;
        this.setUseAngle(-1);
        while (speed <= maxArrowSpeed) {
            double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
            if (!(this.isObstructed(target) && !this.m_20159_() && target.m_9236_().m_45527_(target.m_20183_()) || Double.isNaN(angles[1]) && !(distance < 5.0))) {
                angle = angles[1];
                this.setUseAngle(1);
                break;
            }
            if (!Double.isNaN(angles[0]) && this.isPathClear(arrow, angles[0], speed, dx, dy, dz, distance, target)) {
                angle = angles[0];
                this.setUseAngle(0);
                break;
            }
            if (!((speed += 0.25f) > maxArrowSpeed)) continue;
            break;
        }
        if (this.getUseAngle() == -1) {
            return;
        }
        double randomSpeedOffset = ArcherEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
        double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.m_20185_()) * (predictedX - this.m_20185_()) + (predictedZ - this.m_20189_()) * (predictedZ - this.m_20189_()));
        double[] angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[this.getUseAngle()];
        dx = predictedX - this.m_20185_();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.m_20189_()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        if (this.getUseAngle() == 0) {
            miss = 3.5f;
            arrow.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()) * 1.5);
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        arrow.m_6686_((double)velocityX, (double)velocityY, (double)velocityZ, speed, miss);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
        this.m_5810_();
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }
}

