/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.MinerEntity;

public class MinerActivateWorkstationGoal
extends Goal {
    private final MinerEntity miner;
    private final int searchRange;
    private BlockPos targetWorkstation;
    private int workCooldown;
    private int searchCooldown;
    private int armSwingCooldown;
    private static final int MIN_WORK_INTERVAL = 10;
    private static final int MAX_WORK_INTERVAL = 30;
    private static final int SEARCH_COOLDOWN = 30;
    private static final int ARM_SWING_INTERVAL = 5;
    private static final int ARM_SWING_RANDOMNESS = 2;
    private final Random random = new Random();

    public MinerActivateWorkstationGoal(MinerEntity miner, int searchRange) {
        this.miner = miner;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.miner.commandHold() || this.miner.isOnStrike()) {
            return false;
        }
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        if (this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation)) {
            return true;
        }
        this.targetWorkstation = this.miner.findNearestWorkstation();
        return this.targetWorkstation != null;
    }

    public boolean m_8045_() {
        if (this.miner.commandHold() || this.miner.isOnStrike()) {
            return false;
        }
        return this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation);
    }

    private boolean isWorkstationValid(BlockPos pos) {
        if (this.miner.m_9236_() == null) {
            return false;
        }
        BlockEntity blockEntity = this.miner.m_9236_().m_7702_(pos);
        return blockEntity instanceof MiningWorkstationBlockEntity;
    }

    public void m_8056_() {
        if (this.targetWorkstation != null) {
            PathNavigation navigation = this.miner.m_21573_();
            navigation.m_26519_((double)this.targetWorkstation.m_123341_() + 0.5, (double)this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5, 1.0);
            this.resetWorkCooldown();
            this.armSwingCooldown = 5 + this.random.nextInt(5) - 2;
        }
    }

    public void m_8037_() {
        if (this.targetWorkstation == null) {
            return;
        }
        double distanceToWorkstation = this.miner.m_20275_((double)this.targetWorkstation.m_123341_() + 0.5, this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5);
        if (distanceToWorkstation <= 9.0) {
            if (this.armSwingCooldown > 0) {
                --this.armSwingCooldown;
            } else {
                this.miner.m_6674_(InteractionHand.MAIN_HAND);
                this.armSwingCooldown = 5 + this.random.nextInt(5) - 2;
            }
            if (this.workCooldown > 0) {
                --this.workCooldown;
            } else {
                this.triggerWorkstationWork();
                this.resetWorkCooldown();
            }
            this.miner.m_21573_().m_26573_();
        } else {
            PathNavigation navigation = this.miner.m_21573_();
            if (navigation.m_26571_()) {
                navigation.m_26519_((double)this.targetWorkstation.m_123341_() + 0.5, (double)this.targetWorkstation.m_123342_(), (double)this.targetWorkstation.m_123343_() + 0.5, 1.0);
            }
        }
    }

    private void resetWorkCooldown() {
        this.workCooldown = this.miner.m_217043_().m_188503_(21) + 10;
    }

    private void triggerWorkstationWork() {
        BlockEntity blockEntity = this.miner.m_9236_().m_7702_(this.targetWorkstation);
        if (blockEntity instanceof MiningWorkstationBlockEntity) {
            MiningWorkstationBlockEntity workstation = (MiningWorkstationBlockEntity)blockEntity;
            workstation.triggerWork();
        }
    }

    public void m_8041_() {
        this.searchCooldown = 30;
        this.targetWorkstation = null;
        this.miner.m_21573_().m_26573_();
    }
}

