/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.generation.PregenManager;
import ydmsama.hundred_years_war.main.generation.StructureLocationGenerator;
import ydmsama.hundred_years_war.main.generation.StructurePlacementHelper;
import ydmsama.hundred_years_war.main.generation.StructurePosition;
import ydmsama.hundred_years_war.main.generation.StructurePositionResolver;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.BuildTemplateService;
import ydmsama.hundred_years_war.main.template.BuildingTask;
import ydmsama.hundred_years_war.main.template.BuildingTaskManager;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;
import ydmsama.hundred_years_war.main.template.PlacedBuildingRegistry;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class InstGenManager
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstGenManager.class);
    private static final String DATA_NAME = "hundred_years_war_inst_gen";
    public static final boolean ENABLE_CONSOLE_OUTPUT = false;
    private static final int SAVE_INTERVAL_TICKS = 200;
    private static final int CHUNK_TICKET_LEVEL = 2;
    private static final TicketType<Long> STRUCTURE_TICKET = TicketType.m_9462_((String)"hundred_years_war_structure_inst", Long::compare);
    private static final int GRID_SIZE = StructureLocationGenerator.getGridSize();
    private final Map<Long, StructureRecord> records = new HashMap<Long, StructureRecord>();
    private final Set<Long> evaluatedGrids = new HashSet<Long>();
    private final Map<UUID, Long> activeTasks = new HashMap<UUID, Long>();
    private transient StructurePositionResolver positionResolver;
    private transient ServerLevel cachedLevel;
    private transient boolean runtimeInitialized = false;
    private long lastTickProcessed = -1L;
    private long lastSaveGameTime = 0L;
    private boolean instGenEnabled = true;

    public InstGenManager() {
    }

    public InstGenManager(CompoundTag tag) {
        ListTag list = tag.m_128437_("structures", 10);
        for (int i = 0; i < list.size(); ++i) {
            StructureRecord record = StructureRecord.fromTag(list.m_128728_(i));
            this.records.put(record.gridKey, record);
            this.evaluatedGrids.add(record.gridKey);
        }
        this.lastTickProcessed = tag.m_128454_("lastTickProcessed");
        this.lastSaveGameTime = tag.m_128454_("lastSaveGameTime");
        this.instGenEnabled = !tag.m_128441_("instGenEnabled") || tag.m_128471_("instGenEnabled");
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (StructureRecord record : this.records.values()) {
            list.add((Object)record.save());
        }
        tag.m_128365_("structures", (Tag)list);
        tag.m_128356_("lastTickProcessed", this.lastTickProcessed);
        tag.m_128356_("lastSaveGameTime", this.lastSaveGameTime);
        tag.m_128379_("instGenEnabled", this.instGenEnabled);
        return tag;
    }

    public synchronized void initialize(ServerLevel level) {
        if (this.runtimeInitialized) {
            this.cachedLevel = level;
            return;
        }
        this.cachedLevel = level;
        this.positionResolver = new StructurePositionResolver(level);
        this.restoreRuntimeState(level);
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        registry.ensureLegacySweep(level);
        this.pruneLegacyBlockedRecords(registry);
        this.runtimeInitialized = true;
    }

    public void tick(ServerLevel level) {
        if (level == null) {
            return;
        }
        if (!this.runtimeInitialized) {
            this.initialize(level);
        }
        this.cachedLevel = level;
        long gameTime = level.m_46467_();
        if (gameTime == this.lastTickProcessed) {
            return;
        }
        this.lastTickProcessed = gameTime;
        this.processImmediateStructures(level);
        this.monitorActiveTasks(level);
        if (gameTime - this.lastSaveGameTime >= 200L) {
            this.lastSaveGameTime = gameTime;
            this.m_77762_();
        }
    }

    public synchronized void shutdown() {
        this.runtimeInitialized = false;
        this.cachedLevel = null;
    }

    public String getStats() {
        long completed = this.records.values().stream().filter(r -> r.status == Status.COMPLETED).count();
        long failed = this.records.values().stream().filter(r -> r.status == Status.FAILED).count();
        long active = this.activeTasks.size();
        long queued = this.records.values().stream().filter(r -> r.status == Status.DISCOVERED).count();
        return String.format(Locale.ROOT, "\u7ed3\u6784\u603b\u6570: %d | \u5b8c\u6210: %d | \u5931\u8d25: %d | \u6d3b\u8dc3\u4efb\u52a1: %d | \u5f85\u5904\u7406: %d | \u5373\u65f6\u751f\u6210: %s | \u4ec5\u9884\u8f7d\u6a21\u5f0f: %s", this.records.size(), completed, failed, active, queued, this.instGenEnabled ? "\u5f00\u542f" : "\u5173\u95ed");
    }

    public synchronized StructureRecord ensureRecord(ServerLevel level, StructurePosition position, boolean markNearPriority) {
        int gridZ;
        if (position == null) {
            return null;
        }
        int gridX = this.gridCoord(position.getPosition().m_123341_());
        long key = InstGenManager.gridKey(gridX, gridZ = this.gridCoord(position.getPosition().m_123343_()));
        StructureRecord record = this.records.get(key);
        if (record == null) {
            record = new StructureRecord(position);
            record.discoveryGameTime = level != null ? level.m_46467_() : 0L;
            record.nearPriority = markNearPriority;
            this.records.put(key, record);
            this.evaluatedGrids.add(key);
            this.m_77762_();
        } else if (markNearPriority && !record.nearPriority) {
            record.nearPriority = true;
            this.m_77762_();
        }
        return record;
    }

    public synchronized StructureRecord getRecord(long gridKey) {
        return this.records.get(gridKey);
    }

    public synchronized StructureRecord getRecord(int gridX, int gridZ) {
        return this.records.get(InstGenManager.gridKey(gridX, gridZ));
    }

    public synchronized List<StructureRecord> getAllRecordsSnapshot() {
        return List.copyOf(this.records.values());
    }

    public synchronized void markDirtyExternal() {
        this.m_77762_();
    }

    public synchronized void registerTask(StructureRecord record, UUID taskId) {
        if (record == null) {
            return;
        }
        if (!this.records.containsKey(record.gridKey)) {
            this.records.put(record.gridKey, record);
        }
        record.taskId = taskId;
        if (taskId != null) {
            record.status = Status.TASK_CREATED;
            record.taskPlacementStartNanos = System.nanoTime();
            record.placementLogged = false;
            this.activeTasks.put(taskId, record.gridKey);
        }
        this.m_77762_();
    }

    public synchronized void clearTaskTracking(UUID taskId) {
        if (taskId != null) {
            this.activeTasks.remove(taskId);
        }
    }

    public synchronized void markFailure(StructureRecord record, String reason) {
        if (record == null) {
            return;
        }
        this.recordFailure(record, reason);
    }

    public synchronized boolean hasRunningTasks() {
        for (StructureRecord record : this.records.values()) {
            if (record.taskId == null || record.status == Status.COMPLETED || record.status == Status.FAILED) continue;
            return true;
        }
        return false;
    }

    public synchronized List<String> getRunningTaskSummaries() {
        ArrayList<String> summaries = new ArrayList<String>();
        for (StructureRecord record : this.records.values()) {
            if (record.taskId == null || record.status != Status.TASK_CREATED) continue;
            BlockPos pos = record.anchorPos != null ? record.anchorPos : new BlockPos(record.worldX, record.worldY, record.worldZ);
            summaries.add(String.format(Locale.ROOT, "\u6a21\u677f:%s | \u7f51\u683c:(%d,%d) | \u4f4d\u7f6e:(%d,%d,%d) | \u4efb\u52a1ID:%s", record.templateId, record.gridX, record.gridZ, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), record.taskId));
        }
        return summaries;
    }

    public boolean isEnabled() {
        return this.instGenEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(this.cachedLevel, enabled);
    }

    public void setEnabled(ServerLevel level, boolean enabled) {
        if (this.instGenEnabled == enabled) {
            return;
        }
        this.instGenEnabled = enabled;
        if (!enabled) {
            this.releaseAllTickets(level);
        }
        this.m_77762_();
        InstGenManager.logInfo(this, "InstGen\u7cfb\u7edf\u5df2{}", enabled ? "\u542f\u7528" : "\u7981\u7528");
    }

    public List<StructurePosition> getStructuresInRange(BlockPos center, int radius) {
        if (this.records.isEmpty()) {
            return Collections.emptyList();
        }
        double radiusSqr = Mth.m_144944_((int)radius);
        ArrayList<StructurePosition> result = new ArrayList<StructurePosition>();
        for (StructureRecord record : this.records.values()) {
            double dz;
            BlockPos blockPos = record.anchorPos != null ? record.anchorPos : new BlockPos(record.worldX, record.worldY, record.worldZ);
            BlockPos pos = blockPos;
            double dx = (double)pos.m_123341_() + 0.5 - (double)center.m_123341_();
            double distanceSqr = dx * dx + (dz = (double)pos.m_123343_() + 0.5 - (double)center.m_123343_()) * dz;
            if (!(distanceSqr <= radiusSqr)) continue;
            result.add(new StructurePosition(pos, record.templateId, record.rotation, record.mirror, record.generationSeed));
        }
        result.sort(Comparator.comparingDouble(sp -> sp.getPosition().m_123331_((Vec3i)center)));
        return result;
    }

    private void processImmediateStructures(ServerLevel level) {
        int gridZ;
        if (!this.instGenEnabled || level.m_6907_().isEmpty()) {
            return;
        }
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        registry.ensureLegacySweep(level);
        int renderDistanceBlocks = level.m_7654_().m_6846_().m_11312_() * 16;
        if (renderDistanceBlocks <= 0) {
            return;
        }
        HashSet<Long> candidateGridKeys = new HashSet<Long>();
        HashSet<Long> visibleChunkKeys = new HashSet<Long>();
        int renderDistanceChunks = level.m_7654_().m_6846_().m_11312_();
        for (ServerPlayer player : level.m_6907_()) {
            int minGridX = this.gridCoord(player.m_146903_() - renderDistanceBlocks);
            int maxGridX = this.gridCoord(player.m_146903_() + renderDistanceBlocks);
            int minGridZ = this.gridCoord(player.m_146907_() - renderDistanceBlocks);
            int maxGridZ = this.gridCoord(player.m_146907_() + renderDistanceBlocks);
            for (int gridX = minGridX; gridX <= maxGridX; ++gridX) {
                for (gridZ = minGridZ; gridZ <= maxGridZ; ++gridZ) {
                    candidateGridKeys.add(InstGenManager.gridKey(gridX, gridZ));
                }
            }
            ChunkPos playerChunk = player.m_146902_();
            int minChunkX = playerChunk.f_45578_ - renderDistanceChunks;
            int maxChunkX = playerChunk.f_45578_ + renderDistanceChunks;
            int minChunkZ = playerChunk.f_45579_ - renderDistanceChunks;
            int maxChunkZ = playerChunk.f_45579_ + renderDistanceChunks;
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    long chunkKey = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
                    visibleChunkKeys.add(chunkKey);
                    int baseBlockX = chunkX << 4;
                    int baseBlockZ = chunkZ << 4;
                    int chunkGridX = this.gridCoord(baseBlockX);
                    int chunkGridZ = this.gridCoord(baseBlockZ);
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            candidateGridKeys.add(InstGenManager.gridKey(chunkGridX + dx, chunkGridZ + dz));
                        }
                    }
                }
            }
        }
        if (candidateGridKeys.isEmpty() && visibleChunkKeys.isEmpty()) {
            return;
        }
        HashSet<Long> recordsToProcess = new HashSet<Long>();
        Iterator<Object> iterator = candidateGridKeys.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            if (registry.isLegacyGridBlocked(key)) continue;
            StructureRecord record = this.records.get(key);
            if (record == null) {
                if (this.evaluatedGrids.contains(key) || this.positionResolver == null) continue;
                ChunkPos gridPos = new ChunkPos(key);
                int gridX = gridPos.f_45578_;
                gridZ = gridPos.f_45579_;
                this.evaluatedGrids.add(key);
                StructurePosition position = this.positionResolver.getStructureAt(gridX, gridZ);
                if (position == null) continue;
                record = new StructureRecord(position);
                record.discoveryGameTime = level.m_46467_();
                record.status = Status.DISCOVERED;
                record.nearPriority = true;
                this.records.put(record.gridKey, record);
                this.m_77762_();
            } else {
                if (record.status == Status.COMPLETED || record.status == Status.FAILED || registry.isLegacyGridBlocked(record.gridKey)) continue;
                if (!record.nearPriority) {
                    record.nearPriority = true;
                    this.m_77762_();
                }
            }
            recordsToProcess.add(record.gridKey);
        }
        if (!visibleChunkKeys.isEmpty()) {
            block8: for (StructureRecord record : this.records.values()) {
                List<ChunkPos> coverage;
                if (record.status == Status.COMPLETED || record.status == Status.FAILED || registry.isLegacyGridBlocked(record.gridKey) || recordsToProcess.contains(record.gridKey) || (coverage = this.getImmediateChunkCoverage(record)).isEmpty()) continue;
                for (ChunkPos chunkPos : coverage) {
                    if (!visibleChunkKeys.contains(ChunkPos.m_45589_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_))) continue;
                    if (!record.nearPriority) {
                        record.nearPriority = true;
                        this.m_77762_();
                    }
                    recordsToProcess.add(record.gridKey);
                    continue block8;
                }
            }
        }
        iterator = recordsToProcess.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            StructureRecord record = this.records.get(key);
            if (record == null) continue;
            this.ensureImmediateCompletion(level, record);
        }
    }

    private void ensureImmediateCompletion(ServerLevel level, StructureRecord record) {
        long creationDurationMs;
        if (record.status == Status.COMPLETED || record.status == Status.FAILED) {
            return;
        }
        this.setInstGenClaim(record, true);
        PregenManager pregenManager = PregenManager.get(level);
        if (pregenManager != null) {
            pregenManager.cancelTask(record.gridKey, "\u5373\u65f6\u751f\u6210\u63a5\u7ba1", true);
        }
        record.nearPriority = true;
        if (record.taskId != null) {
            this.fastCompleteExistingTask(level, record);
            return;
        }
        TemplateMetadata metadata = TemplateManager.getInstance().getMetadata(record.templateId);
        if (metadata == null) {
            this.recordFailure(record, "Template metadata not found (instgen)");
            return;
        }
        HywStructureTemplate template = TemplateManager.getInstance().loadTemplate(record.templateId);
        if (template == null) {
            this.recordFailure(record, "Template data not found (instgen)");
            return;
        }
        List<ChunkPos> requiredChunks = this.getImmediateChunkCoverage(record, metadata, template);
        if (!requiredChunks.isEmpty() && !this.areChunksLoaded(level, requiredChunks)) {
            if (record.chunkPositions == null) {
                this.applyChunkTickets(level, record, requiredChunks);
            }
            return;
        }
        BlockPos basePos = new BlockPos(record.worldX, record.worldY, record.worldZ);
        BlockPos placement = StructurePlacementHelper.computePlacementPosition(level, basePos, metadata, record.generationSeed);
        if (placement == null) {
            this.recordFailure(record, "Placement position unavailable (instgen)");
            return;
        }
        record.anchorPos = placement;
        record.worldX = placement.m_123341_();
        record.worldY = placement.m_123342_();
        record.worldZ = placement.m_123343_();
        record.chunkPreloadDurationMs = 0L;
        record.taskCreationStartNanos = System.nanoTime();
        BuildTemplateService.BuildResult result = BuildTemplateService.createBuildingTaskWithResult(level, record.templateId, placement, record.rotation, 0.0f, 0L, "SYSTEM", template.getConnectionLayerDepth() > 0, true);
        record.taskCreationDurationMs = creationDurationMs = (System.nanoTime() - record.taskCreationStartNanos) / 1000000L;
        record.taskCreationStartNanos = -1L;
        if (!result.isSuccess()) {
            String failure = result.details != null ? result.details : result.failureReason.name();
            this.recordFailure(record, "Failed to create task: " + failure);
            return;
        }
        record.taskId = result.taskId;
        record.registeredBuildingId = result.buildingId;
        record.status = Status.TASK_CREATED;
        record.taskPlacementStartNanos = System.nanoTime();
        record.placementLogged = false;
        this.activeTasks.put(result.taskId, record.gridKey);
        this.m_77762_();
        InstGenManager.logInfo(this, "InstGen | \u5f00\u59cb\u5efa\u7b51\u4efb\u52a1 | \u4f4d\u7f6e:({},{},{}) | ID:{} \u7c7b\u578b:{}", placement.m_123341_(), placement.m_123342_(), placement.m_123343_(), result.taskId, record.templateId);
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        BuildingTask task = taskManager.getTask(result.taskId);
        if (task != null) {
            task.enableFastTrack();
        }
    }

    private void fastCompleteExistingTask(ServerLevel level, StructureRecord record) {
        if (record.taskId == null) {
            return;
        }
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(record.taskId);
        if (status == null) {
            record.taskId = null;
            record.status = Status.COMPLETED;
            this.releaseChunkTickets(record);
            this.m_77762_();
            return;
        }
        if (status.completed || status.failed) {
            return;
        }
        BuildingTask task = taskManager.getTask(record.taskId);
        if (task != null) {
            task.enableFastTrack();
        }
    }

    private void monitorActiveTasks(ServerLevel level) {
        if (this.activeTasks.isEmpty()) {
            return;
        }
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        Iterator<Map.Entry<UUID, Long>> iterator = this.activeTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            UUID taskId = entry.getKey();
            Long key = entry.getValue();
            StructureRecord record = this.records.get(key);
            if (record == null) {
                iterator.remove();
                continue;
            }
            BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(taskId);
            if (status == null) {
                record.status = Status.COMPLETED;
                record.taskId = null;
                record.taskPlacementStartNanos = -1L;
                this.releaseChunkTickets(record);
                iterator.remove();
                this.m_77762_();
                continue;
            }
            if (status.failed) {
                record.placementLogged = true;
                record.taskPlacementStartNanos = -1L;
                this.recordFailure(record, status.failureReason != null ? status.failureReason : "Unknown failure");
                record.taskId = null;
                iterator.remove();
                continue;
            }
            if (!status.completed) continue;
            if (!record.placementLogged) {
                BlockPos pos = record.anchorPos != null ? record.anchorPos : new BlockPos(record.worldX, record.worldY, record.worldZ);
                InstGenManager.logInfo(this, "InstGen | \u7ed3\u675f\u5efa\u7b51\u4efb\u52a1 | \u4f4d\u7f6e:({},{},{}) | ID:{} \u7c7b\u578b:{}", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), taskId, record.templateId);
                record.placementLogged = true;
            }
            record.taskPlacementStartNanos = -1L;
            record.status = Status.COMPLETED;
            record.taskId = null;
            this.releaseChunkTickets(record);
            record.registeredBuildingId = null;
            iterator.remove();
            this.m_77762_();
        }
    }

    private boolean areChunksLoaded(ServerLevel level, List<ChunkPos> chunkPositions) {
        for (ChunkPos chunkPos : chunkPositions) {
            if (level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)) continue;
            return false;
        }
        return true;
    }

    private void applyChunkTickets(ServerLevel level, StructureRecord record, List<ChunkPos> chunkPositions) {
        if (record.chunkPositions != null) {
            return;
        }
        for (ChunkPos chunkPos : chunkPositions) {
            level.m_7726_().m_8387_(STRUCTURE_TICKET, chunkPos, 2, (Object)record.gridKey);
        }
        record.chunkPositions = List.copyOf(chunkPositions);
    }

    private void releaseChunkTickets(StructureRecord record) {
        if (this.cachedLevel == null || record.chunkPositions == null) {
            record.chunkPositions = null;
            return;
        }
        ServerChunkCache chunkSource = this.cachedLevel.m_7726_();
        for (ChunkPos chunkPos : record.chunkPositions) {
            chunkSource.m_8438_(STRUCTURE_TICKET, chunkPos, 2, (Object)record.gridKey);
        }
        record.chunkPositions = null;
    }

    private List<ChunkPos> getImmediateChunkCoverage(StructureRecord record) {
        TemplateMetadata metadata = TemplateManager.getInstance().getMetadata(record.templateId);
        HywStructureTemplate template = metadata != null ? TemplateManager.getInstance().loadTemplate(record.templateId) : null;
        return this.getImmediateChunkCoverage(record, metadata, template);
    }

    private List<ChunkPos> getImmediateChunkCoverage(StructureRecord record, TemplateMetadata metadata, HywStructureTemplate template) {
        if (record.immediateChunkCache != null) {
            return record.immediateChunkCache;
        }
        if (metadata == null) {
            record.immediateChunkCache = Collections.emptyList();
            return record.immediateChunkCache;
        }
        List<ChunkPos> chunks = StructurePlacementHelper.computeChunkCoverage(record.worldX, record.worldZ, record.rotation, metadata, template);
        record.immediateChunkCache = chunks.isEmpty() ? Collections.emptyList() : List.copyOf(chunks);
        return record.immediateChunkCache;
    }

    private void recordFailure(StructureRecord record, String reason) {
        record.status = Status.FAILED;
        this.setInstGenClaim(record, false);
        record.failureReason = reason;
        this.cleanupRegisteredBuilding(record.registeredBuildingId);
        record.registeredBuildingId = null;
        this.releaseChunkTickets(record);
        this.m_77762_();
        InstGenManager.logWarn(this, "InstGen | Structure at {} failed: {}", record.anchorSummary(), reason);
    }

    public synchronized boolean isGridClaimed(long gridKey) {
        StructureRecord record = this.records.get(gridKey);
        return record != null && record.instGenClaimed && record.status != Status.FAILED;
    }

    private void setInstGenClaim(StructureRecord record, boolean claimed) {
        if (record == null || record.instGenClaimed == claimed) {
            return;
        }
        record.instGenClaimed = claimed;
        this.m_77762_();
    }

    private static boolean shouldLog(InstGenManager manager) {
        return false;
    }

    private static void logInfo(InstGenManager manager, String message, Object ... args) {
        if (InstGenManager.shouldLog(manager)) {
            LOGGER.info(message, args);
        }
    }

    private static void logWarn(InstGenManager manager, String message, Object ... args) {
        if (InstGenManager.shouldLog(manager)) {
            LOGGER.warn(message, args);
        }
    }

    private static void debug(String message, Object ... args) {
        if (!PregenManager.isDebugLoggingEnabled()) {
            return;
        }
        LOGGER.info("[InstGenDebug] " + message, args);
    }

    private void cleanupRegisteredBuilding(UUID buildingId) {
        ServerLevel level = this.cachedLevel;
        if (level == null || buildingId == null) {
            return;
        }
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        PlacedBuilding building = registry.getBuilding(buildingId);
        if (building != null && registry.removeBuilding(buildingId)) {
            ServerPacketHandler.broadcastBuildingUpdate(level, building, true);
        }
    }

    private static long gridKey(int gridX, int gridZ) {
        return ChunkPos.m_45589_((int)gridX, (int)gridZ);
    }

    private int gridCoord(int blockCoord) {
        return Math.floorDiv(blockCoord, GRID_SIZE);
    }

    private void pruneLegacyBlockedRecords(PlacedBuildingRegistry registry) {
        if (registry == null || this.records.isEmpty()) {
            return;
        }
        boolean updated = false;
        for (StructureRecord record : this.records.values()) {
            if (!registry.isLegacyGridBlocked(record.gridKey) || record.status == Status.FAILED) continue;
            record.status = Status.FAILED;
            record.failureReason = "Skipped because chunk existed before mod installation";
            updated = true;
        }
        if (updated) {
            this.m_77762_();
        }
    }

    private void restoreRuntimeState(ServerLevel level) {
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        this.activeTasks.clear();
        for (StructureRecord record : this.records.values()) {
            record.chunkPositions = null;
            record.chunkPreloadDurationMs = -1L;
            record.taskCreationStartNanos = -1L;
            record.taskCreationDurationMs = -1L;
            record.taskPlacementStartNanos = -1L;
            record.placementLogged = false;
            record.immediateChunkCache = null;
            record.anchorPos = new BlockPos(record.worldX, record.worldY, record.worldZ);
            if (record.status != Status.TASK_CREATED) continue;
            if (record.taskId != null) {
                BuildingTaskManager.BuildingTaskStatus status = taskManager.getTaskStatus(record.taskId);
                if (status == null || status.completed) {
                    record.status = Status.COMPLETED;
                    record.taskId = null;
                    this.m_77762_();
                    continue;
                }
                if (status.failed) {
                    this.recordFailure(record, status.failureReason != null ? status.failureReason : "Task failed");
                    record.taskId = null;
                    continue;
                }
                this.activeTasks.put(record.taskId, record.gridKey);
                record.taskPlacementStartNanos = System.nanoTime();
                continue;
            }
            record.status = Status.COMPLETED;
            this.m_77762_();
        }
    }

    private void releaseAllTickets(ServerLevel level) {
        ServerLevel effectiveLevel;
        ServerLevel serverLevel = effectiveLevel = level != null ? level : this.cachedLevel;
        if (effectiveLevel == null) {
            return;
        }
        for (StructureRecord record : this.records.values()) {
            if (record.chunkPositions == null) continue;
            this.cachedLevel = effectiveLevel;
            this.releaseChunkTickets(record);
        }
    }

    public static InstGenManager get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (InstGenManager)storage.m_164861_(InstGenManager::new, InstGenManager::new, DATA_NAME);
    }

    public static InstGenManager get(MinecraftServer server) {
        return InstGenManager.get(server.m_129783_());
    }

    static class StructureRecord {
        final int gridX;
        final int gridZ;
        final long gridKey;
        final String templateId;
        final int rotation;
        final boolean mirror;
        final long generationSeed;
        int worldX;
        int worldY;
        int worldZ;
        boolean nearPriority = false;
        long discoveryGameTime = 0L;
        UUID taskId = null;
        Status status = Status.DISCOVERED;
        String failureReason = null;
        boolean instGenClaimed = false;
        UUID registeredBuildingId = null;
        transient List<ChunkPos> chunkPositions;
        transient BlockPos anchorPos;
        transient long chunkPreloadDurationMs = -1L;
        transient long taskCreationStartNanos = -1L;
        transient long taskCreationDurationMs = -1L;
        transient long taskPlacementStartNanos = -1L;
        transient boolean placementLogged = false;
        transient List<ChunkPos> immediateChunkCache = null;

        StructureRecord(StructurePosition position) {
            this.gridX = StructureRecord.gridCoordFromPosition(position.getPosition().m_123341_());
            this.gridZ = StructureRecord.gridCoordFromPosition(position.getPosition().m_123343_());
            this.gridKey = InstGenManager.gridKey(this.gridX, this.gridZ);
            this.templateId = position.getTemplateId();
            this.rotation = position.getRotation();
            this.mirror = position.isMirror();
            this.generationSeed = position.getGenerationSeed();
            this.worldX = position.getPosition().m_123341_();
            this.worldY = position.getPosition().m_123342_();
            this.worldZ = position.getPosition().m_123343_();
            this.anchorPos = new BlockPos(this.worldX, this.worldY, this.worldZ);
        }

        StructureRecord(int gridX, int gridZ, String templateId, int rotation, boolean mirror, long generationSeed, int worldX, int worldY, int worldZ, boolean nearPriority, Status status, UUID taskId, String failureReason, long discoveryGameTime, boolean instGenClaimed, UUID registeredBuildingId) {
            this.gridX = gridX;
            this.gridZ = gridZ;
            this.gridKey = InstGenManager.gridKey(gridX, gridZ);
            this.templateId = templateId;
            this.rotation = rotation;
            this.mirror = mirror;
            this.generationSeed = generationSeed;
            this.worldX = worldX;
            this.worldY = worldY;
            this.worldZ = worldZ;
            this.nearPriority = nearPriority;
            this.status = status;
            this.taskId = taskId;
            this.failureReason = failureReason;
            this.discoveryGameTime = discoveryGameTime;
            this.instGenClaimed = instGenClaimed;
            this.anchorPos = new BlockPos(this.worldX, this.worldY, this.worldZ);
            this.registeredBuildingId = registeredBuildingId;
        }

        CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("gridX", this.gridX);
            tag.m_128405_("gridZ", this.gridZ);
            tag.m_128359_("templateId", this.templateId);
            tag.m_128405_("rotation", this.rotation);
            tag.m_128379_("mirror", this.mirror);
            tag.m_128356_("generationSeed", this.generationSeed);
            tag.m_128405_("worldX", this.worldX);
            tag.m_128405_("worldY", this.worldY);
            tag.m_128405_("worldZ", this.worldZ);
            tag.m_128379_("nearPriority", this.nearPriority);
            tag.m_128359_("status", this.status.name());
            tag.m_128379_("instGenClaimed", this.instGenClaimed);
            if (this.taskId != null) {
                tag.m_128362_("taskId", this.taskId);
            }
            if (this.failureReason != null) {
                tag.m_128359_("failureReason", this.failureReason);
            }
            tag.m_128356_("discoveryTime", this.discoveryGameTime);
            if (this.registeredBuildingId != null) {
                tag.m_128362_("buildingId", this.registeredBuildingId);
            }
            return tag;
        }

        static StructureRecord fromTag(CompoundTag tag) {
            int gridX = tag.m_128451_("gridX");
            int gridZ = tag.m_128451_("gridZ");
            String templateId = tag.m_128461_("templateId");
            int rotation = tag.m_128451_("rotation");
            boolean mirror = tag.m_128471_("mirror");
            long generationSeed = tag.m_128454_("generationSeed");
            int worldX = tag.m_128451_("worldX");
            int worldY = tag.m_128451_("worldY");
            int worldZ = tag.m_128451_("worldZ");
            boolean nearPriority = tag.m_128471_("nearPriority");
            Status status = Status.valueOf(tag.m_128461_("status"));
            UUID taskId = tag.m_128441_("taskId") ? tag.m_128342_("taskId") : null;
            String failureReason = tag.m_128441_("failureReason") ? tag.m_128461_("failureReason") : null;
            long discoveryTime = tag.m_128454_("discoveryTime");
            boolean instGenClaimed = tag.m_128441_("instGenClaimed") && tag.m_128471_("instGenClaimed");
            UUID buildingId = tag.m_128441_("buildingId") ? tag.m_128342_("buildingId") : null;
            return new StructureRecord(gridX, gridZ, templateId, rotation, mirror, generationSeed, worldX, worldY, worldZ, nearPriority, status, taskId, failureReason, discoveryTime, instGenClaimed, buildingId);
        }

        String anchorSummary() {
            return "(" + this.worldX + "," + this.worldY + "," + this.worldZ + ")";
        }

        static int gridCoordFromPosition(int blockCoord) {
            return Math.floorDiv(blockCoord, GRID_SIZE);
        }
    }

    static enum Status {
        DISCOVERED,
        TASK_CREATED,
        COMPLETED,
        FAILED;

    }
}

