/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.data.TransportData;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;

public class TransportOrderItem
extends Item {
    public TransportOrderItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos == null) {
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.not_bound"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            BlockEntity blockEntity = level.m_7702_(boundPos);
            if (!(blockEntity instanceof TransportWorkstationBlockEntity)) {
                stack.m_41749_("BoundPos");
                stack.m_41749_("TransportData");
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.workstation_not_found"), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            ServerPacketHandler.sendOpenTransportOrderSync(serverPlayer, hand, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static void handleKeyAction(ServerPlayer player, ItemStack stack) {
        Level level = player.m_9236_();
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        BlockPos targetPos = blockHit.m_82425_();
        Direction side = blockHit.m_82434_();
        BlockEntity blockEntity = level.m_7702_(targetPos);
        if (blockEntity instanceof TransportWorkstationBlockEntity) {
            TransportWorkstationBlockEntity workstation = (TransportWorkstationBlockEntity)blockEntity;
            BlockPos boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos == null) {
                TransportOrderItem.bindToWorkstation(stack, targetPos);
                TransportData workstationData = workstation.getTransportData();
                TransportOrderItem.setTransportData(stack, workstationData);
                player.m_150109_().m_6596_();
                player.m_5661_((Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.bound", (Object[])new Object[]{targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()}), true);
            } else {
                if (boundPos.equals((Object)targetPos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.cannot_target_self"), true);
                    return;
                }
                BlockEntity boundEntity = level.m_7702_(boundPos);
                if (!(boundEntity instanceof TransportWorkstationBlockEntity)) {
                    player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.invalid_bound"), true);
                    return;
                }
                TransportWorkstationBlockEntity boundWorkstation = (TransportWorkstationBlockEntity)boundEntity;
                TransportData data = TransportOrderItem.getTransportData(stack);
                if (data.addRoute(boundPos, targetPos, null, TransportData.TransportMode.DEPOSIT)) {
                    TransportOrderItem.setTransportData(stack, data);
                    boundWorkstation.setTransportData(data);
                    player.m_150109_().m_6596_();
                    player.m_5661_((Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.target_added", (Object[])new Object[]{targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()}), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.distance_too_far"), true);
                }
            }
        } else if (blockEntity instanceof Container || blockEntity instanceof WarehouseControlBlockEntity) {
            BlockPos boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos == null) {
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.not_bound"), true);
                return;
            }
            BlockEntity boundEntity = level.m_7702_(boundPos);
            if (!(boundEntity instanceof TransportWorkstationBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.invalid_bound"), true);
                return;
            }
            TransportWorkstationBlockEntity boundWorkstation = (TransportWorkstationBlockEntity)boundEntity;
            TransportData data = TransportOrderItem.getTransportData(stack);
            if (data.addRoute(boundPos, targetPos, null, TransportData.TransportMode.DEPOSIT)) {
                TransportOrderItem.setTransportData(stack, data);
                boundWorkstation.setTransportData(data);
                player.m_150109_().m_6596_();
                player.m_5661_((Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.target_added", (Object[])new Object[]{targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_()}), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.distance_too_far"), true);
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.invalid_target"), true);
        }
    }

    public static void bindToWorkstation(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_("BoundPos", pos.m_121878_());
    }

    public static BlockPos getBoundWorkstation(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("BoundPos")) {
            return BlockPos.m_122022_((long)tag.m_128454_("BoundPos"));
        }
        return null;
    }

    public static TransportData getTransportData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("TransportData")) {
            TransportData data = new TransportData();
            data.deserializeNBT(tag.m_128469_("TransportData"));
            return data;
        }
        return new TransportData();
    }

    public static void setTransportData(ItemStack stack, TransportData data) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("TransportData", (Tag)data.serializeNBT());
    }

    public static List<BlockPos> getPositionsForRender(ItemStack stack) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        TransportData data = TransportOrderItem.getTransportData(stack);
        for (TransportData.TransportRoute route : data.getRoutes()) {
            positions.add(route.getTargetPos());
        }
        return positions;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (level != null && level.f_46443_) {
            TransportOrderItem.addWrappedTooltip(tooltip, (Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.usage"));
            BlockPos boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos != null) {
                TransportOrderItem.addWrappedTooltip(tooltip, (Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.bound", (Object[])new Object[]{boundPos.m_123341_(), boundPos.m_123342_(), boundPos.m_123343_()}));
            } else {
                TransportOrderItem.addWrappedTooltip(tooltip, (Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.not_bound"));
            }
            TransportData data = TransportOrderItem.getTransportData(stack);
            if (!data.isEmpty()) {
                TransportOrderItem.addWrappedTooltip(tooltip, (Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.routes", (Object[])new Object[]{data.getRoutes().size()}));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.usage"));
            BlockPos boundPos = TransportOrderItem.getBoundWorkstation(stack);
            if (boundPos != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.bound", (Object[])new Object[]{boundPos.m_123341_(), boundPos.m_123342_(), boundPos.m_123343_()}));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.transport_order.not_bound"));
            }
            TransportData data = TransportOrderItem.getTransportData(stack);
            if (!data.isEmpty()) {
                tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.transport_order.routes", (Object[])new Object[]{data.getRoutes().size()}));
            }
        }
    }

    private static void addWrappedTooltip(List<Component> tooltip, Component component) {
        try {
            Class<?> helperClass = Class.forName("ydmsama.hundred_years_war.client.utils.TooltipHelper");
            Method method = helperClass.getMethod("addToTooltip", List.class, Component.class);
            method.invoke(null, tooltip, component);
        }
        catch (Exception e) {
            tooltip.add(component);
        }
    }
}

