/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

@Mixin(value={LivingEntity.class})
public class LivingEntityHurtMixin {
    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void handleNeutralAttackRelation(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        int damageCount;
        Projectile projectile;
        TamableAnimal tamable;
        TamableAnimal tamable2;
        LivingEntity victim = (LivingEntity)this;
        if (victim.m_9236_().f_46443_ || source.m_7639_() == null) {
            return;
        }
        UUID victimOwnerUUID = null;
        if (victim instanceof Player) {
            Player player = (Player)victim;
            victimOwnerUUID = player.m_20148_();
        } else if (victim instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)victim;
            victimOwnerUUID = baseCombatEntity.m_21805_();
        } else if (victim instanceof TamableAnimal && (tamable2 = (TamableAnimal)victim).m_21824_()) {
            victimOwnerUUID = tamable2.m_21805_();
        } else {
            return;
        }
        if (victimOwnerUUID == null) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        UUID attackerOwnerUUID = null;
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            attackerOwnerUUID = player.m_20148_();
        } else if (sourceEntity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)sourceEntity;
            attackerOwnerUUID = baseCombatEntity.m_21805_();
        } else if (sourceEntity instanceof TamableAnimal && (tamable = (TamableAnimal)sourceEntity).m_21824_()) {
            attackerOwnerUUID = tamable.m_21805_();
        } else if (sourceEntity instanceof Projectile && (projectile = (Projectile)sourceEntity).m_19749_() instanceof LivingEntity) {
            TamableAnimal tamable3;
            Entity owner = projectile.m_19749_();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                attackerOwnerUUID = player.m_20148_();
            } else if (owner instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity = (BaseCombatEntity)owner;
                attackerOwnerUUID = baseCombatEntity.m_21805_();
            } else if (owner instanceof TamableAnimal && (tamable3 = (TamableAnimal)owner).m_21824_()) {
                attackerOwnerUUID = tamable3.m_21805_();
            }
        }
        if (attackerOwnerUUID != null && !attackerOwnerUUID.equals(victimOwnerUUID) && ServerRelationHelper.isNeutralRelationByUUID(victimOwnerUUID, attackerOwnerUUID) && (damageCount = RelationSystem.recordDamage(attackerOwnerUUID, victimOwnerUUID)) >= 3) {
            RelationSystem.setRelation(victimOwnerUUID, attackerOwnerUUID, RelationSystem.RelationType.HOSTILE);
            System.out.println("\u56e0\u591a\u6b21\u53d7\u5230\u653b\u51fb\uff0c" + victimOwnerUUID + " \u73b0\u5728\u5bf9 " + attackerOwnerUUID + " \u662f\u654c\u5bf9\u5173\u7cfb");
        }
    }
}

