/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.ServerManager;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;
import ydmsama.hundred_years_war.main.utils.VanillaTeamUuidCache;

@Mixin(value={Scoreboard.class})
public abstract class ScoreboardMixin {
    @Inject(method={"addPlayerToTeam"}, at={@At(value="RETURN")}, cancellable=false)
    private void hyw_onJoin(String playerName, PlayerTeam team, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        ServerPlayer player = ServerManager.getPlayerByName(playerName);
        if (player == null) {
            return;
        }
        UUID teamUuid = VanillaTeamUuidCache.get(team.m_5758_());
        RelationSystem.joinTeam(player.m_20148_(), teamUuid, TeamRelationData.MemberType.MEMBER);
    }

    @Inject(method={"removePlayerFromTeam(Ljava/lang/String;)Z"}, at={@At(value="RETURN")})
    private void hyw_onQuit(String playerName, CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        ServerPlayer player = ServerManager.getPlayerByName(playerName);
        if (player == null) {
            return;
        }
        PlayerTeam team = ((Scoreboard)this).m_83500_(playerName);
        if (team == null) {
            return;
        }
        UUID teamUuid = VanillaTeamUuidCache.get(team.m_5758_());
        RelationSystem.leaveTeam(player.m_20148_(), teamUuid);
    }
}

