/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.mixins.MobAccessor;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

@Mixin(value={TamableAnimal.class})
public abstract class TamableAnimalMixin
extends Mob {
    protected TamableAnimalMixin() {
        super(null, null);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onTamableInit(CallbackInfo ci) {
        TamableAnimal tamable = (TamableAnimal)this;
        GoalSelector targetSelector = ((MobAccessor)tamable).getTargetSelector();
        Predicate<LivingEntity> targetPredicate = target -> {
            boolean isValidTarget;
            Player player;
            if (!tamable.m_21824_() || tamable.m_21805_() == null) {
                return false;
            }
            UUID ownerUUID = tamable.m_21805_();
            if (target == tamable) {
                return false;
            }
            if (target instanceof Player && (player = (Player)target).m_20148_().equals(ownerUUID)) {
                return false;
            }
            boolean bl = isValidTarget = target instanceof BaseCombatEntity || target instanceof TamableAnimal || target instanceof Player;
            if (!isValidTarget) {
                return false;
            }
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                UUID targetUUID = targetPlayer.m_20148_();
                return ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID);
            }
            if (target instanceof BaseCombatEntity) {
                BaseCombatEntity combatEntity = (BaseCombatEntity)target;
                UUID targetUUID = combatEntity.m_21805_();
                if (targetUUID == null) {
                    return true;
                }
                return ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID);
            }
            if (target instanceof TamableAnimal) {
                TamableAnimal targetTamable = (TamableAnimal)target;
                if (!targetTamable.m_21824_()) {
                    return false;
                }
                UUID targetUUID = targetTamable.m_21805_();
                if (targetUUID == null) {
                    return false;
                }
                return ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID);
            }
            return false;
        };
        targetSelector.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)tamable, LivingEntity.class, 10, false, false, targetPredicate));
    }

    @Inject(method={"canAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkCanAttackModEntities(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        TamableAnimal tamable = (TamableAnimal)this;
        UUID ownerUUID = tamable.m_21805_();
        if (ownerUUID == null) {
            return;
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            UUID targetUUID = targetPlayer.m_20148_();
            if (!ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID)) {
                cir.setReturnValue((Object)false);
            }
        } else if (target instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)target;
            UUID targetUUID = combatEntity.m_21805_();
            if (targetUUID == null) {
                return;
            }
            if (!ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID)) {
                cir.setReturnValue((Object)false);
            }
        } else if (target instanceof TamableAnimal) {
            TamableAnimal targetTamable = (TamableAnimal)target;
            if (!targetTamable.m_21824_()) {
                return;
            }
            UUID targetUUID = targetTamable.m_21805_();
            if (targetUUID == null) {
                cir.setReturnValue((Object)false);
            } else if (!ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"wantsToAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkWantsToAttackModEntities(LivingEntity target, LivingEntity owner, CallbackInfoReturnable<Boolean> cir) {
        UUID ownerUUID = null;
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        ownerUUID = player.m_20148_();
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            UUID targetUUID = targetPlayer.m_20148_();
            boolean isEnemy = ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID);
            cir.setReturnValue((Object)isEnemy);
        } else if (target instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)target;
            UUID targetUUID = combatEntity.m_21805_();
            if (targetUUID == null) {
                cir.setReturnValue((Object)true);
            } else {
                boolean isEnemy = ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID);
                cir.setReturnValue((Object)isEnemy);
            }
        } else if (target instanceof TamableAnimal) {
            TamableAnimal targetTamable = (TamableAnimal)target;
            if (!targetTamable.m_21824_()) {
                return;
            }
            UUID targetUUID = targetTamable.m_21805_();
            if (targetUUID == null) {
                cir.setReturnValue((Object)false);
            } else {
                boolean isEnemy = ServerRelationHelper.isEnemyRelationByUUID(ownerUUID, targetUUID);
                cir.setReturnValue((Object)isEnemy);
            }
        }
    }
}

