/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.AttackStrategy;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class AttackStrategyUpdatePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "attack_strategy_update");
    private final String strategyId;

    public AttackStrategyUpdatePacket(String strategyId) {
        this.strategyId = strategyId;
    }

    public static void encode(AttackStrategyUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.strategyId);
    }

    public static AttackStrategyUpdatePacket decode(FriendlyByteBuf buf) {
        return new AttackStrategyUpdatePacket(buf.m_130277_());
    }

    private static void handlePacket(ServerPlayer player, AttackStrategyUpdatePacket packet) {
        AttackStrategy strategy = AttackStrategy.fromId(packet.strategyId);
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        if (selection == null) {
            return;
        }
        selection.refreshEntities();
        for (BaseCombatEntity entity : selection.getEntities()) {
            entity.setAttackStrategy(strategy);
        }
    }

    public static void handle(AttackStrategyUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                AttackStrategyUpdatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

