/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.MoveToBlockGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

public class CommandStaffMovePacket {
    private final UUID staffUUID;
    private final BlockPos targetPos;
    private final int priority;
    private final boolean formationMode;
    private final String formationType;

    public CommandStaffMovePacket(UUID staffUUID, BlockPos targetPos, int priority, boolean formationMode, String formationType) {
        this.staffUUID = staffUUID;
        this.targetPos = targetPos;
        this.priority = priority;
        this.formationMode = formationMode;
        this.formationType = formationType;
    }

    public CommandStaffMovePacket(UUID staffUUID, BlockPos targetPos, int priority, boolean formationMode) {
        this(staffUUID, targetPos, priority, formationMode, "loose");
    }

    public static void encode(CommandStaffMovePacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.staffUUID);
        buf.m_130064_(packet.targetPos);
        buf.writeInt(packet.priority);
        buf.writeBoolean(packet.formationMode);
        buf.m_130070_(packet.formationType);
    }

    public static CommandStaffMovePacket decode(FriendlyByteBuf buf) {
        UUID staffUUID = buf.m_130259_();
        BlockPos targetPos = buf.m_130135_();
        int priority = buf.readInt();
        boolean formationMode = buf.readBoolean();
        String formationType = buf.m_130277_();
        return new CommandStaffMovePacket(staffUUID, targetPos, priority, formationMode, formationType);
    }

    public static void handle(CommandStaffMovePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                CommandStaffMovePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, CommandStaffMovePacket packet) {
        ServerLevel level = player.m_284548_();
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        UUID staffUUID = packet.staffUUID;
        BlockPos targetPos = packet.targetPos;
        int priority = packet.priority;
        boolean formationMode = packet.formationMode;
        ItemStack staffItem = CommandStaffMovePacket.findCommandStaffItem(player, staffUUID);
        if (staffItem.m_41619_()) {
            return;
        }
        CompoundTag nbt = staffItem.m_41784_();
        if (priority == 1) {
            nbt.m_128473_("AttackTargetEntity");
            nbt.m_128473_("AttackMoveBlockPos");
            posTag = new CompoundTag();
            posTag.m_128405_("X", targetPos.m_123341_());
            posTag.m_128405_("Y", targetPos.m_123342_());
            posTag.m_128405_("Z", targetPos.m_123343_());
            nbt.m_128365_("TargetBlockPos", (Tag)posTag);
        } else if (priority == 3) {
            nbt.m_128473_("TargetBlockPos");
            nbt.m_128473_("AttackTargetEntity");
            posTag = new CompoundTag();
            posTag.m_128405_("X", targetPos.m_123341_());
            posTag.m_128405_("Y", targetPos.m_123342_());
            posTag.m_128405_("Z", targetPos.m_123343_());
            nbt.m_128365_("AttackMoveBlockPos", (Tag)posTag);
        }
        staffItem.m_41751_(nbt);
        if (nbt.m_128425_("TeamEntityUUIDs", 9)) {
            ListTag uuidList = nbt.m_128437_("TeamEntityUUIDs", 8);
            ArrayList<BaseCombatEntity> teamEntities = new ArrayList<BaseCombatEntity>();
            for (int i = 0; i < uuidList.size(); ++i) {
                String uuidString = uuidList.m_128778_(i);
                try {
                    UUID entityUUID = UUID.fromString(uuidString);
                    Entity entity = level.m_8791_(entityUUID);
                    if (!(entity instanceof BaseCombatEntity)) continue;
                    BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                    teamEntities.add(combatEntity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!teamEntities.isEmpty()) {
                registry.clearTasksForEntities(teamEntities);
                if (formationMode && teamEntities.size() > 1) {
                    FormationManager.commandStaffFormMove(targetPos, priority, teamEntities, packet.formationType);
                } else {
                    UUID formationUUID = UUID.randomUUID();
                    double totalArea = teamEntities.stream().mapToDouble(BaseCombatEntity::getUnitOccupiedArea).sum();
                    for (BaseCombatEntity entity : teamEntities) {
                        entity.setHywTarget(null);
                        double homeReturnRadius = Math.max(Math.sqrt(totalArea / Math.PI), entity.getDefaultHomeReturnRadius());
                        entity.setHomeReturnRadius(homeReturnRadius);
                        MoveToBlockGoal moveGoal = new MoveToBlockGoal(entity, 1.0, formationUUID);
                        moveGoal.setTargetPos(targetPos);
                        entity.clearCommandedGoals();
                        entity.addCustomGoal(priority, moveGoal);
                    }
                }
            }
        }
    }

    private static ItemStack findCommandStaffItem(ServerPlayer player, UUID staffUUID) {
        CompoundTag tag;
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof CommandStaffItem && (tag = mainHandItem.m_41783_()) != null && tag.m_128403_("ItemUUID") && tag.m_128342_("ItemUUID").equals(staffUUID)) {
            return mainHandItem;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            CompoundTag tag2;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof CommandStaffItem) || (tag2 = stack.m_41783_()) == null || !tag2.m_128403_("ItemUUID") || !tag2.m_128342_("ItemUUID").equals(staffUUID)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

