/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.utils.PlayerSettingsManager;

public class FormationSelectionUpdatePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "formation_selection_update");
    private final String currentFormation;
    private final String lastNonNoneFormation;

    public FormationSelectionUpdatePacket(String currentFormation, String lastNonNoneFormation) {
        this.currentFormation = currentFormation;
        this.lastNonNoneFormation = lastNonNoneFormation;
    }

    public static void encode(FormationSelectionUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.currentFormation);
        buf.m_130070_(packet.lastNonNoneFormation);
    }

    public static FormationSelectionUpdatePacket decode(FriendlyByteBuf buf) {
        String current = buf.m_130277_();
        String last = buf.m_130277_();
        return new FormationSelectionUpdatePacket(current, last);
    }

    private static void handlePacket(ServerPlayer player, FormationSelectionUpdatePacket packet) {
        PlayerSettingsManager.updateFormation(player.m_20148_(), packet.currentFormation, packet.lastNonNoneFormation);
    }

    public static void handle(FormationSelectionUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                FormationSelectionUpdatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

