/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class OpenTransportOrderSyncPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "open_transport_order_sync");
    private final UUID requestId;
    private final ItemStack itemStack;

    public OpenTransportOrderSyncPacket(UUID requestId, ItemStack itemStack) {
        this.requestId = requestId;
        this.itemStack = itemStack.m_41777_();
    }

    public static void encode(OpenTransportOrderSyncPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.requestId);
        buf.m_130055_(packet.itemStack);
    }

    public static OpenTransportOrderSyncPacket decode(FriendlyByteBuf buf) {
        UUID requestId = buf.m_130259_();
        ItemStack stack = buf.m_130267_();
        return new OpenTransportOrderSyncPacket(requestId, stack);
    }

    public static void handle(OpenTransportOrderSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> OpenTransportOrderSyncPacket.handlePacket(packet)));
        context.setPacketHandled(true);
    }

    private static void handlePacket(OpenTransportOrderSyncPacket packet) {
        ClientPacketHandler.onOpenTransportOrderSync(packet);
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

