/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.utils.PlayerSettingsManager;

public class RecruitmentConfigUpdatePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "recruitment_config_update");
    private final String categoryId;
    private final String unitTypeId;
    private final int level;

    public RecruitmentConfigUpdatePacket(String categoryId, String unitTypeId, int level) {
        this.categoryId = categoryId;
        this.unitTypeId = unitTypeId;
        this.level = level;
    }

    public static void encode(RecruitmentConfigUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.categoryId);
        buf.m_130070_(packet.unitTypeId);
        buf.writeInt(packet.level);
    }

    public static RecruitmentConfigUpdatePacket decode(FriendlyByteBuf buf) {
        String categoryId = buf.m_130277_();
        String unitTypeId = buf.m_130277_();
        int level = buf.readInt();
        return new RecruitmentConfigUpdatePacket(categoryId, unitTypeId, level);
    }

    private static void handlePacket(ServerPlayer player, RecruitmentConfigUpdatePacket packet) {
        if (RecruitmentConfigManager.canPlayerRecruit((Player)player, packet.categoryId, packet.unitTypeId, packet.level)) {
            PlayerRecruitmentData.RecruitmentSelection selection = new PlayerRecruitmentData.RecruitmentSelection();
            selection.setCategoryId(packet.categoryId);
            selection.setUnitTypeId(packet.unitTypeId);
            selection.setLevel(packet.level);
            PlayerRecruitmentData.setPlayerSelection((Player)player, selection);
            PlayerSettingsManager.updateRecruitment(player.m_20148_(), selection);
            System.out.println("\u73a9\u5bb6 " + player.m_7755_().getString() + " \u66f4\u65b0\u62db\u52df\u914d\u7f6e\u4e3a: " + packet.categoryId + "/" + packet.unitTypeId + "/" + packet.level);
        } else {
            System.out.println("\u73a9\u5bb6 " + player.m_7755_().getString() + " \u5c1d\u8bd5\u9009\u62e9\u65e0\u6548\u7684\u62db\u52df\u914d\u7f6e: " + packet.categoryId + "/" + packet.unitTypeId + "/" + packet.level);
        }
    }

    public static void handle(RecruitmentConfigUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                RecruitmentConfigUpdatePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getUnitTypeId() {
        return this.unitTypeId;
    }

    public int getLevel() {
        return this.level;
    }
}

