/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.SiegeMode;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class SiegeModeTogglePacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "siege_mode_toggle");
    private final boolean siegeModeActive;

    public SiegeModeTogglePacket(boolean siegeModeActive) {
        this.siegeModeActive = siegeModeActive;
    }

    public boolean isSiegeModeActive() {
        return this.siegeModeActive;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.siegeModeActive);
    }

    public static SiegeModeTogglePacket decode(FriendlyByteBuf buf) {
        boolean siegeModeActive = buf.readBoolean();
        return new SiegeModeTogglePacket(siegeModeActive);
    }

    public static void handlePacket(ServerPlayer player, SiegeModeTogglePacket packet) {
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        if (selection != null) {
            List<UUID> entityUUIDs = selection.getEntityUUIDs();
            for (UUID uuid : entityUUIDs) {
                Entity entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
                if (!(entity instanceof SiegeMode)) continue;
                if (entity instanceof BaseCombatEntity) {
                    BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearPatrolPoints();
                }
                ((SiegeMode)entity).setSiegeModeEnabled(packet.siegeModeActive);
            }
        }
    }

    public static void handle(SiegeModeTogglePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                SiegeModeTogglePacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }
}

