/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;

public class SupplyTransferPacket {
    private final BlockPos blockPos;
    private final double amount;
    private final boolean isDeposit;

    public SupplyTransferPacket(BlockPos blockPos, double amount, boolean isDeposit) {
        this.blockPos = blockPos;
        this.amount = amount;
        this.isDeposit = isDeposit;
    }

    public static void encode(SupplyTransferPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
        buf.writeDouble(packet.amount);
        buf.writeBoolean(packet.isDeposit);
    }

    public static SupplyTransferPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        double amount = buf.readDouble();
        boolean isDeposit = buf.readBoolean();
        return new SupplyTransferPacket(pos, amount, isDeposit);
    }

    public static void handle(SupplyTransferPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                SupplyTransferPacket.handlePacket(player, packet);
            }
        });
        context.setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, SupplyTransferPacket packet) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(packet.blockPos);
        if (!(blockEntity instanceof SupplyPointBlockEntity)) {
            return;
        }
        SupplyPointBlockEntity supplyPoint = (SupplyPointBlockEntity)blockEntity;
        if (!supplyPoint.m_6542_((Player)player)) {
            return;
        }
        if (!supplyPoint.canPlayerAccess((Player)player)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.supply_point.cannot_access"), true);
            return;
        }
        SupplyManager.SupplySource playerSource = SupplyManager.getSupplySource(player.m_20148_());
        if (playerSource == null) {
            SupplyManager.registerSupplySource(player.m_20148_(), SupplyManager.SupplySourceType.PLAYER, 1000.0);
            playerSource = SupplyManager.getSupplySource(player.m_20148_());
        }
        if (playerSource != null && playerSource.getOwnerId() == null) {
            SupplyManager.setSupplySourceOwner(player.m_20148_(), player.m_20148_());
        }
        if (packet.isDeposit) {
            double toDeposit;
            if (playerSource != null && (toDeposit = Math.min(packet.amount, playerSource.getSupplyValue())) > 0.0) {
                playerSource.consumeSupply(toDeposit);
                supplyPoint.depositSupply(toDeposit);
            }
        } else {
            double withdrawn = supplyPoint.withdrawSupply(packet.amount);
            if (playerSource != null && withdrawn > 0.0) {
                playerSource.addSupply(withdrawn);
            }
        }
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public double getAmount() {
        return this.amount;
    }

    public boolean isDeposit() {
        return this.isDeposit;
    }
}

