/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamManageRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "team_manage");
    private final UUID teamUUID;
    private final String actionType;
    private final UUID targetUUID;

    public TeamManageRequestPacket(UUID teamUUID, String actionType, UUID targetUUID) {
        this.teamUUID = teamUUID;
        this.actionType = actionType;
        this.targetUUID = targetUUID;
    }

    public TeamManageRequestPacket(FriendlyByteBuf buf) {
        this.teamUUID = buf.m_130259_();
        this.actionType = buf.m_130277_();
        this.targetUUID = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.teamUUID);
        buf.m_130070_(this.actionType);
        buf.m_130077_(this.targetUUID);
    }

    public static TeamManageRequestPacket decode(FriendlyByteBuf buf) {
        return new TeamManageRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getActionType() {
        return this.actionType;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public static void handle(TeamManageRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                TeamManageRequestPacket.handlePacket(player, packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, TeamManageRequestPacket packet) {
        UUID playerUUID = player.m_20148_();
        UUID teamUUID = packet.getTeamUUID();
        String actionType = packet.getActionType();
        UUID targetUUID = packet.getTargetUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.team_not_found"));
            return;
        }
        TeamRelationData.MemberType playerMemberType = teamData.getMemberType(playerUUID);
        if (playerMemberType != TeamRelationData.MemberType.OWNER && playerMemberType != TeamRelationData.MemberType.ADMIN) {
            player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.no_permission"));
            return;
        }
        boolean success = false;
        String messageKey = "";
        switch (actionType) {
            case "accept": {
                if (teamData.hasApplication(targetUUID)) {
                    success = teamData.approveApplication(targetUUID, TeamRelationData.MemberType.MEMBER);
                    messageKey = "message.hundred_years_war.application_accepted";
                    if (!success) break;
                    RelationSystem.joinTeam(targetUUID, teamUUID, TeamRelationData.MemberType.MEMBER);
                    ServerPlayer targetPlayer = player.m_20194_().m_6846_().m_11259_(targetUUID);
                    if (targetPlayer == null) break;
                    targetPlayer.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.join_accepted", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.no_application";
                break;
            }
            case "reject": {
                if (teamData.hasApplication(targetUUID)) {
                    ServerPlayer targetPlayer;
                    success = teamData.rejectApplication(targetUUID);
                    messageKey = "message.hundred_years_war.application_rejected";
                    if (!success || (targetPlayer = player.m_20194_().m_6846_().m_11259_(targetUUID)) == null) break;
                    targetPlayer.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.join_rejected", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.no_application";
                break;
            }
            case "promote": {
                if (playerMemberType != TeamRelationData.MemberType.OWNER) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.owner_only"));
                    return;
                }
                if (teamData.isMember(targetUUID)) {
                    ServerPlayer targetPlayer;
                    success = teamData.updateMemberType(targetUUID, TeamRelationData.MemberType.ADMIN);
                    messageKey = "message.hundred_years_war.promote_success";
                    if (!success || (targetPlayer = player.m_20194_().m_6846_().m_11259_(targetUUID)) == null) break;
                    targetPlayer.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.promoted", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.not_a_member";
                break;
            }
            case "demote": {
                if (playerMemberType != TeamRelationData.MemberType.OWNER) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.owner_only"));
                    return;
                }
                if (teamData.isMember(targetUUID) && teamData.getMemberType(targetUUID) == TeamRelationData.MemberType.ADMIN) {
                    ServerPlayer targetPlayer;
                    success = teamData.updateMemberType(targetUUID, TeamRelationData.MemberType.MEMBER);
                    messageKey = "message.hundred_years_war.demote_success";
                    if (!success || (targetPlayer = player.m_20194_().m_6846_().m_11259_(targetUUID)) == null) break;
                    targetPlayer.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.demoted", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.not_admin";
                break;
            }
            case "remove": {
                if (playerMemberType == TeamRelationData.MemberType.ADMIN && teamData.isMember(targetUUID) && teamData.getMemberType(targetUUID) == TeamRelationData.MemberType.ADMIN) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.cannot_remove_admin"));
                    return;
                }
                if (teamData.isMember(targetUUID) && teamData.getMemberType(targetUUID) == TeamRelationData.MemberType.OWNER) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.cannot_remove_owner"));
                    return;
                }
                if (teamData.isMember(targetUUID)) {
                    success = teamData.removeMember(targetUUID);
                    messageKey = "message.hundred_years_war.remove_success";
                    if (!success) break;
                    RelationSystem.setRelation(targetUUID, teamUUID, RelationSystem.RelationType.NEUTRAL);
                    ServerPlayer targetPlayer = player.m_20194_().m_6846_().m_11259_(targetUUID);
                    if (targetPlayer == null) break;
                    targetPlayer.m_213846_((Component)Component.m_237110_((String)"message.hundred_years_war.removed_from_team", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.not_a_member";
                break;
            }
            default: {
                player.m_213846_((Component)Component.m_237115_((String)"message.hundred_years_war.unknown_action"));
                return;
            }
        }
        if (!messageKey.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)messageKey));
        }
        TeamInfoRequestPacket.handlePacket(player);
    }
}

