/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.TemplateManager;

public final class TemplateListRequestPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "template_list_request");

    public static void encode(TemplateListRequestPacket packet, FriendlyByteBuf buf) {
    }

    public static TemplateListRequestPacket decode(FriendlyByteBuf buf) {
        return new TemplateListRequestPacket();
    }

    public static void handle(TemplateListRequestPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                TemplateListRequestPacket.handlePacket(player);
            }
        });
        context.setPacketHandled(true);
    }

    private static void handlePacket(ServerPlayer player) {
        TemplateManager manager = TemplateManager.getInstance();
        if (manager == null) {
            return;
        }
        if (!manager.isInitialized()) {
            try {
                manager.initialize(player.f_8924_);
            }
            catch (Exception e) {
                player.m_213846_((Component)Component.m_237113_((String)("Failed to load templates on server: " + e.getMessage())));
                ServerPacketHandler.sendTemplateList(player, Collections.emptyList());
                return;
            }
        } else {
            manager.rescanTemplates();
        }
        ServerPacketHandler.sendTemplateList(player, manager.getAllMetadata());
    }
}

