/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class UnloadPassengersPacket {
    public static final ResourceLocation ID = new ResourceLocation("hundred_years_war", "unload_passengers");
    private final Vec3 position;
    private final boolean cancel;
    private final boolean queueMode;

    public UnloadPassengersPacket(Vec3 position, boolean cancel, boolean queueMode) {
        this.position = position;
        this.cancel = cancel;
        this.queueMode = queueMode;
    }

    public UnloadPassengersPacket(FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        this.cancel = buf.readBoolean();
        this.queueMode = buf.readBoolean();
        this.position = this.cancel ? null : new Vec3(x, y, z);
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean isQueueMode() {
        return this.queueMode;
    }

    public void encode(FriendlyByteBuf buf) {
        if (this.position != null) {
            buf.writeDouble(this.position.f_82479_);
            buf.writeDouble(this.position.f_82480_);
            buf.writeDouble(this.position.f_82481_);
        } else {
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
        }
        buf.writeBoolean(this.cancel);
        buf.writeBoolean(this.queueMode);
    }

    public static UnloadPassengersPacket decode(FriendlyByteBuf buf) {
        return new UnloadPassengersPacket(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                UnloadPassengersPacket.handlePacket(player, this);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacket(ServerPlayer player, UnloadPassengersPacket packet) {
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        if (selection != null) {
            List<UUID> entityUUIDs = selection.getEntityUUIDs();
            for (UUID uuid : entityUUIDs) {
                BaseCombatEntity combatEntity;
                Entity entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
                if (!(entity instanceof UnloadPassengerable)) continue;
                UnloadPassengerable unloadPassengerable = (UnloadPassengerable)entity;
                if (!packet.queueMode && entity instanceof BaseCombatEntity) {
                    combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearCommandedGoals();
                }
                if (entity instanceof BaseCombatEntity) {
                    combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearPatrolPoints();
                }
                if (packet.isCancel()) {
                    unloadPassengerable.setUnloadTarget(null);
                    continue;
                }
                unloadPassengerable.setUnloadTarget(packet.getPosition());
            }
        }
    }
}

