/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;

public class WarehouseRangeUpdatePacket {
    private final BlockPos pos;
    private final int left;
    private final int right;
    private final int up;
    private final int down;
    private final boolean showRange;

    public WarehouseRangeUpdatePacket(BlockPos pos, int left, int right, int up, int down, boolean showRange) {
        this.pos = pos;
        this.left = left;
        this.right = right;
        this.up = up;
        this.down = down;
        this.showRange = showRange;
    }

    public static void encode(WarehouseRangeUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.left);
        buf.writeInt(packet.right);
        buf.writeInt(packet.up);
        buf.writeInt(packet.down);
        buf.writeBoolean(packet.showRange);
    }

    public static WarehouseRangeUpdatePacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int left = buf.readInt();
        int right = buf.readInt();
        int up = buf.readInt();
        int down = buf.readInt();
        boolean showRange = buf.readBoolean();
        return new WarehouseRangeUpdatePacket(pos, left, right, up, down, showRange);
    }

    public static void handle(WarehouseRangeUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            WarehouseControlBlockEntity warehouse;
            BlockEntity blockEntity;
            ServerPlayer player = context.getSender();
            if (player != null && (blockEntity = player.m_9236_().m_7702_(packet.pos)) instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((Player)player)) {
                warehouse.setWorkRangeLeft(packet.left);
                warehouse.setWorkRangeRight(packet.right);
                warehouse.setWorkRangeUp(packet.up);
                warehouse.setWorkRangeDown(packet.down);
                warehouse.setShowRange(packet.showRange);
                warehouse.m_6596_();
            }
        });
        context.setPacketHandled(true);
    }
}

