/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.recruitment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentCategory;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConditionChecker;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;
import ydmsama.hundred_years_war.main.utils.HywLogger;

public class RecruitmentConfigManager {
    private static final Logger LOGGER = HywLogger.LOGGER;
    private static final Map<String, RecruitmentConfig> cachedConfigs = new HashMap<String, RecruitmentConfig>();
    private static boolean isLoaded = false;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadAllConfigs() {
        LOGGER.info("Loading recruitment configs...");
        for (RecruitmentCategory category : RecruitmentCategory.values()) {
            RecruitmentConfigManager.loadCategoryConfig(category);
        }
        isLoaded = true;
        LOGGER.info("Finished loading recruitment configs");
    }

    private static void loadCategoryConfig(RecruitmentCategory category) {
        String configPath = "/assets/hundred_years_war/recruitment/" + category.getId() + ".json";
        try (InputStream is = RecruitmentConfigManager.class.getResourceAsStream(configPath);){
            if (is == null) {
                LOGGER.warn("Recruitment config not found: {}", (Object)configPath);
                cachedConfigs.put(category.getId(), new RecruitmentConfig());
                return;
            }
            InputStreamReader reader = new InputStreamReader(is);
            RecruitmentConfig config = (RecruitmentConfig)gson.fromJson((Reader)reader, RecruitmentConfig.class);
            cachedConfigs.put(category.getId(), config);
            LOGGER.info("Loaded config: {}", (Object)category.getId());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load recruitment config: {}", (Object)configPath, (Object)e);
            cachedConfigs.put(category.getId(), new RecruitmentConfig());
        }
    }

    public static void reloadConfigs() {
        LOGGER.info("Reloading recruitment configs...");
        cachedConfigs.clear();
        isLoaded = false;
        RecruitmentConfigManager.loadAllConfigs();
    }

    public static List<RecruitmentConfig.UnitTypeConfig> getAvailableUnitTypes(Player player, RecruitmentCategory category) {
        RecruitmentConfig config;
        if (!isLoaded) {
            RecruitmentConfigManager.loadAllConfigs();
        }
        if ((config = cachedConfigs.get(category.getId())) == null) {
            LOGGER.warn("Recruitment config empty, category id: {}", (Object)category.getId());
            return new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        }
        if (config.getUnitTypes() == null) {
            LOGGER.warn("unitTypes is null, category id: {}", (Object)category.getId());
            return new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        }
        List<RecruitmentConfig.UnitTypeConfig> unitTypes = config.getUnitTypes().get(category.getId());
        if (unitTypes == null) {
            LOGGER.warn("No unit types found, category id: {}, available keys: {}", (Object)category.getId(), config.getUnitTypes().keySet());
            return new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        }
        ArrayList<RecruitmentConfig.UnitTypeConfig> availableUnitTypes = new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        for (RecruitmentConfig.UnitTypeConfig unitType : unitTypes) {
            RecruitmentConfig.UnitTypeConfig availableUnitType = new RecruitmentConfig.UnitTypeConfig();
            availableUnitType.setId(unitType.getId());
            availableUnitType.setTranslationKey(unitType.getTranslationKey());
            ArrayList<RecruitmentConfig.ArmyLevelConfig> availableLevels = new ArrayList<RecruitmentConfig.ArmyLevelConfig>();
            for (RecruitmentConfig.ArmyLevelConfig level : unitType.getLevels()) {
                if (!RecruitmentConditionChecker.checkConditions(player, level)) continue;
                availableLevels.add(level);
            }
            if (availableLevels.isEmpty()) continue;
            availableUnitType.setLevels(availableLevels);
            availableUnitTypes.add(availableUnitType);
        }
        LOGGER.info("Category {} available unit types: {}", (Object)category.getId(), (Object)availableUnitTypes.size());
        return availableUnitTypes;
    }

    public static RecruitmentConfig.ArmyLevelConfig getArmyLevelConfig(String categoryId, String unitTypeId, int level) {
        RecruitmentConfig config;
        if (!isLoaded) {
            RecruitmentConfigManager.loadAllConfigs();
        }
        if ((config = cachedConfigs.get(categoryId)) == null || config.getUnitTypes() == null) {
            return null;
        }
        List<RecruitmentConfig.UnitTypeConfig> unitTypes = config.getUnitTypes().get(categoryId);
        if (unitTypes == null) {
            return null;
        }
        for (RecruitmentConfig.UnitTypeConfig unitType : unitTypes) {
            if (!unitType.getId().equals(unitTypeId)) continue;
            for (RecruitmentConfig.ArmyLevelConfig levelConfig : unitType.getLevels()) {
                if (levelConfig.getLevel() != level) continue;
                return levelConfig;
            }
        }
        return null;
    }

    public static boolean canPlayerRecruit(Player player, String categoryId, String unitTypeId, int level) {
        RecruitmentConfig.ArmyLevelConfig armyConfig = RecruitmentConfigManager.getArmyLevelConfig(categoryId, unitTypeId, level);
        if (armyConfig == null) {
            return false;
        }
        if (!RecruitmentConditionChecker.checkConditions(player, armyConfig)) {
            return false;
        }
        int playerExp = RecruitmentConfigManager.getTotalExperience(player);
        return playerExp >= armyConfig.getExpCost();
    }

    public static List<RecruitmentCategory> getAllCategories() {
        return Arrays.asList(RecruitmentCategory.values());
    }

    private static int getTotalExperience(Player player) {
        int currentExp = (int)(player.f_36080_ * (float)player.m_36323_()) + RecruitmentConfigManager.getTotalExperienceForLevel(player.f_36078_);
        return currentExp;
    }

    private static int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }
}

