/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.spawn;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

public class SpawnPointBlock
extends BaseEntityBlock {
    private static final VoxelShape FULL_BLOCK_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public SpawnPointBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60955_().m_280170_().m_60966_().m_60978_(0.0f).m_60918_(SoundType.f_56745_).m_222994_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shouldDisplay(context) ? FULL_BLOCK_SHAPE : Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shouldDisplay(context) ? FULL_BLOCK_SHAPE : Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof SpawnPointBlockEntity) {
                SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)be;
                spawnPoint.sync();
                ServerPacketHandler.sendOpenWorkstationSync(serverPlayer, pos, OpenWorkstationSyncPacket.WorkstationType.SPAWN_POINT);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpawnPointBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_) {
            return SpawnPointBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.SPAWN_POINT.get()), (lvl, blockPos, blockState, blockEntity) -> blockEntity.serverTick());
        }
        return null;
    }

    private boolean shouldDisplay(CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof Player && (player = (Player)living).m_7500_()) {
                return true;
            }
            return this.isHighlightStack(living.m_21205_()) || this.isHighlightStack(living.m_21206_());
        }
        return false;
    }

    private boolean isHighlightStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_150930_(this.m_5456_()) || stack.m_41720_() instanceof BuildingToolItem;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            // empty if block
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SpawnPointBlockEntity) {
            SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)blockEntity;
            spawnPoint.m_187476_(stack);
        }
        return stack;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        long resetInterval;
        super.m_5871_(stack, level, tooltip, flag);
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag == null || tag.m_128456_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.spawn_point.no_data").m_130940_(ChatFormatting.GRAY));
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.spawn_point.header").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.activation_distance", (Object[])new Object[]{SpawnPointBlock.formatDouble(tag.m_128459_("ActivationDistance"))}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.range", (Object[])new Object[]{SpawnPointBlock.formatDouble(tag.m_128459_("HorizontalRange")), SpawnPointBlock.formatDouble(tag.m_128459_("VerticalRange"))}).m_130940_(ChatFormatting.GRAY));
        int perSpawn = tag.m_128451_("PerSpawn");
        tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.per_spawn", (Object[])new Object[]{perSpawn}).m_130940_(ChatFormatting.GRAY));
        if (tag.m_128471_("Infinite")) {
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.spawn_point.infinite").m_130940_(ChatFormatting.AQUA));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.remaining", (Object[])new Object[]{tag.m_128451_("Remaining")}).m_130940_(ChatFormatting.GRAY));
        }
        int maxActive = tag.m_128451_("MaxActive");
        if (maxActive > 0) {
            tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.max_active", (Object[])new Object[]{maxActive}).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.interval", (Object[])new Object[]{tag.m_128451_("MinInterval"), tag.m_128451_("MaxInterval")}).m_130940_(ChatFormatting.GRAY));
        if (tag.m_128471_("PeriodicReset") && (resetInterval = tag.m_128454_("ResetInterval")) > 0L) {
            tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.periodic_reset", (Object[])new Object[]{resetInterval}).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)(tag.m_128471_("Paused") ? "item.hundred_years_war.spawn_point.state.paused" : "item.hundred_years_war.spawn_point.state.running")).m_130940_(ChatFormatting.GRAY));
        ListTag entries = tag.m_128437_("SpawnEntries", 10);
        if (entries.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"item.hundred_years_war.spawn_point.entries_empty").m_130940_(ChatFormatting.RED));
            return;
        }
        tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.entries", (Object[])new Object[]{entries.size()}).m_130940_(ChatFormatting.GOLD));
        int displayCount = Math.min(entries.size(), 3);
        for (int i = 0; i < displayCount; ++i) {
            CompoundTag entry = entries.m_128728_(i);
            ResourceLocation entityId = new ResourceLocation(entry.m_128461_("id"));
            int weight = entry.m_128451_("weight");
            Component name = BuiltInRegistries.f_256780_.m_6612_(entityId).map(EntityType::m_20676_).orElse((Component)Component.m_237113_((String)entityId.toString()));
            tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.entry", (Object[])new Object[]{name, weight}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (entries.size() > displayCount) {
            tooltip.add((Component)Component.m_237110_((String)"item.hundred_years_war.spawn_point.entry_more", (Object[])new Object[]{entries.size() - displayCount}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private static String formatDouble(double value) {
        return String.format(Locale.ROOT, "%.1f", value);
    }
}

