/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.supply.SupplyDataEncoding;
import ydmsama.hundred_years_war.main.supply.SupplyManager;

public class PlayerSupplyScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<PlayerSupplyScreenHandler> TYPE = new MenuType(PlayerSupplyScreenHandler::new, null);
    private final SimpleContainer foodContainer;
    private final ContainerData containerData;
    private final UUID playerUUID;
    private static final int DAILY_CONSUMPTION_SLOT = 3;
    private ContainerLevelAccess containerAccess = ContainerLevelAccess.f_39287_;

    public PlayerSupplyScreenHandler(int syncId, Inventory playerInventory) {
        super(TYPE, syncId);
        this.playerUUID = playerInventory.f_35978_.m_20148_();
        this.foodContainer = new SimpleContainer(9);
        this.containerData = new SimpleContainerData(4);
        this.updateContainerData(playerInventory.f_35978_);
        this.m_38884_(this.containerData);
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.foodContainer, i, 8 + i * 18, 35){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_41614_();
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 178));
        }
    }

    private void updateContainerData(Player player) {
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(player.m_20148_());
        if (source != null) {
            this.containerData.m_8050_(0, (int)source.getSupplyValue());
            this.containerData.m_8050_(1, (int)source.getMaxSupplyValue());
            this.containerData.m_8050_(2, source.getSuppliedEntities().size());
            this.containerData.m_8050_(3, SupplyDataEncoding.encode(SupplyManager.getDailyConsumption(player.m_20148_())));
        } else {
            this.containerData.m_8050_(0, 0);
            this.containerData.m_8050_(1, 1000);
            this.containerData.m_8050_(2, 0);
            this.containerData.m_8050_(3, 0);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            if (!(((Slot)this.f_38839_.get((int)i)).f_40218_ instanceof Inventory)) continue;
            Inventory inv = (Inventory)((Slot)this.f_38839_.get((int)i)).f_40218_;
            this.updateContainerData(inv.f_35978_);
            break;
        }
    }

    public void convertFood() {
        int i;
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.playerUUID);
        if (source == null) {
            SupplyManager.registerSupplySource(this.playerUUID, SupplyManager.SupplySourceType.PLAYER, 1000.0);
            source = SupplyManager.getSupplySource(this.playerUUID);
        }
        if (source == null) {
            return;
        }
        double remainingCapacity = Math.max(0.0, source.getMaxSupplyValue() - source.getSupplyValue());
        if (remainingCapacity <= 0.0) {
            return;
        }
        double totalSupply = 0.0;
        double EPSILON = 1.0E-6;
        boolean inventoryChanged = false;
        for (i = 0; i < this.foodContainer.m_6643_() && !(remainingCapacity <= 0.0); ++i) {
            int maxConvertible;
            int nutrition;
            double supplyPerItem;
            ItemStack stack = this.foodContainer.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41614_() || (supplyPerItem = SupplyManager.convertFoodToSupply(nutrition = stack.m_41720_().m_41473_().m_38744_())) <= 0.0 || (maxConvertible = (int)Math.min((double)stack.m_41613_(), Math.floor((remainingCapacity + 1.0E-6) / supplyPerItem))) <= 0) continue;
            double convertedSupply = supplyPerItem * (double)maxConvertible;
            totalSupply += convertedSupply;
            if ((remainingCapacity -= convertedSupply) < 1.0E-6) {
                remainingCapacity = 0.0;
            }
            inventoryChanged = true;
            if (maxConvertible == stack.m_41613_()) {
                this.foodContainer.m_6836_(i, ItemStack.f_41583_);
                continue;
            }
            stack.m_41774_(maxConvertible);
            this.foodContainer.m_6836_(i, stack);
        }
        if (totalSupply > 0.0) {
            if (inventoryChanged) {
                this.foodContainer.m_6596_();
            }
            source.addSupply(totalSupply);
            for (i = 0; i < this.f_38839_.size(); ++i) {
                if (!(((Slot)this.f_38839_.get((int)i)).f_40218_ instanceof Inventory)) continue;
                Inventory inv = (Inventory)((Slot)this.f_38839_.get((int)i)).f_40218_;
                this.updateContainerData(inv.f_35978_);
                break;
            }
            this.m_38946_();
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            if (index < 9) {
                if (!this.m_38903_(slotStack, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotStack.m_41614_()) {
                if (!this.m_38903_(slotStack, 0, 9, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            for (int i = 0; i < this.foodContainer.m_6643_(); ++i) {
                ItemStack stack = this.foodContainer.m_8020_(i);
                if (stack.m_41619_()) continue;
                player.m_36176_(stack, false);
            }
        }
    }

    public double getStoredSupply() {
        return this.containerData.m_6413_(0);
    }

    public double getMaxStoredSupply() {
        return this.containerData.m_6413_(1);
    }

    public int getSuppliedEntityCount() {
        return this.containerData.m_6413_(2);
    }

    public double getDailyConsumption() {
        return SupplyDataEncoding.decode(this.containerData.m_6413_(3));
    }

    public boolean isDailyConsumptionClamped() {
        return SupplyDataEncoding.isClamped(this.containerData.m_6413_(3));
    }

    public double getDailyConsumptionDisplayCap() {
        return SupplyDataEncoding.getClampValue();
    }

    public void setContainerAccess(ContainerLevelAccess access) {
        this.containerAccess = access;
    }
}

