/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.template.BuildingTask;
import ydmsama.hundred_years_war.main.template.BuildingTaskManager;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;
import ydmsama.hundred_years_war.main.template.PlacedBuildingRegistry;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class BuildTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildTemplateService.class);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("TemplateBuilder-" + thread.getId());
        thread.setDaemon(true);
        return thread;
    });

    private static void logInfo(String message, Object ... args) {
    }

    private static void logWarn(String message, Object ... args) {
    }

    public static CompletableFuture<HywStructureTemplate> buildTemplateWithProgress(ServerLevel level, BlockPos pos1, BlockPos pos2, BlockPos entrance, String name, String category, String description, String author, float playerYaw, boolean includeEntities, boolean includeBlockData, boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> customAttributes, ProgressCallback progressCallback) {
        return CompletableFuture.supplyAsync(() -> {
            int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
            int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
            int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
            int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
            int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
            int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
            int sizeX = maxX - minX + 1;
            int sizeY = maxY - minY + 1;
            int sizeZ = maxZ - minZ + 1;
            BlockPos size = new BlockPos(sizeX, sizeY, sizeZ);
            int totalBlocks = sizeX * sizeY * sizeZ;
            BlockPos relativeEntrance = entrance != null ? entrance.m_121996_((Vec3i)new BlockPos(minX, minY, minZ)) : BlockPos.f_121853_;
            HywStructureTemplate.Builder builder = new HywStructureTemplate.Builder(name, size).setCategory(category).setDescription(description).setAuthor(author).setPlayerYaw(playerYaw).setEntrance(relativeEntrance).setIncludeEntities(includeEntities).setIncludeBlockData(includeBlockData).setEnableGeneration(enableGeneration).setGenerationWeight(generationWeight).setConnectionLayerDepth(connectionLayerDepth).setMinGenerationHeight(minGenerationHeight).setMaxGenerationHeight(maxGenerationHeight).setGenerateOnSurface(generateOnSurface).putAllAttributes(customAttributes);
            long startTime = System.currentTimeMillis();
            int blockCount = 0;
            int processedBlocks = 0;
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        BlockPos worldPos = new BlockPos(x, y, z);
                        BlockPos relativePos = worldPos.m_121996_((Vec3i)new BlockPos(minX, minY, minZ));
                        BlockState state = level.m_8055_(worldPos);
                        if (!state.m_60795_()) {
                            BlockEntity blockEntity;
                            CompoundTag tileData = null;
                            if (includeBlockData && (blockEntity = level.m_7702_(worldPos)) != null) {
                                tileData = blockEntity.m_187482_();
                            }
                            builder.addBlock(relativePos, state, tileData);
                            ++blockCount;
                        }
                        if (progressCallback == null || ++processedBlocks % 100 != 0) continue;
                        progressCallback.onProgress(processedBlocks, totalBlocks);
                    }
                }
            }
            if (progressCallback != null) {
                progressCallback.onProgress(totalBlocks, totalBlocks);
            }
            HywStructureTemplate template = builder.build();
            return template;
        }, EXECUTOR);
    }

    public static CompletableFuture<HywStructureTemplate> buildTemplate(ServerLevel level, BlockPos pos1, BlockPos pos2, BlockPos entrance, String name, String category, String description, String author, float playerYaw, boolean includeEntities, boolean includeBlockData) {
        return BuildTemplateService.buildTemplateWithProgress(level, pos1, pos2, entrance, name, category, description, author, playerYaw, includeEntities, includeBlockData, false, 1, 10, -64, 320, true, TemplateMetadata.createDefaultAttributes(), null);
    }

    public static CompletableFuture<PlaceResult> placeTemplate(ServerLevel level, HywStructureTemplate template, BlockPos position, int rotation) {
        return BuildTemplateService.placeTemplate(level, template, position, rotation, 0.0f);
    }

    public static CompletableFuture<PlaceResult> placeTemplate(ServerLevel level, HywStructureTemplate template, BlockPos position, int rotation, float currentPlayerYaw) {
        return CompletableFuture.supplyAsync(() -> {
            float savedYaw = template.getPlayerYaw();
            float relativeYaw = BuildTemplateService.normalizeAngle(savedYaw - currentPlayerYaw);
            int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
            relativeRotation = BuildTemplateService.normalizeRotation(relativeRotation);
            int totalRotation = BuildTemplateService.normalizeRotation(rotation + relativeRotation);
            int placedBlocks = 0;
            int failedBlocks = 0;
            BlockPos entrance = template.getEntrance();
            if (entrance == null) {
                entrance = BlockPos.f_121853_;
            }
            BlockPos transformedEntrance = BuildTemplateService.transformPosition(entrance, template.getSize(), totalRotation);
            BlockPos offset = position.m_121996_((Vec3i)transformedEntrance);
            for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : template.getChunks().entrySet()) {
                HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
                HywStructureTemplate.TemplateChunk chunk = entry.getValue();
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            BlockState state = chunk.getBlock(x, y, z);
                            if (state == null || state.m_60795_()) continue;
                            BlockPos relativePos = new BlockPos(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                            BlockPos transformedPos = BuildTemplateService.transformPosition(relativePos, template.getSize(), totalRotation);
                            BlockPos worldPos = offset.m_121955_((Vec3i)transformedPos);
                            BlockState transformedState = BuildTemplateService.transformBlockState(state, totalRotation);
                            try {
                                BlockEntity blockEntity;
                                level.m_7731_(worldPos, transformedState, 3);
                                CompoundTag tileData = chunk.getTileData(x, y, z);
                                if (tileData != null && template.includesBlockData() && (blockEntity = level.m_7702_(worldPos)) != null) {
                                    blockEntity.m_142466_(tileData);
                                }
                                ++placedBlocks;
                                continue;
                            }
                            catch (Exception e) {
                                BuildTemplateService.logWarn("Failed to place block at {}: {}", worldPos, e.getMessage());
                                ++failedBlocks;
                            }
                        }
                    }
                }
            }
            if (template.includesEntities()) {
                // empty if block
            }
            return new PlaceResult(placedBlocks, failedBlocks, 0L);
        }, EXECUTOR);
    }

    private static BlockPos transformPosition(BlockPos pos, BlockPos size, int rotation) {
        BlockPos result = pos;
        BlockPos currentSize = size;
        for (int i = 0; i < rotation / 90; ++i) {
            int newX = result.m_123343_();
            int newZ = currentSize.m_123341_() - 1 - result.m_123341_();
            result = new BlockPos(newX, result.m_123342_(), newZ);
            int temp = currentSize.m_123341_();
            currentSize = new BlockPos(currentSize.m_123343_(), currentSize.m_123342_(), temp);
        }
        return result;
    }

    private static BlockState transformBlockState(BlockState state, int rotation) {
        Rotation rot = switch (rotation) {
            case 90 -> Rotation.COUNTERCLOCKWISE_90;
            case 180 -> Rotation.CLOCKWISE_180;
            case 270 -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return state.m_60717_(rot);
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    public static BuildResult createBuildingTaskWithResult(ServerLevel level, String templateId, BlockPos position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer, boolean terrainCheck) {
        HywStructureTemplate template = TemplateManager.getInstance().loadTemplate(templateId);
        if (template == null) {
            LOGGER.error("Template not found: {}", (Object)templateId);
            return BuildResult.failure(BuildResult.FailureReason.TEMPLATE_NOT_FOUND, templateId);
        }
        return BuildTemplateService.createBuildingTaskWithResult(level, template, templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName, generateConnectionLayer, terrainCheck);
    }

    public static BuildResult createBuildingTaskWithResult(ServerLevel level, HywStructureTemplate template, String templateId, BlockPos position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer, boolean terrainCheck) {
        long t0 = System.nanoTime();
        BuildTemplateService.logInfo("\u6027\u80fd | \u521b\u5efa\u5efa\u7b51\u4efb\u52a1 | \u6a21\u677f:{} | \u5f00\u59cb", templateId);
        if (template == null) {
            LOGGER.error("Template not provided for {}", (Object)templateId);
            return BuildResult.failure(BuildResult.FailureReason.TEMPLATE_NOT_FOUND, templateId);
        }
        long t1 = System.nanoTime();
        BlockPos[] bounds = BuildTemplateService.calculateBuildingBoundsFast(template, position, rotation, currentPlayerYaw);
        if (bounds == null) {
            LOGGER.error("Failed to calculate building bounds");
            return BuildResult.failure(BuildResult.FailureReason.INVALID_POSITION, "Cannot calculate building bounds");
        }
        long t2 = System.nanoTime();
        t1 = System.nanoTime();
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(level);
        List<PlacedBuilding> conflicts = registry.checkCollisions(bounds[0], bounds[1]);
        t2 = System.nanoTime();
        if (!conflicts.isEmpty()) {
            StringBuilder details = new StringBuilder();
            for (PlacedBuilding conflict : conflicts) {
                if (details.length() > 0) {
                    details.append(", ");
                }
                details.append(conflict.getTemplateName());
            }
            long total = (System.nanoTime() - t0) / 1000000L;
            BuildTemplateService.logInfo("\u6027\u80fd | \u521b\u5efa\u5efa\u7b51\u4efb\u52a1 | \u6a21\u677f:{} | \u603b\u8017\u65f6: {}ms (\u5931\u8d25-\u5efa\u7b51\u51b2\u7a81)", templateId, total);
            return BuildResult.failure(BuildResult.FailureReason.BUILDING_COLLISION, details.toString());
        }
        t1 = System.nanoTime();
        Set<String> structureConflicts = BuildTemplateService.findStructureConflicts(level, bounds[0], bounds[1]);
        t2 = System.nanoTime();
        BuildTemplateService.logInfo("\u6027\u80fd | \u521b\u5efa\u5efa\u7b51\u4efb\u52a1 | \u6a21\u677f:{} | \u9636\u6bb5D-\u7ed3\u6784\u78b0\u649e\u68c0\u6d4b: {}ms | \u51b2\u7a81:{}", templateId, (t2 - t1) / 1000000L, structureConflicts.size());
        if (!structureConflicts.isEmpty()) {
            String details = String.join((CharSequence)", ", structureConflicts);
            long total = (System.nanoTime() - t0) / 1000000L;
            BuildTemplateService.logInfo("\u6027\u80fd | \u521b\u5efa\u5efa\u7b51\u4efb\u52a1 | \u6a21\u677f:{} | \u603b\u8017\u65f6: {}ms (\u5931\u8d25-\u7ed3\u6784\u51b2\u7a81)", templateId, total);
            return BuildResult.failure(BuildResult.FailureReason.BUILDING_COLLISION, "structures: " + details);
        }
        t1 = System.nanoTime();
        BuildingTaskManager taskManager = BuildingTaskManager.get(level);
        long normalizedBuildTimeSeconds = Math.max(0L, buildTimeSeconds);
        UUID taskId = taskManager.addTaskWithTemplateAsync(templateId, template, position, rotation, currentPlayerYaw, normalizedBuildTimeSeconds, playerName, generateConnectionLayer, terrainCheck, level);
        long buildTimeTicks = normalizedBuildTimeSeconds * 20L;
        t2 = System.nanoTime();
        BuildTemplateService.logInfo("\u6027\u80fd | \u521b\u5efa\u5efa\u7b51\u4efb\u52a1 | \u6a21\u677f:{} | buildTime={}s ({}t) | \u9636\u6bb5E-\u6dfb\u52a0\u5f02\u6b65\u4efb\u52a1: {}ms | \u4efb\u52a1ID:{}", templateId, normalizedBuildTimeSeconds, buildTimeTicks, (t2 - t1) / 1000000L, taskId);
        if (taskId != null) {
            PlacedBuilding placedBuilding;
            BuildingTask task = taskManager.getTask(taskId);
            if (task != null && normalizedBuildTimeSeconds == 0L) {
                task.enableFastTrack();
            }
            if (task != null && task.isFailed()) {
                String failureReason = task.getFailureReason();
                LOGGER.error("Building task {} failed: {}", (Object)taskId, (Object)failureReason);
                taskManager.removeTask(level, taskId);
                if (failureReason != null && failureReason.contains("Terrain too uneven")) {
                    return BuildResult.failure(BuildResult.FailureReason.TERRAIN_TOO_UNEVEN, failureReason);
                }
                return BuildResult.failure(BuildResult.FailureReason.INVALID_POSITION, failureReason != null ? failureReason : "Task failed");
            }
            UUID buildingId = registry.registerBuilding(templateId, template.getName(), bounds[0], bounds[1], position, playerName, System.currentTimeMillis());
            if (task != null) {
                task.setRegisteredBuildingId(buildingId);
            }
            if (buildingId != null && (placedBuilding = registry.getBuilding(buildingId)) != null) {
                ServerPacketHandler.broadcastBuildingUpdate(level, placedBuilding, false);
            }
            return BuildResult.success(taskId, buildingId);
        }
        return BuildResult.failure(BuildResult.FailureReason.INVALID_POSITION, "Failed to create task");
    }

    public static BuildResult createBuildingTaskWithResult(ServerLevel level, String templateId, BlockPos position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName, boolean generateConnectionLayer) {
        return BuildTemplateService.createBuildingTaskWithResult(level, templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName, generateConnectionLayer, false);
    }

    public static BuildResult createBuildingTaskWithResult(ServerLevel level, String templateId, BlockPos position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName) {
        return BuildTemplateService.createBuildingTaskWithResult(level, templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName, false);
    }

    @Deprecated
    public static UUID createBuildingTask(ServerLevel level, String templateId, BlockPos position, int rotation, float currentPlayerYaw, long buildTimeSeconds, String playerName) {
        BuildResult result = BuildTemplateService.createBuildingTaskWithResult(level, templateId, position, rotation, currentPlayerYaw, buildTimeSeconds, playerName);
        return result.isSuccess() ? result.taskId : null;
    }

    private static BlockPos[] calculateBuildingBoundsFast(HywStructureTemplate template, BlockPos position, int rotation, float currentPlayerYaw) {
        BlockPos origin;
        float savedYaw = template.getPlayerYaw();
        float relativeYaw = BuildTemplateService.normalizeAngle(savedYaw - currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildTemplateService.normalizeRotation(relativeRotation);
        int totalRotation = BuildTemplateService.normalizeRotation(rotation + relativeRotation);
        BlockPos size = template.getSize();
        BlockPos rotatedSize = totalRotation % 180 == 0 ? new BlockPos(size.m_123341_(), size.m_123342_(), size.m_123343_()) : new BlockPos(size.m_123343_(), size.m_123342_(), size.m_123341_());
        BlockPos entrance = template.getEntrance() == null ? BlockPos.f_121853_ : template.getEntrance();
        BlockPos transformedEntrance = BuildTemplateService.transformPosition(entrance, size, totalRotation);
        BlockPos min = origin = position.m_121996_((Vec3i)transformedEntrance);
        BlockPos max = origin.m_7918_(rotatedSize.m_123341_() - 1, rotatedSize.m_123342_() - 1, rotatedSize.m_123343_() - 1);
        return new BlockPos[]{min, max};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static BlockPos[] calculateBuildingBounds(HywStructureTemplate template, BlockPos position, int rotation, float currentPlayerYaw) {
        Iterator<Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk>> iterator;
        long t0 = System.nanoTime();
        try {
            BlockPos[] blockPosArray;
            float savedYaw = template.getPlayerYaw();
            float relativeYaw = BuildTemplateService.normalizeAngle(savedYaw - currentPlayerYaw);
            int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
            relativeRotation = BuildTemplateService.normalizeRotation(relativeRotation);
            int totalRotation = BuildTemplateService.normalizeRotation(rotation + relativeRotation);
            BlockPos entrance = template.getEntrance();
            if (entrance == null) {
                entrance = BlockPos.f_121853_;
            }
            BlockPos transformedEntrance = BuildTemplateService.transformPosition(entrance, template.getSize(), totalRotation);
            BlockPos offset = position.m_121996_((Vec3i)transformedEntrance);
            BlockPos minPos = null;
            BlockPos maxPos = null;
            for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : template.getChunks().entrySet()) {
                HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
                HywStructureTemplate.TemplateChunk chunk = entry.getValue();
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            BlockState state = chunk.getBlock(x, y, z);
                            if (state == null || state.m_60795_()) continue;
                            BlockPos relativePos = new BlockPos(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                            BlockPos transformedPos = BuildTemplateService.transformPosition(relativePos, template.getSize(), totalRotation);
                            BlockPos worldPos = offset.m_121955_((Vec3i)transformedPos);
                            if (minPos == null) {
                                minPos = worldPos;
                                maxPos = worldPos;
                                continue;
                            }
                            minPos = new BlockPos(Math.min(minPos.m_123341_(), worldPos.m_123341_()), Math.min(minPos.m_123342_(), worldPos.m_123342_()), Math.min(minPos.m_123343_(), worldPos.m_123343_()));
                            maxPos = new BlockPos(Math.max(maxPos.m_123341_(), worldPos.m_123341_()), Math.max(maxPos.m_123342_(), worldPos.m_123342_()), Math.max(maxPos.m_123343_(), worldPos.m_123343_()));
                        }
                    }
                }
            }
            if (minPos != null) {
                BlockPos[] blockPosArray2 = new BlockPos[2];
                blockPosArray2[0] = minPos;
                blockPosArray = blockPosArray2;
                blockPosArray2[1] = maxPos;
            } else {
                blockPosArray = null;
            }
            iterator = blockPosArray;
        }
        catch (Throwable throwable) {
            long ms = (System.nanoTime() - t0) / 1000000L;
            BuildTemplateService.logInfo("\u6027\u80fd | \u8ba1\u7b97\u5efa\u7b51\u8fb9\u754c(\u9010\u5757\u626b\u63cf) | \u6a21\u677f:{} | \u8017\u65f6:{}ms", template.getName(), ms);
            throw throwable;
        }
        long ms = (System.nanoTime() - t0) / 1000000L;
        BuildTemplateService.logInfo("\u6027\u80fd | \u8ba1\u7b97\u5efa\u7b51\u8fb9\u754c(\u9010\u5757\u626b\u63cf) | \u6a21\u677f:{} | \u8017\u65f6:{}ms", template.getName(), ms);
        return iterator;
    }

    private static Set<String> findStructureConflicts(ServerLevel level, BlockPos minPos, BlockPos maxPos) {
        long t0 = System.nanoTime();
        int minX = Math.min(minPos.m_123341_(), maxPos.m_123341_());
        int minY = Math.min(minPos.m_123342_(), maxPos.m_123342_());
        int minZ = Math.min(minPos.m_123343_(), maxPos.m_123343_());
        int maxX = Math.max(minPos.m_123341_(), maxPos.m_123341_());
        int maxY = Math.max(minPos.m_123342_(), maxPos.m_123342_());
        int maxZ = Math.max(minPos.m_123343_(), maxPos.m_123343_());
        BoundingBox targetBox = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        int minChunkX = Math.floorDiv(minX, 16);
        int maxChunkX = Math.floorDiv(maxX, 16);
        int minChunkZ = Math.floorDiv(minZ, 16);
        int maxChunkZ = Math.floorDiv(maxZ, 16);
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        Set visitedStarts = Collections.newSetFromMap(new IdentityHashMap());
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>();
        int scannedChunks = 0;
        int skippedUnloadedChunks = 0;
        int startsSeen = 0;
        int slowChunks = 0;
        long maxChunkMs = 0L;
        int maxChunkMsX = 0;
        int maxChunkMsZ = 0;
        long SLOW_GET_STARTS_MS = 10L;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                LevelChunk chunk = level.m_7726_().m_7131_(chunkX, chunkZ);
                if (chunk == null) {
                    ++skippedUnloadedChunks;
                    continue;
                }
                ++scannedChunks;
                long tGetStarts0 = System.nanoTime();
                Collection starts = chunk.m_6633_().values();
                long tGetStartsMs = (System.nanoTime() - tGetStarts0) / 1000000L;
                if (tGetStartsMs > 10L) {
                    ++slowChunks;
                    if (tGetStartsMs > maxChunkMs) {
                        maxChunkMs = tGetStartsMs;
                        maxChunkMsX = chunkX;
                        maxChunkMsZ = chunkZ;
                    }
                    BuildTemplateService.logInfo("\u6027\u80fd | \u7ed3\u6784\u51b2\u7a81\u626b\u63cf | getAllStarts\u6162: {}ms @ chunk {},{}", tGetStartsMs, chunkX, chunkZ);
                }
                startsSeen += starts.size();
                for (StructureStart start : starts) {
                    BoundingBox box;
                    if (start == null || !start.m_73603_() || !visitedStarts.add(start) || (box = start.m_73601_()) == null || !box.m_71049_(targetBox)) continue;
                    String name = structureRegistry.m_7854_((Object)start.m_226861_()).map(key -> key.m_135782_().toString()).orElseGet(() -> start.m_226861_().toString());
                    conflicts.add(name);
                }
            }
        }
        long totalMs = (System.nanoTime() - t0) / 1000000L;
        if (maxChunkMs > 0L) {
            BuildTemplateService.logInfo("\u6027\u80fd | \u7ed3\u6784\u51b2\u7a81\u626b\u63cf | \u533a\u5757:{} | \u8df3\u8fc7\u672a\u52a0\u8f7d:{} | starts:{} | \u552f\u4e00starts:{} | \u51b2\u7a81:{} | \u6162\u533a\u5757:{}\u6b21(\u5cf0\u503c{}ms@{}, {}) | \u603b\u8017\u65f6:{}ms | AABB:[({}, {}, {}) \u2192 ({}, {}, {})]", scannedChunks, skippedUnloadedChunks, startsSeen, visitedStarts.size(), conflicts.size(), slowChunks, maxChunkMs, maxChunkMsX, maxChunkMsZ, totalMs, minX, minY, minZ, maxX, maxY, maxZ);
        } else {
            BuildTemplateService.logInfo("\u6027\u80fd | \u7ed3\u6784\u51b2\u7a81\u626b\u63cf | \u533a\u5757:{} | \u8df3\u8fc7\u672a\u52a0\u8f7d:{} | starts:{} | \u552f\u4e00starts:{} | \u51b2\u7a81:{} | \u603b\u8017\u65f6:{}ms | AABB:[({}, {}, {}) \u2192 ({}, {}, {})]", scannedChunks, skippedUnloadedChunks, startsSeen, visitedStarts.size(), conflicts.size(), totalMs, minX, minY, minZ, maxX, maxY, maxZ);
        }
        return conflicts;
    }

    public static CompletableFuture<Boolean> quickSave(ServerLevel level, BlockPos pos1, BlockPos pos2, BlockPos entrance, String name, String playerName) {
        return BuildTemplateService.buildTemplate(level, pos1, pos2, entrance, name, "\u672a\u5206\u7c7b", "\u5feb\u901f\u4fdd\u5b58\u7684\u5efa\u7b51", playerName, 0.0f, false, true).thenCompose(template -> {
            String templateId = name.toLowerCase().replaceAll("[^a-z0-9_]", "_") + "_" + UUID.randomUUID().toString().substring(0, 8);
            boolean saved = TemplateManager.getInstance().saveTemplate((HywStructureTemplate)template, templateId);
            if (!saved) {
                LOGGER.error("Failed to save template '{}'", (Object)name);
            }
            return CompletableFuture.completedFuture(saved);
        });
    }

    public static interface ProgressCallback {
        public void onProgress(int var1, int var2);
    }

    public static class BuildResult {
        public final UUID taskId;
        public final UUID buildingId;
        public final FailureReason failureReason;
        public final String details;

        private BuildResult(UUID taskId, UUID buildingId) {
            this.taskId = taskId;
            this.buildingId = buildingId;
            this.failureReason = null;
            this.details = null;
        }

        private BuildResult(FailureReason reason, String details) {
            this.taskId = null;
            this.buildingId = null;
            this.failureReason = reason;
            this.details = details;
        }

        public static BuildResult success(UUID taskId, UUID buildingId) {
            return new BuildResult(taskId, buildingId);
        }

        public static BuildResult failure(FailureReason reason, String details) {
            return new BuildResult(reason, details);
        }

        public boolean isSuccess() {
            return this.taskId != null;
        }

        public static enum FailureReason {
            TEMPLATE_NOT_FOUND,
            BUILDING_COLLISION,
            INVALID_POSITION,
            TERRAIN_TOO_UNEVEN;

        }
    }

    public static class PlaceResult {
        public final int placedBlocks;
        public final int failedBlocks;
        public final long timeTaken;

        public PlaceResult(int placedBlocks, int failedBlocks, long timeTaken) {
            this.placedBlocks = placedBlocks;
            this.failedBlocks = failedBlocks;
            this.timeTaken = timeTaken;
        }

        public boolean isSuccess() {
            return this.failedBlocks == 0;
        }

        public float getSuccessRate() {
            int total = this.placedBlocks + this.failedBlocks;
            return total > 0 ? (float)this.placedBlocks / (float)total : 0.0f;
        }
    }
}

