/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;

public class PlacedBuilding {
    private final UUID buildingId;
    private final String templateId;
    private final String templateName;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final BlockPos entrancePos;
    private final String placedBy;
    private final long placedTime;
    private final AABB boundingBox;

    public PlacedBuilding(UUID buildingId, String templateId, String templateName, BlockPos minPos, BlockPos maxPos, BlockPos entrancePos, String placedBy, long placedTime) {
        this.buildingId = buildingId;
        this.templateId = templateId != null ? templateId : "";
        this.templateName = templateName != null ? templateName : "";
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.entrancePos = entrancePos;
        this.placedBy = placedBy != null ? placedBy : "Unknown";
        this.placedTime = placedTime;
        this.boundingBox = new AABB(minPos, maxPos.m_7918_(1, 1, 1));
    }

    public PlacedBuilding(CompoundTag tag) {
        this.buildingId = tag.m_128342_("buildingId");
        this.templateId = tag.m_128461_("templateId");
        this.templateName = tag.m_128461_("templateName");
        this.minPos = BlockPos.m_122022_((long)tag.m_128454_("minPos"));
        this.maxPos = BlockPos.m_122022_((long)tag.m_128454_("maxPos"));
        this.entrancePos = BlockPos.m_122022_((long)tag.m_128454_("entrancePos"));
        this.placedBy = tag.m_128461_("placedBy");
        this.placedTime = tag.m_128454_("placedTime");
        this.boundingBox = new AABB(this.minPos, this.maxPos.m_7918_(1, 1, 1));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("buildingId", this.buildingId);
        tag.m_128359_("templateId", this.templateId != null ? this.templateId : "");
        tag.m_128359_("templateName", this.templateName != null ? this.templateName : "");
        tag.m_128356_("minPos", this.minPos.m_121878_());
        tag.m_128356_("maxPos", this.maxPos.m_121878_());
        tag.m_128356_("entrancePos", this.entrancePos.m_121878_());
        tag.m_128359_("placedBy", this.placedBy != null ? this.placedBy : "Unknown");
        tag.m_128356_("placedTime", this.placedTime);
        return tag;
    }

    public boolean intersects(PlacedBuilding other) {
        return this.boundingBox.m_82381_(other.boundingBox);
    }

    public boolean intersects(BlockPos minPos, BlockPos maxPos) {
        AABB otherBox = new AABB(minPos, maxPos.m_7918_(1, 1, 1));
        return this.boundingBox.m_82381_(otherBox);
    }

    public boolean intersectsChunk(int chunkX, int chunkZ) {
        int chunkMinX = chunkX << 4;
        int chunkMaxX = chunkMinX + 15;
        int chunkMinZ = chunkZ << 4;
        int chunkMaxZ = chunkMinZ + 15;
        return this.maxPos.m_123341_() >= chunkMinX && this.minPos.m_123341_() <= chunkMaxX && this.maxPos.m_123343_() >= chunkMinZ && this.minPos.m_123343_() <= chunkMaxZ;
    }

    public UUID getBuildingId() {
        return this.buildingId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public BlockPos getEntrancePos() {
        return this.entrancePos;
    }

    public String getPlacedBy() {
        return this.placedBy;
    }

    public long getPlacedTime() {
        return this.placedTime;
    }

    public AABB getBoundingBox() {
        return this.boundingBox;
    }
}

