/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributes;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTagDefinition;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTags;

public class TemplateMetadata {
    private String templateId;
    private final String name;
    private final String category;
    private final String description;
    private final BlockPos size;
    private final BlockPos entrance;
    private final String author;
    private final long createdTime;
    private final int totalBlocks;
    private final Map<String, Integer> blockCount;
    private final float playerYaw;
    private final String fileName;
    private final long fileSize;
    private boolean enableGeneration = false;
    private int generationWeight = 1;
    private int connectionLayerDepth = 10;
    private int minGenerationHeight = -64;
    private int maxGenerationHeight = 320;
    private boolean generateOnSurface = true;
    private final Map<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
    private static final String REQUIRE_PREGEN_KEY = "require_pregen";
    private static final String GENERATE_UNDERWATER_KEY = "generate_underwater";
    private static final String GENERATE_ON_WATER_SURFACE_KEY = "generate_on_water_surface";
    private static final String BIOME_LIST_KEY = "biome_blacklist";
    private static final String USE_WHITELIST_KEY = "use_whitelist";

    public TemplateMetadata(String name, String category, String description, BlockPos size, BlockPos entrance, String author, long createdTime, int totalBlocks, Map<String, Integer> blockCount) {
        this.name = name;
        this.category = category;
        this.description = description;
        this.size = size;
        this.entrance = entrance;
        this.author = author;
        this.createdTime = createdTime;
        this.totalBlocks = totalBlocks;
        this.blockCount = blockCount;
        this.playerYaw = 0.0f;
        this.fileName = null;
        this.fileSize = 0L;
        this.ensureCommonAttributes();
    }

    public TemplateMetadata(String name, String category, String description, BlockPos size, BlockPos entrance, String author, long createdTime, int totalBlocks, Map<String, Integer> blockCount, String fileName, long fileSize) {
        this(name, category, description, size, entrance, author, createdTime, totalBlocks, blockCount, fileName, fileSize, 0.0f);
    }

    public TemplateMetadata(String name, String category, String description, BlockPos size, BlockPos entrance, String author, long createdTime, int totalBlocks, Map<String, Integer> blockCount, String fileName, long fileSize, float playerYaw) {
        this.name = name;
        this.category = category;
        this.description = description;
        this.size = size;
        this.entrance = entrance;
        this.author = author;
        this.createdTime = createdTime;
        this.totalBlocks = totalBlocks;
        this.blockCount = blockCount;
        this.playerYaw = playerYaw;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.ensureCommonAttributes();
    }

    public Map<String, JsonElement> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Map<String, JsonElement> attributes) {
        this.customAttributes.clear();
        if (attributes != null) {
            attributes.forEach(this::setCustomAttribute);
        }
        this.ensureCommonAttributes();
    }

    public void setCustomAttribute(String key, JsonElement value) {
        Objects.requireNonNull(key, "Attribute key cannot be null");
        this.customAttributes.put(key, TemplateAttributes.normaliseValue(key, value));
    }

    public void removeCustomAttribute(String key) {
        this.customAttributes.remove(key);
    }

    public void ensureCommonAttributes() {
        TemplateAttributes.ensureDefaults(this.customAttributes);
        this.ensureAuthorAttribute();
        this.ensureTagAttributes();
    }

    private void ensureTagAttributes() {
        JsonElement tags = this.customAttributes.get("building_tags");
        if (tags == null || !tags.isJsonArray()) {
            return;
        }
        for (JsonElement element : tags.getAsJsonArray()) {
            String tagId;
            TemplateTagDefinition definition;
            if (element == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString() || (definition = TemplateTags.get(tagId = element.getAsString())) == null) continue;
            Map<String, JsonElement> defaults = TemplateTags.createAttributeValues(tagId);
            for (Map.Entry<String, JsonElement> entry : defaults.entrySet()) {
                String key = entry.getKey();
                JsonElement current = this.customAttributes.get(key);
                if (current != null && !current.isJsonNull()) continue;
                this.customAttributes.put(key, TemplateAttributes.normaliseValue(key, entry.getValue()));
            }
        }
    }

    private void ensureAuthorAttribute() {
        if (!this.customAttributes.containsKey("author")) {
            if (this.author != null && !this.author.isEmpty()) {
                this.customAttributes.put("author", TemplateAttributes.normaliseValue("author", (JsonElement)new JsonPrimitive(this.author)));
            } else {
                this.customAttributes.put("author", TemplateAttributes.normaliseValue("author", (JsonElement)JsonNull.INSTANCE));
            }
        }
    }

    public static Map<String, JsonElement> createDefaultAttributes() {
        return TemplateAttributes.createDefaultValues();
    }

    public static void ensureDefaultAttributes(Map<String, JsonElement> target) {
        TemplateAttributes.ensureDefaults(target);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public BlockPos getSize() {
        return this.size;
    }

    public BlockPos getEntrance() {
        return this.entrance;
    }

    public String getAuthor() {
        String attributed = this.getStringAttribute("author");
        if (attributed != null && !attributed.isEmpty()) {
            return attributed;
        }
        return this.author;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public Map<String, Integer> getBlockCount() {
        return this.blockCount;
    }

    public float getPlayerYaw() {
        return this.playerYaw;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isGenerationEnabled() {
        return this.enableGeneration;
    }

    public void setGenerationEnabled(boolean enabled) {
        this.enableGeneration = enabled;
    }

    public int getGenerationWeight() {
        return this.generationWeight;
    }

    public void setGenerationWeight(int weight) {
        this.generationWeight = weight;
    }

    public int getConnectionLayerDepth() {
        return this.connectionLayerDepth;
    }

    public void setConnectionLayerDepth(int depth) {
        this.connectionLayerDepth = depth;
    }

    public int getMinGenerationHeight() {
        return this.minGenerationHeight;
    }

    public void setMinGenerationHeight(int height) {
        this.minGenerationHeight = height;
    }

    public int getMaxGenerationHeight() {
        return this.maxGenerationHeight;
    }

    public void setMaxGenerationHeight(int height) {
        this.maxGenerationHeight = height;
    }

    public boolean isGenerateOnSurface() {
        return this.generateOnSurface;
    }

    public void setGenerateOnSurface(boolean generateOnSurface) {
        this.generateOnSurface = generateOnSurface;
    }

    public double getMinBurialRate() {
        return TemplateMetadata.clamp01(this.getDoubleAttribute("min_burial_rate", 0.0));
    }

    public double getMaxBurialRate() {
        return TemplateMetadata.clamp01(this.getDoubleAttribute("max_burial_rate", 1.0));
    }

    public boolean requiresPregen() {
        return this.getBooleanAttribute(REQUIRE_PREGEN_KEY);
    }

    public void setRequiresPregen(boolean requirePregen) {
        this.setBooleanAttribute(REQUIRE_PREGEN_KEY, requirePregen);
    }

    public boolean isGenerateUnderwater() {
        return this.getBooleanAttribute(GENERATE_UNDERWATER_KEY);
    }

    public void setGenerateUnderwater(boolean generateUnderwater) {
        this.setBooleanAttribute(GENERATE_UNDERWATER_KEY, generateUnderwater);
    }

    public boolean isGenerateOnWaterSurface() {
        return this.getBooleanAttribute(GENERATE_ON_WATER_SURFACE_KEY);
    }

    public void setGenerateOnWaterSurface(boolean generateOnWaterSurface) {
        this.setBooleanAttribute(GENERATE_ON_WATER_SURFACE_KEY, generateOnWaterSurface);
    }

    private static JsonElement cloneJsonElement(JsonElement element) {
        if (element == null) {
            return JsonNull.INSTANCE;
        }
        return element.deepCopy();
    }

    private static String asString(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return "";
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString().trim();
            }
            if (primitive.isNumber() || primitive.isBoolean()) {
                return primitive.getAsString().trim();
            }
        }
        return element.toString().trim();
    }

    private boolean getBooleanAttribute(String key) {
        JsonElement element = this.customAttributes.get(key);
        if (element == null || element.isJsonNull()) {
            return false;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return element.getAsBoolean();
        }
        return false;
    }

    private void setBooleanAttribute(String key, boolean value) {
        this.customAttributes.put(key, TemplateAttributes.normaliseValue(key, (JsonElement)new JsonPrimitive(Boolean.valueOf(value))));
    }

    private double getDoubleAttribute(String key, double defaultValue) {
        JsonElement element = this.customAttributes.get(key);
        if (element == null || element.isJsonNull()) {
            return defaultValue;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsDouble();
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            try {
                return Double.parseDouble(element.getAsString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private String getStringAttribute(String key) {
        JsonElement element = this.customAttributes.get(key);
        if (element == null || element.isJsonNull()) {
            return "";
        }
        return TemplateMetadata.asString(element);
    }

    private static double clamp01(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    public boolean matchesBiome(ResourceLocation biomeId) {
        if (biomeId == null) {
            return true;
        }
        Set<ResourceLocation> configuredBiomes = this.getConfiguredBiomes();
        boolean useWhitelist = this.getBooleanAttribute(USE_WHITELIST_KEY);
        if (configuredBiomes.isEmpty()) {
            return !useWhitelist;
        }
        boolean contains = configuredBiomes.contains(biomeId);
        return useWhitelist ? contains : !contains;
    }

    private Set<ResourceLocation> getConfiguredBiomes() {
        HashSet<ResourceLocation> biomes = new HashSet<ResourceLocation>();
        JsonElement element = this.customAttributes.get(BIOME_LIST_KEY);
        if (element == null || element.isJsonNull() || !element.isJsonArray()) {
            return biomes;
        }
        element.getAsJsonArray().forEach(item -> {
            ResourceLocation id;
            if (item != null && item.isJsonPrimitive() && item.getAsJsonPrimitive().isString() && (id = ResourceLocation.m_135820_((String)item.getAsString())) != null) {
                biomes.add(id);
            }
        });
        return biomes;
    }

    public long getEstimatedMemoryUsage() {
        return (long)this.totalBlocks * 4L + 1024L;
    }

    public int getVolume() {
        return this.size.m_123341_() * this.size.m_123342_() * this.size.m_123343_();
    }

    public float getFillRate() {
        int volume = this.getVolume();
        return volume > 0 ? (float)this.totalBlocks / (float)volume : 0.0f;
    }
}

