/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import com.github.luben.zstd.Zstd;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class TemplateSerializer {
    private static final byte[] MAGIC_NUMBER = "HYWT".getBytes(StandardCharsets.US_ASCII);
    private static final byte VERSION = 4;
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final byte FLAG_INCLUDES_ENTITIES = 1;
    private static final byte FLAG_INCLUDES_BLOCK_DATA = 2;
    private static final byte FLAG_HAS_MIRROR = 4;
    private static final byte FLAG_COMPRESSED = 8;
    private static final byte FLAG_ENABLE_GENERATION = 16;

    public static void serialize(HywStructureTemplate template, File file) throws IOException {
        TemplateSerializer.serialize(template, file.toPath());
    }

    public static void serialize(HywStructureTemplate template, Path path) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BlockPalette palette = TemplateSerializer.buildPalette(template);
            TemplateSerializer.writeSerializedTemplate(bos, template, palette);
        }
    }

    public static byte[] serializeToBytes(HywStructureTemplate template) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedOutputStream bos = new BufferedOutputStream(baos);){
            BlockPalette palette = TemplateSerializer.buildPalette(template);
            TemplateSerializer.writeSerializedTemplate(bos, template, palette);
        }
        return baos.toByteArray();
    }

    private static void writeSerializedTemplate(OutputStream out, HywStructureTemplate template, BlockPalette palette) throws IOException {
        TemplateSerializer.writeHeader(out, template);
        ByteArrayOutputStream metaOut = new ByteArrayOutputStream();
        TemplateSerializer.writeMetadata(metaOut, template, palette);
        byte[] metadata = metaOut.toByteArray();
        TemplateSerializer.writeVarInt(out, metadata.length);
        out.write(metadata);
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        TemplateSerializer.writeData(dataOut, template, palette);
        byte[] uncompressedData = dataOut.toByteArray();
        byte[] compressedData = Zstd.compress((byte[])uncompressedData, (int)3);
        TemplateSerializer.writeVarInt(out, compressedData.length);
        out.write(compressedData);
    }

    public static TemplateMetadata deserializeMetadata(File file) throws IOException {
        return TemplateSerializer.deserializeMetadata(file.toPath());
    }

    public static TemplateMetadata deserializeMetadata(Path path) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            TemplateMetadata templateMetadata = TemplateSerializer.deserializeMetadata(bis);
            return templateMetadata;
        }
    }

    private static TemplateMetadata deserializeMetadata(BufferedInputStream bis) throws IOException {
        byte[] magic = bis.readNBytes(4);
        if (!Arrays.equals(magic, MAGIC_NUMBER)) {
            throw new IOException("Invalid file format");
        }
        int versionByte = bis.read();
        if (versionByte == -1) {
            throw new EOFException("Unexpected end of stream while reading version");
        }
        byte version = (byte)versionByte;
        if (version < 1 || version > 4) {
            throw new IOException("Unsupported version: " + version);
        }
        int flagsByte = bis.read();
        if (flagsByte == -1) {
            throw new EOFException("Unexpected end of stream while reading flags");
        }
        int metadataSize = TemplateSerializer.readVarInt(bis);
        byte[] metadata = bis.readNBytes(metadataSize);
        if (metadata.length != metadataSize) {
            throw new EOFException("Unexpected end of stream while reading metadata");
        }
        try (ByteArrayInputStream metaIn = new ByteArrayInputStream(metadata);){
            TemplateMetadata templateMetadata = TemplateSerializer.readMetadataOnly(metaIn, version);
            return templateMetadata;
        }
    }

    public static HywStructureTemplate deserializeFull(File file) throws IOException {
        return TemplateSerializer.deserializeFull(file.toPath());
    }

    public static HywStructureTemplate deserializeFull(Path path) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            HywStructureTemplate hywStructureTemplate = TemplateSerializer.deserializeFromBufferedStream(bis);
            return hywStructureTemplate;
        }
    }

    public static HywStructureTemplate deserializeFromBytes(byte[] data) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            HywStructureTemplate hywStructureTemplate;
            try (BufferedInputStream bis = new BufferedInputStream(bais);){
                hywStructureTemplate = TemplateSerializer.deserializeFromBufferedStream(bis);
            }
            return hywStructureTemplate;
        }
    }

    private static HywStructureTemplate deserializeFromBufferedStream(BufferedInputStream bis) throws IOException {
        byte[] magic = bis.readNBytes(4);
        if (!Arrays.equals(magic, MAGIC_NUMBER)) {
            throw new IOException("Invalid file format");
        }
        int versionByte = bis.read();
        if (versionByte == -1) {
            throw new EOFException("Unexpected end of stream while reading version");
        }
        byte version = (byte)versionByte;
        if (version < 1 || version > 4) {
            throw new IOException("Unsupported version: " + version);
        }
        int flagsByte = bis.read();
        if (flagsByte == -1) {
            throw new EOFException("Unexpected end of stream while reading flags");
        }
        byte flags = (byte)flagsByte;
        boolean includeEntities = (flags & 1) != 0;
        boolean includeBlockData = (flags & 2) != 0;
        boolean hasMirror = (flags & 4) != 0;
        boolean isCompressed = (flags & 8) != 0;
        boolean enableGeneration = (flags & 0x10) != 0;
        int metadataSize = TemplateSerializer.readVarInt(bis);
        byte[] metadataBytes = bis.readNBytes(metadataSize);
        if (metadataBytes.length != metadataSize) {
            throw new EOFException("Unexpected end of stream while reading metadata");
        }
        int dataSize = TemplateSerializer.readVarInt(bis);
        byte[] compressedData = bis.readNBytes(dataSize);
        if (compressedData.length != dataSize) {
            throw new EOFException("Unexpected end of stream while reading data section");
        }
        byte[] uncompressedData = isCompressed ? Zstd.decompress((byte[])compressedData, (int)((int)Zstd.decompressedSize((byte[])compressedData, (int)0, (int)compressedData.length))) : compressedData;
        ByteArrayInputStream metaIn = new ByteArrayInputStream(metadataBytes);
        ByteArrayInputStream dataIn = new ByteArrayInputStream(uncompressedData);
        return TemplateSerializer.readTemplate(metaIn, dataIn, includeEntities, includeBlockData, hasMirror, version);
    }

    private static void writeHeader(OutputStream out, HywStructureTemplate template) throws IOException {
        out.write(MAGIC_NUMBER);
        out.write(4);
        byte flags = 0;
        if (template.includesEntities()) {
            flags = (byte)(flags | 1);
        }
        if (template.includesBlockData()) {
            flags = (byte)(flags | 2);
        }
        if (template.hasMirrorVersion()) {
            flags = (byte)(flags | 4);
        }
        if (template.isGenerationEnabled()) {
            flags = (byte)(flags | 0x10);
        }
        flags = (byte)(flags | 8);
        out.write(flags);
    }

    private static void writeMetadata(OutputStream out, HywStructureTemplate template, BlockPalette palette) throws IOException {
        TemplateSerializer.writeString(out, template.getName());
        TemplateSerializer.writeString(out, template.getCategory());
        TemplateSerializer.writeString(out, template.getDescription());
        TemplateSerializer.writeVarInt(out, template.getSize().m_123341_());
        TemplateSerializer.writeVarInt(out, template.getSize().m_123342_());
        TemplateSerializer.writeVarInt(out, template.getSize().m_123343_());
        TemplateSerializer.writeVarInt(out, template.getEntrance().m_123341_());
        TemplateSerializer.writeVarInt(out, template.getEntrance().m_123342_());
        TemplateSerializer.writeVarInt(out, template.getEntrance().m_123343_());
        TemplateSerializer.writeString(out, template.getAuthor());
        TemplateSerializer.writeLong(out, template.getCreatedTime());
        TemplateSerializer.writeFloat(out, template.getPlayerYaw());
        out.write(template.isGenerationEnabled() ? 1 : 0);
        TemplateSerializer.writeVarInt(out, template.getGenerationWeight());
        TemplateSerializer.writeVarInt(out, template.getConnectionLayerDepth());
        TemplateSerializer.writeInt(out, template.getMinGenerationHeight());
        TemplateSerializer.writeInt(out, template.getMaxGenerationHeight());
        out.write(template.isGenerateOnSurface() ? 1 : 0);
        Map<String, JsonElement> attributes = template.getCustomAttributes();
        TemplateSerializer.writeVarInt(out, attributes.size());
        for (Map.Entry<String, JsonElement> entry : attributes.entrySet()) {
            TemplateSerializer.writeString(out, entry.getKey());
            JsonNull value = entry.getValue() == null ? JsonNull.INSTANCE : entry.getValue();
            TemplateSerializer.writeString(out, GSON.toJson((JsonElement)value));
        }
        palette.write(out);
        TemplateSerializer.writeVarInt(out, template.getTotalBlocks());
        TemplateSerializer.writeVarInt(out, template.getBlockCount().size());
        for (Map.Entry<String, Object> entry : template.getBlockCount().entrySet()) {
            TemplateSerializer.writeString(out, entry.getKey());
            TemplateSerializer.writeVarInt(out, (Integer)entry.getValue());
        }
    }

    private static void writeData(OutputStream out, HywStructureTemplate template, BlockPalette palette) throws IOException {
        Map<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> chunks = template.getChunks();
        TemplateSerializer.writeVarInt(out, chunks.size());
        for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : chunks.entrySet()) {
            HywStructureTemplate.ChunkPos pos = entry.getKey();
            HywStructureTemplate.TemplateChunk chunk = entry.getValue();
            TemplateSerializer.writeVarInt(out, pos.x);
            TemplateSerializer.writeVarInt(out, pos.y);
            TemplateSerializer.writeVarInt(out, pos.z);
            TemplateSerializer.writeChunkData(out, chunk, palette, template.includesBlockData());
        }
        if (template.includesEntities()) {
            TemplateSerializer.writeVarInt(out, template.getEntities().size());
            for (HywStructureTemplate.EntityData entity : template.getEntities()) {
                TemplateSerializer.writeString(out, entity.entityType);
                TemplateSerializer.writeVarInt(out, entity.relativePos.m_123341_());
                TemplateSerializer.writeVarInt(out, entity.relativePos.m_123342_());
                TemplateSerializer.writeVarInt(out, entity.relativePos.m_123343_());
                TemplateSerializer.writeCompoundTag(out, entity.nbt);
            }
        }
    }

    private static void writeChunkData(OutputStream out, HywStructureTemplate.TemplateChunk chunk, BlockPalette palette, boolean includeBlockData) throws IOException {
        ArrayList<RunLengthEntry> runs = new ArrayList<RunLengthEntry>();
        int lastPaletteId = -1;
        int runLength = 0;
        ArrayList<CompoundTag> tileTags = new ArrayList<CompoundTag>();
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    CompoundTag tag;
                    int paletteId;
                    BlockState state = chunk.getBlock(x, y, z);
                    int n = paletteId = state == null || state.m_60795_() ? 0 : palette.getId(state);
                    if (paletteId == lastPaletteId) {
                        ++runLength;
                    } else {
                        if (runLength > 0) {
                            runs.add(new RunLengthEntry(lastPaletteId, runLength));
                        }
                        lastPaletteId = paletteId;
                        runLength = 1;
                    }
                    if (!includeBlockData || state == null || state.m_60795_() || (tag = chunk.getTileData(x, y, z)) == null) continue;
                    tag.m_128344_("x", (byte)x);
                    tag.m_128344_("y", (byte)y);
                    tag.m_128344_("z", (byte)z);
                    tileTags.add(tag);
                }
            }
        }
        if (runLength > 0) {
            runs.add(new RunLengthEntry(lastPaletteId, runLength));
        }
        TemplateSerializer.writeVarInt(out, runs.size());
        for (RunLengthEntry run : runs) {
            TemplateSerializer.writeVarInt(out, run.paletteId);
            TemplateSerializer.writeVarInt(out, run.length);
        }
        if (includeBlockData) {
            TemplateSerializer.writeVarInt(out, tileTags.size());
            for (CompoundTag tag : tileTags) {
                TemplateSerializer.writeCompoundTag(out, tag);
            }
        }
    }

    private static BlockPalette buildPalette(HywStructureTemplate template) {
        BlockPalette palette = new BlockPalette();
        for (HywStructureTemplate.TemplateChunk chunk : template.getChunks().values()) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState state = chunk.getBlock(x, y, z);
                        if (state == null || state.m_60795_()) continue;
                        palette.getId(state);
                    }
                }
            }
        }
        return palette;
    }

    private static void writeVarInt(OutputStream out, int value) throws IOException {
        while ((value & 0xFFFFFF80) != 0) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value);
    }

    private static int readVarInt(InputStream in) throws IOException {
        byte currentByte;
        int value = 0;
        int position = 0;
        while (((currentByte = (byte)in.read()) & 0x80) != 0) {
            value |= (currentByte & 0x7F) << position;
            if ((position += 7) < 32) continue;
            throw new RuntimeException("VarInt is too big");
        }
        return value | currentByte << position;
    }

    private static void writeInt(OutputStream out, int value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        out.write(buffer.array());
    }

    private static int readInt(InputStream in) throws IOException {
        byte[] bytes = new byte[4];
        in.read(bytes);
        return ByteBuffer.wrap(bytes).getInt();
    }

    private static void writeString(OutputStream out, String str) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        TemplateSerializer.writeVarInt(out, bytes.length);
        out.write(bytes);
    }

    private static String readString(InputStream in) throws IOException {
        int length = TemplateSerializer.readVarInt(in);
        byte[] bytes = new byte[length];
        in.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLong(OutputStream out, long value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        out.write(buffer.array());
    }

    private static long readLong(InputStream in) throws IOException {
        byte[] bytes = new byte[8];
        in.read(bytes);
        return ByteBuffer.wrap(bytes).getLong();
    }

    private static void writeFloat(OutputStream out, float value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(value);
        out.write(buffer.array());
    }

    private static float readFloat(InputStream in) throws IOException {
        byte[] bytes = new byte[4];
        in.read(bytes);
        return ByteBuffer.wrap(bytes).getFloat();
    }

    private static void writeCompoundTag(OutputStream out, CompoundTag tag) throws IOException {
        ByteArrayOutputStream tagOut = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(tagOut);){
            NbtIo.m_128941_((CompoundTag)tag, (DataOutput)dos);
        }
        byte[] tagBytes = tagOut.toByteArray();
        TemplateSerializer.writeVarInt(out, tagBytes.length);
        out.write(tagBytes);
    }

    private static CompoundTag readCompoundTag(InputStream in) throws IOException {
        int length = TemplateSerializer.readVarInt(in);
        byte[] tagBytes = new byte[length];
        in.read(tagBytes);
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tagBytes));){
            CompoundTag compoundTag = NbtIo.m_128928_((DataInput)dis);
            return compoundTag;
        }
    }

    private static void writeBlockState(OutputStream out, BlockState state) throws IOException {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        TemplateSerializer.writeString(out, blockId.toString());
        Collection properties = state.m_61147_();
        TemplateSerializer.writeVarInt(out, properties.size());
        for (Property property : properties) {
            TemplateSerializer.writeString(out, property.m_61708_());
            Comparable value = state.m_61143_(property);
            TemplateSerializer.writeString(out, property.m_6940_(value));
        }
    }

    private static BlockState readBlockState(InputStream in) throws IOException {
        String blockIdStr = TemplateSerializer.readString(in);
        ResourceLocation blockId = new ResourceLocation(blockIdStr);
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
        if (block == null) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState state = block.m_49966_();
        int propertyCount = TemplateSerializer.readVarInt(in);
        block0: for (int i = 0; i < propertyCount; ++i) {
            String propertyName = TemplateSerializer.readString(in);
            String valueStr = TemplateSerializer.readString(in);
            for (Property property : state.m_61147_()) {
                if (!property.m_61708_().equals(propertyName)) continue;
                Optional value = property.m_6215_(valueStr);
                if (!value.isPresent()) continue block0;
                state = (BlockState)state.m_61124_(property, (Comparable)value.get());
                continue block0;
            }
        }
        return state;
    }

    private static TemplateMetadata readMetadataOnly(InputStream in, byte version) throws IOException {
        int i;
        String name = TemplateSerializer.readString(in);
        String category = TemplateSerializer.readString(in);
        String description = TemplateSerializer.readString(in);
        int sizeX = TemplateSerializer.readVarInt(in);
        int sizeY = TemplateSerializer.readVarInt(in);
        int sizeZ = TemplateSerializer.readVarInt(in);
        BlockPos size = new BlockPos(sizeX, sizeY, sizeZ);
        int entranceX = TemplateSerializer.readVarInt(in);
        int entranceY = TemplateSerializer.readVarInt(in);
        int entranceZ = TemplateSerializer.readVarInt(in);
        BlockPos entrance = new BlockPos(entranceX, entranceY, entranceZ);
        String author = TemplateSerializer.readString(in);
        long createdTime = TemplateSerializer.readLong(in);
        float playerYaw = 0.0f;
        if (version >= 2) {
            playerYaw = TemplateSerializer.readFloat(in);
        }
        boolean enableGeneration = false;
        int generationWeight = 1;
        int connectionLayerDepth = 10;
        int minGenerationHeight = -64;
        int maxGenerationHeight = 320;
        boolean generateOnSurface = true;
        LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
        if (version >= 3) {
            enableGeneration = in.read() != 0;
            generationWeight = TemplateSerializer.readVarInt(in);
            connectionLayerDepth = TemplateSerializer.readVarInt(in);
        }
        if (version >= 4) {
            minGenerationHeight = TemplateSerializer.readInt(in);
            maxGenerationHeight = TemplateSerializer.readInt(in);
            generateOnSurface = in.read() != 0;
            int attributeCount = TemplateSerializer.readVarInt(in);
            for (i = 0; i < attributeCount; ++i) {
                String key = TemplateSerializer.readString(in);
                String jsonString = TemplateSerializer.readString(in);
                customAttributes.put(key, TemplateSerializer.parseJsonElement(jsonString));
            }
        }
        int paletteSize = TemplateSerializer.readVarInt(in);
        for (i = 0; i < paletteSize; ++i) {
            TemplateSerializer.readBlockState(in);
        }
        int totalBlocks = TemplateSerializer.readVarInt(in);
        int blockCountSize = TemplateSerializer.readVarInt(in);
        HashMap<String, Integer> blockCount = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < blockCountSize; ++i2) {
            String blockName = TemplateSerializer.readString(in);
            int count = TemplateSerializer.readVarInt(in);
            blockCount.put(blockName, count);
        }
        TemplateMetadata metadata = new TemplateMetadata(name, category, description, size, entrance, author, createdTime, totalBlocks, blockCount, null, 0L, playerYaw);
        metadata.setGenerationEnabled(enableGeneration);
        metadata.setGenerationWeight(generationWeight);
        metadata.setConnectionLayerDepth(connectionLayerDepth);
        metadata.setMinGenerationHeight(minGenerationHeight);
        metadata.setMaxGenerationHeight(maxGenerationHeight);
        metadata.setGenerateOnSurface(generateOnSurface);
        metadata.setCustomAttributes(customAttributes);
        metadata.ensureCommonAttributes();
        return metadata;
    }

    private static HywStructureTemplate readTemplate(InputStream metaIn, InputStream dataIn, boolean includeEntities, boolean includeBlockData, boolean hasMirror, byte version) throws IOException {
        String name = TemplateSerializer.readString(metaIn);
        String category = TemplateSerializer.readString(metaIn);
        String description = TemplateSerializer.readString(metaIn);
        int sizeX = TemplateSerializer.readVarInt(metaIn);
        int sizeY = TemplateSerializer.readVarInt(metaIn);
        int sizeZ = TemplateSerializer.readVarInt(metaIn);
        BlockPos size = new BlockPos(sizeX, sizeY, sizeZ);
        int entranceX = TemplateSerializer.readVarInt(metaIn);
        int entranceY = TemplateSerializer.readVarInt(metaIn);
        int entranceZ = TemplateSerializer.readVarInt(metaIn);
        BlockPos entrance = new BlockPos(entranceX, entranceY, entranceZ);
        String author = TemplateSerializer.readString(metaIn);
        long createdTime = TemplateSerializer.readLong(metaIn);
        float playerYaw = 0.0f;
        if (version >= 2) {
            playerYaw = TemplateSerializer.readFloat(metaIn);
        }
        boolean enableGeneration = false;
        int generationWeight = 1;
        int connectionLayerDepth = 10;
        int minGenerationHeight = -64;
        int maxGenerationHeight = 320;
        boolean generateOnSurface = true;
        LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
        if (version >= 3) {
            enableGeneration = metaIn.read() != 0;
            generationWeight = TemplateSerializer.readVarInt(metaIn);
            connectionLayerDepth = TemplateSerializer.readVarInt(metaIn);
        }
        if (version >= 4) {
            minGenerationHeight = TemplateSerializer.readInt(metaIn);
            maxGenerationHeight = TemplateSerializer.readInt(metaIn);
            generateOnSurface = metaIn.read() != 0;
            int attributeCount = TemplateSerializer.readVarInt(metaIn);
            for (int i = 0; i < attributeCount; ++i) {
                String key = TemplateSerializer.readString(metaIn);
                String jsonString = TemplateSerializer.readString(metaIn);
                customAttributes.put(key, TemplateSerializer.parseJsonElement(jsonString));
            }
        }
        BlockPalette palette = BlockPalette.read(metaIn);
        int totalBlocks = TemplateSerializer.readVarInt(metaIn);
        int blockCountSize = TemplateSerializer.readVarInt(metaIn);
        for (int i = 0; i < blockCountSize; ++i) {
            TemplateSerializer.readString(metaIn);
            TemplateSerializer.readVarInt(metaIn);
        }
        HywStructureTemplate.Builder builder = new HywStructureTemplate.Builder(name, size).setCategory(category).setDescription(description).setEntrance(entrance).setAuthor(author).setPlayerYaw(playerYaw).setIncludeEntities(includeEntities).setIncludeBlockData(includeBlockData).setHasMirrorVersion(hasMirror).setEnableGeneration(enableGeneration).setGenerationWeight(generationWeight).setConnectionLayerDepth(connectionLayerDepth).setMinGenerationHeight(minGenerationHeight).setMaxGenerationHeight(maxGenerationHeight).setGenerateOnSurface(generateOnSurface).putAllAttributes(customAttributes);
        int chunkCount = TemplateSerializer.readVarInt(dataIn);
        for (int i = 0; i < chunkCount; ++i) {
            int chunkX = TemplateSerializer.readVarInt(dataIn);
            int chunkY = TemplateSerializer.readVarInt(dataIn);
            int chunkZ = TemplateSerializer.readVarInt(dataIn);
            TemplateSerializer.readChunkData(dataIn, builder, palette, chunkX, chunkY, chunkZ, includeBlockData);
        }
        if (includeEntities) {
            int entityCount = TemplateSerializer.readVarInt(dataIn);
            for (int i = 0; i < entityCount; ++i) {
                String entityType = TemplateSerializer.readString(dataIn);
                int entityX = TemplateSerializer.readVarInt(dataIn);
                int entityY = TemplateSerializer.readVarInt(dataIn);
                int entityZ = TemplateSerializer.readVarInt(dataIn);
                CompoundTag nbt = TemplateSerializer.readCompoundTag(dataIn);
                builder.addEntity(entityType, new BlockPos(entityX, entityY, entityZ), nbt);
            }
        }
        return builder.build();
    }

    private static void readChunkData(InputStream in, HywStructureTemplate.Builder builder, BlockPalette palette, int chunkX, int chunkY, int chunkZ, boolean includeBlockData) throws IOException {
        int runCount = TemplateSerializer.readVarInt(in);
        ArrayList<RunLengthEntry> runs = new ArrayList<RunLengthEntry>();
        for (int i = 0; i < runCount; ++i) {
            int paletteId = TemplateSerializer.readVarInt(in);
            int length = TemplateSerializer.readVarInt(in);
            runs.add(new RunLengthEntry(paletteId, length));
        }
        HashMap<BlockPos, CompoundTag> tileData = new HashMap<BlockPos, CompoundTag>();
        if (includeBlockData) {
            int tileCount = TemplateSerializer.readVarInt(in);
            for (int i = 0; i < tileCount; ++i) {
                CompoundTag tag = TemplateSerializer.readCompoundTag(in);
                byte x = tag.m_128445_("x");
                byte y = tag.m_128445_("y");
                byte z = tag.m_128445_("z");
                tileData.put(new BlockPos((int)x, (int)y, (int)z), tag);
            }
        }
        int index = 0;
        for (RunLengthEntry run : runs) {
            BlockState state = palette.getState(run.paletteId);
            for (int i = 0; i < run.length; ++i) {
                int localX = index % 16;
                int localZ = index / 16 % 16;
                int localY = index / 256;
                if (!state.m_60795_()) {
                    BlockPos globalPos = new BlockPos(chunkX * 16 + localX, chunkY * 16 + localY, chunkZ * 16 + localZ);
                    CompoundTag tile = (CompoundTag)tileData.get(new BlockPos(localX, localY, localZ));
                    builder.addBlock(globalPos, state, tile);
                }
                ++index;
            }
        }
    }

    private static JsonElement parseJsonElement(String jsonString) {
        try {
            return JsonParser.parseString((String)jsonString);
        }
        catch (JsonSyntaxException e) {
            return new JsonPrimitive(jsonString);
        }
    }

    private static class BlockPalette {
        private final List<BlockState> states = new ArrayList<BlockState>();
        private final Map<BlockState, Integer> stateToId = new HashMap<BlockState, Integer>();

        BlockPalette() {
            this.states.add(Blocks.f_50016_.m_49966_());
            this.stateToId.put(Blocks.f_50016_.m_49966_(), 0);
        }

        int getId(BlockState state) {
            return this.stateToId.computeIfAbsent(state, s -> {
                this.states.add((BlockState)s);
                return this.states.size() - 1;
            });
        }

        BlockState getState(int id) {
            return id >= 0 && id < this.states.size() ? this.states.get(id) : Blocks.f_50016_.m_49966_();
        }

        void write(OutputStream out) throws IOException {
            TemplateSerializer.writeVarInt(out, this.states.size());
            for (BlockState state : this.states) {
                TemplateSerializer.writeBlockState(out, state);
            }
        }

        static BlockPalette read(InputStream in) throws IOException {
            BlockPalette palette = new BlockPalette();
            palette.states.clear();
            palette.stateToId.clear();
            int size = TemplateSerializer.readVarInt(in);
            for (int i = 0; i < size; ++i) {
                BlockState state = TemplateSerializer.readBlockState(in);
                palette.states.add(state);
                palette.stateToId.put(state, i);
            }
            return palette;
        }
    }

    private static class RunLengthEntry {
        final int paletteId;
        final int length;

        RunLengthEntry(int paletteId, int length) {
            this.paletteId = paletteId;
            this.length = length;
        }
    }
}

