/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.utils.FormationTypes;

public class PlayerSettingsManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<UUID, PlayerSettings> SETTINGS = new HashMap<UUID, PlayerSettings>();
    private static Path storagePath;

    public static void load(Path path) {
        storagePath = path;
        SETTINGS.clear();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement rootElement = JsonParser.parseReader((Reader)reader);
            if (!rootElement.isJsonObject()) {
                return;
            }
            JsonObject root = rootElement.getAsJsonObject();
            for (Map.Entry entry : root.entrySet()) {
                try {
                    UUID uuid = UUID.fromString((String)entry.getKey());
                    JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                    PlayerSettings settings = new PlayerSettings();
                    if (data.has("currentFormation")) {
                        settings.setCurrentFormation(data.get("currentFormation").getAsString());
                    }
                    if (data.has("lastNonNoneFormation")) {
                        settings.setLastNonNoneFormation(data.get("lastNonNoneFormation").getAsString());
                    }
                    if (data.has("recruitment")) {
                        JsonObject rec = data.getAsJsonObject("recruitment");
                        PlayerRecruitmentData.RecruitmentSelection selection = new PlayerRecruitmentData.RecruitmentSelection();
                        if (rec.has("category")) {
                            selection.setCategoryId(rec.get("category").getAsString());
                        }
                        if (rec.has("unitType")) {
                            selection.setUnitTypeId(rec.get("unitType").getAsString());
                        }
                        if (rec.has("level")) {
                            selection.setLevel(rec.get("level").getAsInt());
                        }
                        settings.setRecruitmentSelection(selection);
                    }
                    SETTINGS.put(uuid, settings);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        if (storagePath == null) {
            return;
        }
        try {
            if (storagePath.getParent() != null) {
                Files.createDirectories(storagePath.getParent(), new FileAttribute[0]);
            }
            JsonObject root = new JsonObject();
            for (Map.Entry<UUID, PlayerSettings> entry : SETTINGS.entrySet()) {
                JsonObject data = new JsonObject();
                PlayerSettings settings = entry.getValue();
                data.addProperty("currentFormation", settings.getCurrentFormation());
                data.addProperty("lastNonNoneFormation", settings.getLastNonNoneFormation());
                JsonObject recruitment = PlayerSettingsManager.serializeRecruitment(settings.getRecruitmentSelection());
                data.add("recruitment", (JsonElement)recruitment);
                root.add(entry.getKey().toString(), (JsonElement)data);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(storagePath, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static JsonObject serializeRecruitment(PlayerRecruitmentData.RecruitmentSelection selection) {
        JsonObject recruitment = new JsonObject();
        recruitment.addProperty("category", selection.getCategoryId());
        recruitment.addProperty("unitType", selection.getUnitTypeId());
        recruitment.addProperty("level", (Number)selection.getLevel());
        return recruitment;
    }

    public static PlayerSettings getSettings(UUID uuid) {
        return SETTINGS.computeIfAbsent(uuid, key -> new PlayerSettings());
    }

    public static PlayerSettings getSettings(ServerPlayer player) {
        return PlayerSettingsManager.getSettings(player.m_20148_());
    }

    public static void updateFormation(UUID uuid, String currentFormation, String lastNonNoneFormation) {
        PlayerSettings settings = PlayerSettingsManager.getSettings(uuid);
        settings.setCurrentFormation(currentFormation);
        settings.setLastNonNoneFormation(lastNonNoneFormation);
        PlayerSettingsManager.save();
    }

    public static void updateRecruitment(UUID uuid, PlayerRecruitmentData.RecruitmentSelection selection) {
        PlayerSettings settings = PlayerSettingsManager.getSettings(uuid);
        settings.setRecruitmentSelection(selection);
        PlayerSettingsManager.save();
    }

    public static PlayerRecruitmentData.RecruitmentSelection copyRecruitmentSelection(UUID uuid) {
        return PlayerSettingsManager.getSettings(uuid).copyRecruitmentSelection();
    }

    public static class PlayerSettings {
        private String currentFormation = "none";
        private String lastNonNoneFormation = "tight";
        private PlayerRecruitmentData.RecruitmentSelection recruitmentSelection = new PlayerRecruitmentData.RecruitmentSelection();

        public String getCurrentFormation() {
            return this.currentFormation;
        }

        public void setCurrentFormation(String currentFormation) {
            this.currentFormation = FormationTypes.sanitize(currentFormation);
        }

        public String getLastNonNoneFormation() {
            return this.lastNonNoneFormation;
        }

        public void setLastNonNoneFormation(String lastNonNoneFormation) {
            this.lastNonNoneFormation = FormationTypes.sanitizeNonNone(lastNonNoneFormation);
        }

        public PlayerRecruitmentData.RecruitmentSelection getRecruitmentSelection() {
            return this.recruitmentSelection;
        }

        public void setRecruitmentSelection(PlayerRecruitmentData.RecruitmentSelection selection) {
            this.recruitmentSelection = this.copy(selection);
        }

        public PlayerRecruitmentData.RecruitmentSelection copyRecruitmentSelection() {
            return this.copy(this.recruitmentSelection);
        }

        private PlayerRecruitmentData.RecruitmentSelection copy(PlayerRecruitmentData.RecruitmentSelection original) {
            PlayerRecruitmentData.RecruitmentSelection clone = new PlayerRecruitmentData.RecruitmentSelection();
            clone.setCategoryId(original.getCategoryId());
            clone.setUnitTypeId(original.getUnitTypeId());
            clone.setLevel(original.getLevel());
            return clone;
        }
    }
}

