/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.utils.FreecamStateManager;

public class PuppetUtils {
    public static void checkOwnerFreecamStatus(IPuppet puppet) {
        Entity puppetEntity = (Entity)puppet;
        if (puppetEntity.m_9236_().f_46443_) {
            return;
        }
        if (puppet.m_21805_() == null) {
            puppetEntity.m_146870_();
            return;
        }
        if (!FreecamStateManager.isPlayerInFreecam(puppet.m_21805_())) {
            PuppetUtils.removePuppetSafely(puppet);
            return;
        }
        ServerPlayer owner = puppetEntity.m_9236_().m_7654_().m_6846_().m_11259_(puppet.m_21805_());
        if (owner != null && (owner.f_8941_.m_9290_() == GameType.CREATIVE || owner.f_8941_.m_9290_() == GameType.SPECTATOR)) {
            PuppetUtils.removePuppetSafely(puppet);
        }
    }

    public static void removePuppetSafely(IPuppet puppet) {
        Entity puppetEntity = (Entity)puppet;
        if (puppetEntity.m_9236_().f_46443_) {
            return;
        }
        Entity puppetVehicle = null;
        if (puppetEntity.m_20159_()) {
            puppetVehicle = puppetEntity.m_20202_();
        }
        if (!puppetEntity.m_20197_().isEmpty()) {
            for (Entity passenger : puppetEntity.m_20197_()) {
                if (!(passenger instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)passenger;
                double playerX = player.m_20185_();
                double playerY = player.m_20186_();
                double playerZ = player.m_20189_();
                float playerYRot = player.m_146908_();
                float playerXRot = player.m_146909_();
                player.m_8127_();
                player.m_6021_(playerX, playerY, playerZ);
                player.m_146922_(playerYRot);
                player.m_146926_(playerXRot);
                if (puppetVehicle == null || puppetVehicle.m_213877_()) continue;
                player.m_7998_(puppetVehicle, true);
                if (!(puppetVehicle instanceof AbstractHorse)) continue;
                AbstractHorse horse = (AbstractHorse)puppetVehicle;
                player.m_146922_(horse.m_146908_());
                player.m_5616_(horse.m_146908_());
            }
        }
        if (puppetEntity.m_20159_()) {
            puppetEntity.m_8127_();
        }
        puppetEntity.m_146870_();
    }

    public static void syncHealthWithPassenger(IPuppet puppet) {
        Entity puppetEntity = (Entity)puppet;
        Entity entity = puppet.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            if (!(puppetEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingPuppet = (LivingEntity)puppetEntity;
            float passengerMaxHealth = passenger.m_21233_();
            if (livingPuppet.m_21233_() != passengerMaxHealth) {
                livingPuppet.m_21051_(Attributes.f_22276_).m_22100_((double)passengerMaxHealth);
            }
            float passengerHealth = passenger.m_21223_();
            if (livingPuppet.m_21223_() != passengerHealth) {
                livingPuppet.m_21153_(passengerHealth);
            }
            if (passenger instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)passenger;
                if (!puppetEntity.m_9236_().f_46443_) {
                    PuppetUtils.syncOffhandItem(player, livingPuppet);
                }
            }
        }
    }

    private static void syncOffhandItem(ServerPlayer player, LivingEntity puppet) {
        ItemStack playerOffhand = player.m_21206_();
        ItemStack puppetOffhand = puppet.m_21206_();
        if (puppetOffhand.m_150930_(Items.f_42747_) && !playerOffhand.m_150930_(Items.f_42747_)) {
            ItemStack newTotem = PuppetUtils.findAndEquipNewTotem(player);
            if (!newTotem.m_41619_()) {
                puppet.m_8061_(EquipmentSlot.OFFHAND, newTotem.m_41777_());
            } else {
                puppet.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            }
        } else if (!ItemStack.m_41728_((ItemStack)playerOffhand, (ItemStack)puppetOffhand)) {
            puppet.m_8061_(EquipmentSlot.OFFHAND, playerOffhand.m_41777_());
        }
    }

    private static ItemStack findAndEquipNewTotem(ServerPlayer player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!stack.m_150930_(Items.f_42747_)) continue;
            player.m_8061_(EquipmentSlot.OFFHAND, stack.m_41777_());
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean handleHurt(IPuppet puppet, DamageSource source, float amount) {
        Entity entity;
        Entity puppetEntity = (Entity)puppet;
        if (!puppetEntity.m_9236_().f_46443_ && (entity = puppet.m_146895_()) instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            passenger.m_6469_(source, amount);
            return false;
        }
        return false;
    }

    public static Vec3 getDismountLocationForPassenger(IPuppet puppet, LivingEntity passenger) {
        return passenger.m_20182_();
    }

    public static double getPassengersRidingOffset() {
        return 0.35f;
    }

    public static void syncPuppetHeadRotationToPlayer(IPuppet puppet) {
        Entity puppetEntity = (Entity)puppet;
        Entity firstPassenger = puppet.m_146895_();
        if (firstPassenger instanceof Player) {
            Player player = (Player)firstPassenger;
            if (puppetEntity instanceof LivingEntity) {
                LivingEntity livingPuppet = (LivingEntity)puppetEntity;
                Entity entity = puppetEntity.m_20202_();
                if (entity instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)entity;
                    float horseYaw = horse.m_146908_();
                    player.m_5616_(horseYaw);
                    player.m_146922_(horseYaw);
                    player.m_146926_(horse.m_146909_());
                } else {
                    float puppetYaw = livingPuppet.m_146908_();
                    player.m_5616_(puppetYaw);
                    player.m_146922_(puppetYaw);
                    player.m_146926_(livingPuppet.m_146909_());
                }
            }
        }
    }
}

