/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import org.slf4j.Logger;
import ydmsama.hundred_years_war.main.utils.HywLogger;

public class TargetListManager {
    private static final File CONFIG_DIR = new File("config/hundredyearswar");
    private static final File TARGET_LIST_FILE = new File(CONFIG_DIR, "target_list.json5");
    private static final File TARGET_BLACKLIST_FILE = new File(CONFIG_DIR, "target_blacklist.json5");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = HywLogger.LOGGER;
    private static List<String> targetList = new ArrayList<String>();
    private static List<String> targetBlacklist = new ArrayList<String>();

    public static void loadTargetList() {
        targetList = TargetListManager.loadList(TARGET_LIST_FILE, TargetListManager::createDefaultTargetList, "target list");
    }

    public static void loadTargetBlacklist() {
        targetBlacklist = TargetListManager.loadList(TARGET_BLACKLIST_FILE, TargetListManager::createDefaultTargetBlacklist, "target blacklist");
    }

    private static List<String> loadList(File file, Consumer<File> defaultCreator, String description) {
        TargetListManager.ensureConfigDir();
        if (!file.exists()) {
            LOGGER.info("{} does not exist, creating default {}", (Object)file.getName(), (Object)description);
            defaultCreator.accept(file);
        } else {
            LOGGER.info("Found existing {}", (Object)file.getName());
        }
        return TargetListManager.readList(file, description);
    }

    private static List<String> readList(File file, String description) {
        ArrayList<String> arrayList;
        FileReader reader = new FileReader(file);
        try {
            int length;
            StringBuilder content = new StringBuilder();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                content.append(buffer, 0, length);
            }
            String jsonContent = content.toString().replaceAll("//.*", "");
            ArrayList<String> list = (ArrayList<String>)GSON.fromJson(jsonContent, new TypeToken<List<String>>(){}.getType());
            if (list == null) {
                list = new ArrayList<String>();
            }
            LOGGER.info("Loaded {}: {}", (Object)description, list);
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load {}: {}", new Object[]{file.getName(), e.getMessage(), e});
                return new ArrayList<String>();
            }
        }
        ((Reader)reader).close();
        return arrayList;
    }

    private static void ensureConfigDir() {
        if (!CONFIG_DIR.exists()) {
            CONFIG_DIR.mkdirs();
            LOGGER.info("Created directory: {}", (Object)CONFIG_DIR.getPath());
        }
    }

    private static void createDefaultTargetList(File targetListFile) {
        try {
            ArrayList<String> defaultTargets = new ArrayList<String>();
            defaultTargets.add("minecraft:zombie");
            defaultTargets.add("minecraft:skeleton");
            defaultTargets.add("minecraft:spider");
            try (FileWriter writer = new FileWriter(targetListFile);){
                writer.write("// Target list - BaseCombatEntity will actively attack these entities\n");
                writer.write("// Format: \"namespace:entity_id\"\n");
                writer.write("// In addition to this list, soldiers will also attack enemy players, enemy soldiers, and some monsters\n");
                writer.write("[\n");
                for (int i = 0; i < defaultTargets.size(); ++i) {
                    writer.write("  \"" + (String)defaultTargets.get(i) + "\"");
                    if (i < defaultTargets.size() - 1) {
                        writer.write(",");
                    }
                    writer.write("\n");
                }
                writer.write("]\n");
            }
            targetList = defaultTargets;
            LOGGER.info("Created default target list: {}", defaultTargets);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default target list", (Throwable)e);
            targetList = new ArrayList<String>();
        }
    }

    private static void createDefaultTargetBlacklist(File targetBlacklistFile) {
        try (FileWriter writer = new FileWriter(targetBlacklistFile);){
            writer.write("// Target blacklist - BaseCombatEntity will never attack these entities\n");
            writer.write("// Format: \"namespace:entity_id\"\n");
            writer.write("[]\n");
            targetBlacklist = new ArrayList<String>();
            LOGGER.info("Created default target blacklist (empty list)");
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default target blacklist", (Throwable)e);
            targetBlacklist = new ArrayList<String>();
        }
    }

    public static boolean isInTargetList(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        String entityIdString = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString();
        return targetList.contains(entityIdString);
    }

    public static boolean isInTargetBlacklist(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        String entityIdString = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString();
        return targetBlacklist.contains(entityIdString);
    }

    public static List<String> getTargetList() {
        return new ArrayList<String>(targetList);
    }

    public static List<String> getTargetBlacklist() {
        return new ArrayList<String>(targetBlacklist);
    }

    public static void addToTargetList(String entityId) {
        if (!targetList.contains(entityId)) {
            targetList.add(entityId);
        }
    }

    public static void removeFromTargetList(String entityId) {
        targetList.remove(entityId);
    }
}

