/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1061;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_5498;
import net.minecraft.class_642;
import net.minecraft.class_743;
import net.minecraft.class_744;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.config.ModBindings;
import ydmsama.hundred_years_war.client.freecam.mixins.MouseHandlerAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.ClientPuppetStateHandler;
import ydmsama.hundred_years_war.client.freecam.tripod.TripodRegistry;
import ydmsama.hundred_years_war.client.freecam.tripod.TripodSlot;
import ydmsama.hundred_years_war.client.freecam.util.FreeCamera;
import ydmsama.hundred_years_war.client.freecam.util.FreecamPosition;
import ydmsama.hundred_years_war.client.freecam.util.Motion;
import ydmsama.hundred_years_war.client.freecam.variant.api.BuildVariant;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.ThirdPersonCompat;

@Environment(value=EnvType.CLIENT)
public class Freecam {
    public static final class_310 MC = class_310.method_1551();
    private static boolean rotateCamera = false;
    private static boolean shouldGrabMouse = false;
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static final TripodRegistry tripods = new TripodRegistry();
    private static TripodSlot activeTripod = TripodSlot.NONE;
    private static FreeCamera freeCamera;
    private static class_5498 rememberedF5;
    private static double lastMouseX;
    private static double lastMouseY;
    private static int CamRollButtonHoldTicks;
    private static final int ROTATION_ACTIVATION_TICKS = 5;
    private static boolean rollRight;
    private static boolean rollLeft;
    private static boolean rollUp;
    private static boolean rollDown;
    private static boolean screenRoll;
    private static final int EDGE_THRESHOLD = 10;
    private static boolean isOnDisconnect;
    private static double speedMultiplier;

    public static void preTick(class_310 mc) {
        if ((disableNextTick || Freecam.isRestrictedOnServer()) && Freecam.isEnabled()) {
            Freecam.toggle();
        }
        disableNextTick = false;
        if (Freecam.isEnabled()) {
            if (mc.field_1724 != null) {
                if (!mc.field_1724.method_5805()) {
                    Freecam.toggle();
                    return;
                }
                if (mc.field_1724.field_3913 instanceof class_743 && !Freecam.isPlayerControlEnabled()) {
                    class_744 input = new class_744();
                    input.field_3903 = mc.field_1724.field_3913.field_3903;
                    mc.field_1724.field_3913 = input;
                }
            }
            mc.field_1773.method_35768(ClientModConfig.INSTANCE.visual.showHand);
            ClientPuppetStateHandler.checkAndRestorePuppetSelection();
        }
    }

    public static void postTick(class_310 mc) {
        ModBindings.forEach(class_1061::method_4622);
        if (CamRollButtonHoldTicks > 0 && ++CamRollButtonHoldTicks >= 5 && !Freecam.isRotateCamera()) {
            lastMouseX = Freecam.MC.field_1729.method_1603();
            lastMouseY = Freecam.MC.field_1729.method_1604();
            shouldGrabMouse = true;
            Freecam.MC.field_1729.method_1612();
            shouldGrabMouse = false;
            Freecam.activateRotateHandler();
        }
    }

    public static void onDisconnect() {
        isOnDisconnect = true;
        if (Freecam.isEnabled()) {
            Freecam.toggle();
        }
        tripods.clear();
        ClientPuppetStateHandler.clearAllStates();
    }

    public static boolean activateTripodHandler() {
        boolean activated = false;
        for (class_304 combo : Freecam.MC.field_1690.field_1852) {
            while (combo.method_1436()) {
                Freecam.toggleTripod(TripodSlot.ofKeyCode(combo.method_1429().method_1444()));
                activated = true;
            }
        }
        return activated;
    }

    public static boolean resetTripodHandler() {
        boolean reset = false;
        for (class_304 key : Freecam.MC.field_1690.field_1852) {
            while (key.method_1436()) {
                Freecam.resetCamera(TripodSlot.ofKeyCode(key.method_1429().method_1444()));
                reset = true;
            }
        }
        return reset;
    }

    public static void toggle() {
        if (Freecam.isRestrictedOnServer()) {
            if (ClientModConfig.INSTANCE.notification.notifyFreecam) {
                Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.restrictedByConfig", (Object[])new Object[]{Freecam.MC.method_1558().field_3761}), true);
            }
            return;
        }
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        freecamEnabled = !freecamEnabled;
        isOnDisconnect = false;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    private static void toggleTripod(TripodSlot tripod) {
        if (tripod == TripodSlot.NONE) {
            return;
        }
        if (Freecam.isRestrictedOnServer()) {
            if (ClientModConfig.INSTANCE.notification.notifyTripod) {
                Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.restrictedByConfig", (Object[])new Object[]{Freecam.MC.method_1558().field_3761}), true);
            }
            return;
        }
        if (tripodEnabled) {
            if (activeTripod == tripod) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(tripod);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(tripod);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.field_3913 = new class_743(Freecam.MC.field_1690);
        } else {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
            Freecam.freeCamera.field_3913 = new class_744();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(TripodSlot tripod) {
        Freecam.onEnable();
        FreecamPosition position = tripods.get(tripod);
        boolean chunkLoaded = false;
        if (position != null) {
            class_1923 chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.field_1687.method_2935().method_12123(chunkPos.field_9181, chunkPos.field_9180);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(tripod);
            position = null;
        }
        freeCamera = new FreeCamera(-420 - tripod.ordinal());
        if (position == null) {
            Freecam.moveToPlayer();
        } else {
            Freecam.moveToPosition(position);
        }
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        activeTripod = tripod;
        if (ClientModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.openTripod", (Object[])new Object[]{tripod}), true);
        }
    }

    private static void onDisableTripod() {
        tripods.put(activeTripod, new FreecamPosition((class_1297)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ClientModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.closeTripod", (Object[])new Object[]{activeTripod}), true);
        }
        activeTripod = TripodSlot.NONE;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        Freecam.alignFreeCameraToCurrentView();
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        if (ClientModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.enable"), true);
        }
        Freecam.resetMouseButtons();
        ClientPacketHandler.sendFreecamTogglePacket(true);
    }

    private static void onDisableFreecam() {
        ClientPuppetStateHandler.savePuppetSelectionState();
        if (!isOnDisconnect) {
            shouldGrabMouse = true;
            Freecam.MC.field_1729.method_1612();
            shouldGrabMouse = false;
        }
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ClientModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.disable"), true);
        }
        ClientPacketHandler.sendFreecamTogglePacket(false);
    }

    private static void onEnable() {
        Freecam.MC.field_1773.method_35768(ClientModConfig.INSTANCE.visual.showHand);
        rememberedF5 = Freecam.MC.field_1690.method_31044();
        if (Freecam.MC.field_1773.method_19418().method_19333()) {
            ThirdPersonCompat.killFadeIn();
            Freecam.MC.field_1690.method_31043(class_5498.field_26664);
        }
        Freecam.MC.field_1729.method_1610();
    }

    private static void onDisable() {
        Freecam.MC.field_1773.method_35768(true);
        MC.method_1504((class_1297)Freecam.MC.field_1724);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.field_3913 = new class_744();
        freeCamera = null;
        if (Freecam.MC.field_1724 != null) {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.field_1690.method_31043(rememberedF5);
        }
    }

    private static void resetCamera(TripodSlot tripod) {
        if (tripodEnabled && activeTripod != TripodSlot.NONE && activeTripod == tripod && freeCamera != null) {
            Freecam.moveToPlayer();
        } else {
            tripods.put(tripod, null);
        }
        if (ClientModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.tripodReset", (Object[])new Object[]{tripod}), true);
        }
    }

    public static void moveToEntity(@Nullable class_1297 entity) {
        if (freeCamera == null) {
            return;
        }
        if (entity == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.method_5719(entity);
    }

    public static void moveToPosition(@Nullable FreecamPosition position) {
        if (freeCamera == null) {
            return;
        }
        if (position == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.applyPosition(position);
    }

    public static void moveToPlayer() {
        if (freeCamera == null) {
            return;
        }
        freeCamera.method_5719((class_1297)Freecam.MC.field_1724);
        freeCamera.applyPerspective(ClientModConfig.Perspective.FIRST_PERSON, ClientModConfig.INSTANCE.collision.alwaysCheck || !ClientModConfig.INSTANCE.collision.ignoreAll || !BuildVariant.getInstance().cheatsPermitted());
    }

    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    public static void disableNextTick() {
        disableNextTick = true;
    }

    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    public static boolean isRestrictedOnServer() {
        class_642 server = MC.method_1558();
        ClientModConfig.ServerRestriction mode = ClientModConfig.INSTANCE.servers.mode;
        if (mode == ClientModConfig.ServerRestriction.NONE || server == null || MC.method_47392()) {
            return false;
        }
        String ip = server.field_3761.trim().toLowerCase();
        return switch (mode) {
            case ClientModConfig.ServerRestriction.WHITELIST -> ClientModConfig.INSTANCE.servers.whitelist.stream().map(String::trim).map(String::toLowerCase).noneMatch(ip::equals);
            case ClientModConfig.ServerRestriction.BLACKLIST -> ClientModConfig.INSTANCE.servers.blacklist.stream().map(String::trim).map(String::toLowerCase).anyMatch(ip::equals);
            default -> throw new IllegalStateException("Unexpected mode value in Freecam.isRestrictedOnServer: " + mode);
        };
    }

    public static boolean isRotateCamera() {
        return rotateCamera;
    }

    public static void setRotateCamera(boolean rotate) {
        rotateCamera = rotate;
    }

    public static void activateRotateHandler() {
        Freecam.setRotateCamera(true);
    }

    public static void deactivateRotateHandler() {
        Freecam.setRotateCamera(false);
    }

    public static boolean getShouldGrabMouse() {
        return shouldGrabMouse;
    }

    public static void setShouldGrabMouse(boolean grabMouse) {
        shouldGrabMouse = grabMouse;
    }

    public static void doEdgeMotion() {
        double mouseX = Freecam.MC.field_1729.method_1603();
        double mouseY = Freecam.MC.field_1729.method_1604();
        int screenWidth = MC.method_22683().method_4480();
        int screenHeight = MC.method_22683().method_4507();
        if (Freecam.isEnabled()) {
            if (MC.method_1493() || !MC.method_1569()) {
                rollRight = false;
                rollLeft = false;
                rollUp = false;
                rollDown = false;
                screenRoll = false;
                return;
            }
            if (!rotateCamera) {
                boolean withinHorizontalBounds = mouseX >= 0.0 && mouseX <= (double)screenWidth;
                boolean withinVerticalBounds = mouseY >= 0.0 && mouseY <= (double)screenHeight;
                boolean nearRightEdge = withinHorizontalBounds && mouseX > (double)(screenWidth - 10);
                boolean nearLeftEdge = withinHorizontalBounds && mouseX < 10.0;
                boolean nearTopEdge = withinVerticalBounds && mouseY < 10.0;
                boolean nearBottomEdge = withinVerticalBounds && mouseY > (double)(screenHeight - 10);
                rollRight = nearRightEdge;
                rollLeft = nearLeftEdge;
                rollUp = nearTopEdge;
                rollDown = nearBottomEdge;
                screenRoll = nearRightEdge || nearLeftEdge || nearTopEdge || nearBottomEdge;
                Motion.doMotion(freeCamera, speedMultiplier * ClientModConfig.INSTANCE.movement.horizontalSpeed, speedMultiplier * ClientModConfig.INSTANCE.movement.verticalSpeed);
            } else {
                Motion.doMotion(freeCamera, speedMultiplier * ClientModConfig.INSTANCE.movement.horizontalSpeed, speedMultiplier * ClientModConfig.INSTANCE.movement.verticalSpeed);
            }
        }
    }

    public static boolean isScreenRoll() {
        return screenRoll;
    }

    public static boolean isRollRight() {
        return rollRight;
    }

    public static boolean isRollLeft() {
        return rollLeft;
    }

    public static boolean isRollUp() {
        return rollUp;
    }

    public static boolean isRollDown() {
        return rollDown;
    }

    public static double getLastMouseX() {
        return lastMouseX;
    }

    public static double getLastMouseY() {
        return lastMouseY;
    }

    public static void setLastMouseX(double lastMouseX) {
        Freecam.lastMouseX = lastMouseX;
    }

    public static void setLastMouseY(double lastMouseY) {
        Freecam.lastMouseY = lastMouseY;
    }

    public static int getCamRollButtonHoldTicks() {
        return CamRollButtonHoldTicks;
    }

    public static void setCamRollHoldTicks(int rightMouseHoldTicks) {
        CamRollButtonHoldTicks = rightMouseHoldTicks;
    }

    public static class_5498 getRememberedF5() {
        return rememberedF5;
    }

    public static void resetMouseButtons() {
        class_312 mouseHandler = class_310.method_1551().field_1729;
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        ((MouseHandlerAccessor)mouseHandler).callOnPress(windowHandle, 0, 0, 0);
        ((MouseHandlerAccessor)mouseHandler).callOnPress(windowHandle, 1, 0, 0);
    }

    public static double getSpeedMultiplier() {
        return speedMultiplier;
    }

    public static void setSpeedMultiplier(double speedMultiplier) {
        Freecam.speedMultiplier = speedMultiplier;
    }

    private static void alignFreeCameraToCurrentView() {
        freeCamera.syncToCamera(Freecam.MC.field_1773.method_19418());
    }

    static {
        rememberedF5 = null;
        CamRollButtonHoldTicks = 0;
        rollRight = false;
        rollLeft = false;
        rollUp = false;
        rollDown = false;
        screenRoll = false;
        isOnDisconnect = false;
        speedMultiplier = 1.0;
    }
}

