/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4066;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_761.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private class_4599 field_20951;
    @Unique
    private static final int TARGET_REMOVAL_CHECK_INTERVAL = 5;
    @Unique
    private int frameCounter = 0;
    @Unique
    private final Map<class_1297, Map<TargetInfo, Long>> pendingRemovals = new HashMap<class_1297, Map<TargetInfo, Long>>();

    @Shadow
    private void method_22977(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 vertexConsumers) {
    }

    @Shadow
    protected abstract class_4066 method_3268(boolean var1);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void onRender(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        double minDistance;
        double thresholdSquared;
        class_243 playerPos;
        class_243 cameraPos;
        double distanceSquared;
        if (Freecam.isEnabled() && Freecam.MC.field_1761.method_2920() != class_1934.field_9215 && ClientModConfig.INSTANCE.visual.showPlayer && (distanceSquared = (cameraPos = camera.method_19326()).method_1025(playerPos = Freecam.MC.field_1724.method_33571())) > (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            this.method_22977((class_1297)Freecam.MC.field_1724, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, tickDelta, matrices, (class_4597)this.field_20951.method_23000());
        }
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderEntity(class_1297 entity, double cameraX, double cameraY, double cameraZ, float tickDelta, class_4587 matrices, class_4597 bufferSource, CallbackInfo ci) {
        class_243 entityPos;
        double minDistance;
        double thresholdSquared;
        double distanceSquared;
        class_243 cameraPos;
        BaseCombatEntity baseCombatEntity;
        if (entity instanceof BaseCombatEntity && !(baseCombatEntity = (BaseCombatEntity)entity).getShouldRender()) {
            ci.cancel();
            return;
        }
        if (this.isEntityInInternalSeat(entity)) {
            ci.cancel();
            return;
        }
        if (!Freecam.isEnabled()) {
            return;
        }
        if (entity == Freecam.MC.field_1724) {
            if (Freecam.MC.field_1761.method_2920() == class_1934.field_9215) {
                ci.cancel();
                return;
            }
            if (ClientModConfig.INSTANCE.visual.showPlayer) {
                class_243 playerPos;
                cameraPos = Freecam.MC.field_1773.method_19418().method_19326();
                distanceSquared = cameraPos.method_1025(playerPos = Freecam.MC.field_1724.method_33571());
                if (distanceSquared <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
                    ci.cancel();
                }
            } else {
                ci.cancel();
            }
        }
        if (entity instanceof BaseCombatEntity && (distanceSquared = (cameraPos = Freecam.MC.field_1773.method_19418().method_19326()).method_1025(entityPos = entity.method_33571())) <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isEntityInInternalSeat(class_1297 entity) {
        class_1297 vehicle = entity.method_5854();
        if (vehicle instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)vehicle;
            return multiSeatVehicle.getSeatForEntity(entity).map(seat -> seat.getType() == MultiSeatVehicle.SeatType.INTERNAL).orElse(false);
        }
        return false;
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(class_4587 poseStack, float f, long l, boolean bl, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f matrix4f, CallbackInfo ci) {
        ++this.frameCounter;
        if (this.frameCounter >= 5) {
            this.frameCounter = 0;
            this.processTargetRemoval();
        }
    }

    @Unique
    private void processTargetRemoval() {
        CopyOnWriteArraySet<TargetInfo> targets;
        class_1297 entity;
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        Map<class_1297, CopyOnWriteArraySet<TargetInfo>> targetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        if (targetMap.isEmpty()) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Map.Entry<class_1297, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null) continue;
            for (TargetInfo target : targets) {
                String type = target.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                class_2338 targetPos = target.getPosition();
                String formationKey = type + "_" + targetPos.method_23854();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        for (Map.Entry<class_1297, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null || targets.isEmpty()) continue;
            class_243 formationCenter = entity.method_19538();
            List formationEntities = Collections.singletonList(entity);
            for (Map.Entry formationEntry : formationMap.entrySet()) {
                if (!((List)formationEntry.getValue()).contains(entity)) continue;
                formationEntities = (List)formationEntry.getValue();
                formationCenter = this.calculateCenterPosition(formationEntities);
                break;
            }
            this.processTargetRemovalForEntity(entity, targets, formationCenter, formationEntities);
        }
    }

    @Unique
    private void processTargetRemovalForEntity(class_1297 entity, CopyOnWriteArraySet<TargetInfo> targets, class_243 formationCenter, List<class_1297> formationEntities) {
        Iterator<TargetInfo> iterator;
        if (this.pendingRemovals.containsKey(entity)) {
            Map<TargetInfo, Long> removalMap = this.pendingRemovals.get(entity);
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<TargetInfo, Long>> entryIterator = removalMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                long timeout;
                Map.Entry<TargetInfo, Long> entry = entryIterator.next();
                String type = entry.getKey().getType();
                long l = timeout = (Objects.equals(type, "formTarget") || Objects.equals(type, "formAttackTarget")) && formationEntities.size() > 1 ? 1500L : 500L;
                if (currentTime - entry.getValue() <= timeout) continue;
                targets.remove(entry.getKey());
                entryIterator.remove();
            }
            if (removalMap.isEmpty()) {
                this.pendingRemovals.remove(entity);
            }
        }
        if (!targets.isEmpty() && (iterator = targets.iterator()).hasNext()) {
            TargetInfo firstTarget = iterator.next();
            class_2338 pos = firstTarget.getPosition();
            String type = firstTarget.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                if (!Objects.equals(type, "formTarget") && !Objects.equals(type, "formAttackTarget")) {
                    double threshold = Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
                    if (!(!this.hasArrivedAtTarget(entity, pos, threshold) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                } else {
                    double threshold;
                    class_243 targetPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.1, (double)pos.method_10260() + 0.5);
                    double distance = this.calculateHorizontalDistance(formationCenter, targetPos);
                    if (!(!(distance < (threshold = this.calculateFormationThreshold(formationEntities))) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                }
            }
        }
        targets.removeIf(target -> {
            String type = target.getType();
            if (Objects.equals(type, "entityTarget") || Objects.equals(type, "followTarget")) {
                class_1297 targetEntity = target.getHywTarget();
                return !targetEntity.method_5805();
            }
            return false;
        });
    }

    @Unique
    public double calculateHorizontalDistance(class_243 pos1, class_243 pos2) {
        return Math.sqrt(Math.pow(pos1.method_10216() - pos2.method_10216(), 2.0) + Math.pow(pos1.method_10215() - pos2.method_10215(), 2.0));
    }

    @Unique
    private boolean hasArrivedAtTarget(class_1297 entity, class_2338 targetPos, double threshold) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return false;
        }
        class_243 entityPos = entity.method_19538();
        class_243 targetPosVec = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 1.1, (double)targetPos.method_10260() + 0.5);
        class_2680 targetBlockState = level.method_8320(targetPos);
        boolean isTargetAir = targetBlockState.method_26215();
        double horizontalDistance = this.calculateHorizontalDistance(entityPos, targetPosVec);
        if (isTargetAir) {
            return horizontalDistance < threshold;
        }
        double verticalDistance = Math.abs(entityPos.method_10214() - targetPosVec.method_10214());
        return horizontalDistance < threshold && verticalDistance < threshold;
    }

    @Unique
    private class_243 calculateCenterPosition(List<class_1297> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return class_243.field_1353;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (class_1297 entity : selectedEntities) {
            class_243 entityPos = entity.method_19538();
            sumX += entityPos.field_1352;
            sumY += entityPos.field_1351;
            sumZ += entityPos.field_1350;
        }
        double centerX = sumX / (double)selectedEntities.size();
        double centerY = sumY / (double)selectedEntities.size();
        double centerZ = sumZ / (double)selectedEntities.size();
        return new class_243(centerX, centerY, centerZ);
    }

    @Unique
    private double calculateFormationThreshold(List<class_1297> formationEntities) {
        if (formationEntities.size() == 1) {
            class_1297 entity = formationEntities.get(0);
            if (entity instanceof BaseCombatEntity) {
                return Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
            }
            return 1.0;
        }
        return 8.0;
    }
}

