/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;

@Environment(value=EnvType.CLIENT)
public class HotKeyInfoHandler {
    private static HotKeyInfoHandler instance;
    private static final int PADDING = 2;
    private static final int ITEM_SPACING = 15;
    private static final float FONT_SCALE = 0.8f;

    private HotKeyInfoHandler() {
    }

    public static HotKeyInfoHandler getInstance() {
        if (instance == null) {
            instance = new HotKeyInfoHandler();
        }
        return instance;
    }

    private String formatKeyName(String keyName) {
        if (keyName.startsWith("key.")) {
            keyName = keyName.substring(4);
        }
        switch (keyName.toLowerCase()) {
            case "left_shift": 
            case "leftshift": {
                return "Shift";
            }
            case "left_control": 
            case "leftcontrol": {
                return "Ctrl";
            }
        }
        return keyName.toUpperCase();
    }

    private class_2561 getQueueModeInfo() {
        String keyName = HotKeyManager.getQueueModeCommandKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(keyName);
        return class_2561.method_43469((String)"hud.hundred_years_war.hotkey.queue_mode", (Object[])new Object[]{formattedKeyName});
    }

    private class_2561 getFormationToggleInfo() {
        String keyName = HotKeyManager.getFormationToggleKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(keyName);
        return class_2561.method_43469((String)"hud.hundred_years_war.hotkey.formation_toggle", (Object[])new Object[]{formattedKeyName});
    }

    private class_2561 getTeamColorInfo() {
        String keyName = HotKeyManager.getTeamColorToggleKey().method_16007().getString();
        String formattedKeyName = this.formatKeyName(keyName);
        return class_2561.method_43469((String)"hud.hundred_years_war.hotkey.team_color", (Object[])new Object[]{formattedKeyName});
    }

    private void drawScaledString(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, int color) {
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(x, y, 0.0f);
        poseStack.method_22905(0.8f, 0.8f, 1.0f);
        guiGraphics.method_27535(font, text, 0, 0, color);
        poseStack.method_22909();
    }

    private int getScaledWidth(class_327 font, class_2561 text) {
        return (int)((float)font.method_27525((class_5348)text) * 0.8f);
    }

    public void renderHotKeyInfo(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        class_327 font = minecraft.field_1772;
        class_2561 selectAllText = this.getSelectAllInfo();
        class_2561 formationToggleText = this.getFormationToggleInfo();
        class_2561 queueModeText = this.getQueueModeInfo();
        class_2561 teamColorText = this.getTeamColorInfo();
        class_2561[] entries = new class_2561[]{selectAllText, formationToggleText, queueModeText, teamColorText};
        int totalWidth = 0;
        int[] widths = new int[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            widths[i] = this.getScaledWidth(font, entries[i]);
            totalWidth += widths[i];
        }
        int startX = (screenWidth - (totalWidth += 15 * (entries.length - 1))) / 2;
        int y = screenHeight - 2 - 9;
        int currentX = startX;
        for (int i = 0; i < entries.length; ++i) {
            this.drawScaledString(guiGraphics, font, entries[i], currentX, y, 0xFFFFFF);
            currentX += widths[i] + 15;
        }
    }

    private class_2561 getSelectAllInfo() {
        class_2561 ctrl = HotKeyManager.getCtrlModeKey().method_16007();
        class_2561 select = HotKeyManager.getSelectAllUnitsKey().method_16007();
        class_5250 combo = class_2561.method_43473().method_10852(ctrl).method_10852((class_2561)class_2561.method_43470((String)"+")).method_10852(select);
        return class_2561.method_43469((String)"hud.hundred_years_war.hotkey.select_all", (Object[])new Object[]{combo});
    }
}

