/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class TrapezoidButton
extends class_339 {
    private final int cx;
    private final int cy;
    private final float innerR;
    private final float outerR;
    private final float a0;
    private final float a1;
    private int normalColor;
    private int hoverColor;
    private final class_5489 ml;
    private final Runnable onPress;
    private float alphaFactor = 1.0f;

    public TrapezoidButton(int cx, int cy, float innerR, float outerR, float startDeg, float endDeg, class_2561 label, Runnable onPress) {
        super((int)((float)cx - outerR), (int)((float)cy - outerR), (int)(outerR * 2.0f), (int)(outerR * 2.0f), label);
        this.cx = cx;
        this.cy = cy;
        this.innerR = innerR;
        this.outerR = outerR;
        this.a0 = (float)Math.toRadians(startDeg);
        this.a1 = (float)Math.toRadians(endDeg);
        this.normalColor = -1073741824;
        this.hoverColor = -1070583760;
        int maxLineWidth = (int)((outerR - innerR) * 0.6f);
        this.ml = class_5489.method_30890((class_327)class_310.method_1551().field_1772, (class_5348)label, (int)maxLineWidth);
        this.onPress = onPress;
    }

    public void method_25350(float alpha) {
        this.alphaFactor = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        this.updateColors();
    }

    private void updateColors() {
        int normalAlpha = this.normalColor >> 24 & 0xFF;
        int hoverAlpha = this.hoverColor >> 24 & 0xFF;
        normalAlpha = (int)((float)normalAlpha * this.alphaFactor);
        hoverAlpha = (int)((float)hoverAlpha * this.alphaFactor);
        this.normalColor = normalAlpha << 24 | this.normalColor & 0xFFFFFF;
        this.hoverColor = hoverAlpha << 24 | this.hoverColor & 0xFFFFFF;
    }

    public void method_48579(class_332 g, int mouseX, int mouseY, float partialTicks) {
        boolean hovered = this.method_25405(mouseX, mouseY);
        int fillColor = hovered ? this.hoverColor : this.normalColor;
        int borderColor = -1;
        if (this.alphaFactor < 1.0f) {
            int a = borderColor >> 24 & 0xFF;
            a = (int)((float)a * this.alphaFactor);
            borderColor = a << 24 | borderColor & 0xFFFFFF;
        }
        this.fillTrapezoid(g, fillColor);
        if (borderColor != 0) {
            this.drawBorderAll(g, 1.0f, borderColor);
        }
        this.drawLabel(g);
    }

    private void fillTrapezoid(class_332 g, int fillColor) {
        float[] xs = new float[]{(float)this.cx + this.innerR * class_3532.method_15362((float)this.a0), (float)this.cx + this.outerR * class_3532.method_15362((float)this.a0), (float)this.cx + this.outerR * class_3532.method_15362((float)this.a1), (float)this.cx + this.innerR * class_3532.method_15362((float)this.a1)};
        float[] ys = new float[]{(float)this.cy + this.innerR * class_3532.method_15374((float)this.a0), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a0), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a1), (float)this.cy + this.innerR * class_3532.method_15374((float)this.a1)};
        class_4587 poseStack = g.method_51448();
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        float alpha = (float)(fillColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(fillColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fillColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fillColor & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.disableCull();
        bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
        bufferBuilder.method_22918(matrix, xs[0], ys[0], 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, xs[1], ys[1], 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, xs[2], ys[2], 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, xs[0], ys[0], 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, xs[2], ys[2], 0.0f).method_22915(red, green, blue, alpha).method_1344();
        bufferBuilder.method_22918(matrix, xs[3], ys[3], 0.0f).method_22915(red, green, blue, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    private void drawBorderAll(class_332 g, float thickness, int color) {
        class_4587 poseStack = g.method_51448();
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableCull();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float gC = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_287 vb = class_289.method_1348().method_1349();
        float outerR2 = this.outerR + thickness;
        vb.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        vb.method_22918(matrix, (float)this.cx + outerR2 * class_3532.method_15362((float)this.a0), (float)this.cy + outerR2 * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + this.outerR * class_3532.method_15362((float)this.a0), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + outerR2 * class_3532.method_15362((float)this.a1), (float)this.cy + outerR2 * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + this.outerR * class_3532.method_15362((float)this.a1), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)vb.method_1326());
        float innerR2 = this.innerR - thickness;
        vb.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        vb.method_22918(matrix, (float)this.cx + this.innerR * class_3532.method_15362((float)this.a0), (float)this.cy + this.innerR * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + innerR2 * class_3532.method_15362((float)this.a0), (float)this.cy + innerR2 * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + this.innerR * class_3532.method_15362((float)this.a1), (float)this.cy + this.innerR * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + innerR2 * class_3532.method_15362((float)this.a1), (float)this.cy + innerR2 * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)vb.method_1326());
        vb.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        vb.method_22918(matrix, (float)this.cx + this.outerR * class_3532.method_15362((float)this.a0), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + this.innerR * class_3532.method_15362((float)this.a0), (float)this.cy + this.innerR * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + outerR2 * class_3532.method_15362((float)this.a0), (float)this.cy + outerR2 * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + innerR2 * class_3532.method_15362((float)this.a0), (float)this.cy + innerR2 * class_3532.method_15374((float)this.a0), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)vb.method_1326());
        vb.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        vb.method_22918(matrix, (float)this.cx + this.outerR * class_3532.method_15362((float)this.a1), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + this.innerR * class_3532.method_15362((float)this.a1), (float)this.cy + this.innerR * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + outerR2 * class_3532.method_15362((float)this.a1), (float)this.cy + outerR2 * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        vb.method_22918(matrix, (float)this.cx + innerR2 * class_3532.method_15362((float)this.a1), (float)this.cy + innerR2 * class_3532.method_15374((float)this.a1), 0.0f).method_22915(r, gC, b, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)vb.method_1326());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    private void drawRadialEdge(class_332 g, float angle, float thickness, int color, float inner, float outer) {
        float sin = class_3532.method_15374((float)angle);
        float cos = class_3532.method_15362((float)angle);
        float px = -sin * thickness * 0.5f;
        float py = cos * thickness * 0.5f;
        class_4587 ps = g.method_51448();
        Matrix4f m = ps.method_23760().method_23761();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float gC = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableCull();
        class_287 bb = class_289.method_1348().method_1349();
        bb.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        bb.method_22918(m, (float)this.cx + inner * cos - px, (float)this.cy + inner * sin - py, 0.0f).method_22915(r, gC, b, alpha).method_1344();
        bb.method_22918(m, (float)this.cx + inner * cos + px, (float)this.cy + inner * sin + py, 0.0f).method_22915(r, gC, b, alpha).method_1344();
        bb.method_22918(m, (float)this.cx + outer * cos - px, (float)this.cy + outer * sin - py, 0.0f).method_22915(r, gC, b, alpha).method_1344();
        bb.method_22918(m, (float)this.cx + outer * cos + px, (float)this.cy + outer * sin + py, 0.0f).method_22915(r, gC, b, alpha).method_1344();
        class_286.method_43433((class_287.class_7433)bb.method_1326());
    }

    private void drawLabel(class_332 g) {
        if (this.ml.method_30887() == 0) {
            return;
        }
        float deltaA = this.a1 >= this.a0 ? this.a1 - this.a0 : this.a1 + (float)Math.PI * 2 - this.a0;
        float midA = this.a0 + deltaA / 2.0f;
        if ((double)midA > Math.PI * 2) {
            midA -= (float)Math.PI * 2;
        }
        float midR = (this.innerR + this.outerR) / 2.0f;
        int tx = (int)((float)this.cx + midR * class_3532.method_15362((float)midA));
        int totalHeight = this.ml.method_30887() * 9;
        int ty = (int)((float)this.cy + midR * class_3532.method_15374((float)midA)) - totalHeight / 2;
        if (this.alphaFactor < 1.0f) {
            float currentAlpha = RenderSystem.getShaderColor()[3];
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(currentAlpha * this.alphaFactor));
            this.ml.method_30888(g, tx, ty);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlpha);
        } else {
            this.ml.method_30888(g, tx, ty);
        }
    }

    private void drawVertexMarkers(class_332 g) {
        float[] xs = new float[]{(float)this.cx + this.innerR * class_3532.method_15362((float)this.a0), (float)this.cx + this.outerR * class_3532.method_15362((float)this.a0), (float)this.cx + this.outerR * class_3532.method_15362((float)this.a1), (float)this.cx + this.innerR * class_3532.method_15362((float)this.a1)};
        float[] ys = new float[]{(float)this.cy + this.innerR * class_3532.method_15374((float)this.a0), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a0), (float)this.cy + this.outerR * class_3532.method_15374((float)this.a1), (float)this.cy + this.innerR * class_3532.method_15374((float)this.a1)};
        int markerSize = 4;
        int[] colors = new int[]{-65536, -16711936, -16776961, -256};
        for (int i = 0; i < 4; ++i) {
            int x = (int)xs[i] - markerSize / 2;
            int y = (int)ys[i] - markerSize / 2;
            g.method_25294(x, y, x + markerSize, y + markerSize, colors[i]);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.alphaFactor < 0.1f) {
            return false;
        }
        double dx = mouseX - (double)this.cx;
        double dy = mouseY - (double)this.cy;
        double r = Math.hypot(dx, dy);
        if (r < (double)this.innerR || r > (double)this.outerR) {
            return false;
        }
        double ang = Math.atan2(dy, dx);
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        if (this.a0 < this.a1) {
            return ang >= (double)this.a0 && ang <= (double)this.a1;
        }
        return ang >= (double)this.a0 || ang <= (double)this.a1;
    }

    protected void method_47399(class_6382 output) {
        this.method_37021(output);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.method_25354(class_310.method_1551().method_1483());
        if (this.onPress != null) {
            this.onPress.run();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && this.method_25405(mouseX, mouseY)) {
            this.method_25354(class_310.method_1551().method_1483());
            if (this.onPress != null) {
                this.onPress.run();
            }
            return true;
        }
        return false;
    }
}

