/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.client.gui.BuildingMoreOptionsScreen;
import ydmsama.hundred_years_war.client.gui.TemplatePropertiesScreen;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

@Environment(value=EnvType.CLIENT)
public class BuildingPlaceScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingPlaceScreen.class);
    private final class_1799 toolStack;
    private class_342 searchBox;
    private class_4185 confirmButton;
    private class_4185 cancelButton;
    private class_4185 refreshButton;
    private class_4185 backButton;
    private TemplateListWidget templateList;
    private List<FileSystemEntry> currentEntries = new ArrayList<FileSystemEntry>();
    private TemplateMetadata selectedTemplate = null;
    private boolean templatesLoading = false;
    private String currentPath = "";
    private Stack<String> pathStack = new Stack();
    private class_5676<Integer> rotationButton;
    private class_4185 moreOptionsButton;
    private static String cachedTemplateId = null;
    private static int cachedRotation = 0;
    private static long cachedBuildTime = 0L;
    private static boolean cachedGenerateConnectionLayer = false;
    private static boolean cachedTerrainCheck = false;
    private static final int WINDOW_WIDTH = 320;
    private static final int WINDOW_HEIGHT = 240;

    public BuildingPlaceScreen(class_1799 toolStack) {
        super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_place_title"));
        this.toolStack = toolStack;
        String existingTemplate = BuildingToolItem.getSelectedTemplate(toolStack);
        if (existingTemplate != null && !existingTemplate.isEmpty()) {
            String[] parts = existingTemplate.split("\\|");
            cachedTemplateId = parts[0];
            try {
                cachedRotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                cachedBuildTime = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
                cachedGenerateConnectionLayer = parts.length > 3 && Boolean.parseBoolean(parts[3]);
                cachedTerrainCheck = parts.length > 4 && Boolean.parseBoolean(parts[4]);
            }
            catch (NumberFormatException e) {
                cachedRotation = 0;
                cachedBuildTime = 0L;
                cachedGenerateConnectionLayer = false;
                cachedTerrainCheck = false;
            }
        }
    }

    protected void method_25426() {
        super.method_25426();
        int startX = (this.field_22789 - 320) / 2;
        int startY = (this.field_22790 - 240) / 2;
        this.searchBox = new class_342(this.field_22793, startX + 10, startY + 25, 150, 20, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_place.search_hint"));
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.back"), button -> this.navigateBack()).method_46433(startX + 165, startY + 25).method_46437(60, 20).method_46431();
        this.backButton.field_22763 = !this.pathStack.isEmpty();
        this.method_37063((class_364)this.backButton);
        this.refreshButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.refresh"), button -> this.requestTemplateMetadata()).method_46433(startX + 230, startY + 25).method_46437(60, 20).method_46431();
        this.method_37063((class_364)this.refreshButton);
        this.templateList = new TemplateListWidget(this.field_22787, 300, 115, startX + 10, startY + 55);
        this.method_25429((class_364)this.templateList);
        this.rotationButton = class_5676.method_32606(i -> class_2561.method_43469((String)"gui.hundred_years_war.building_place.rotation", (Object[])new Object[]{i})).method_32624((Object[])new Integer[]{0, 90, 180, 270}).method_32619((Object)cachedRotation).method_35723(startX + 10, startY + 175, 100, 20, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_place.rotation_button"));
        this.method_37063((class_364)this.rotationButton);
        this.moreOptionsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_place.more_options"), button -> this.openMoreOptions()).method_46433(startX + 250, startY + 175).method_46437(60, 20).method_46431();
        this.method_37063((class_364)this.moreOptionsButton);
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.confirm"), button -> this.confirmSelection()).method_46433(startX + 320 - 115, startY + 240 - 30).method_46437(50, 20).method_46431();
        this.confirmButton.field_22763 = false;
        this.method_37063((class_364)this.confirmButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), button -> this.method_25419()).method_46433(startX + 320 - 60, startY + 240 - 30).method_46437(50, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.requestTemplateMetadata();
        this.restoreCachedSelection();
    }

    private void onSearchChanged(String search) {
        this.filterTemplates();
        this.backButton.field_22763 = !search.isEmpty() ? false : !this.pathStack.isEmpty();
    }

    private void navigateBack() {
        if (!this.pathStack.isEmpty()) {
            this.currentPath = this.pathStack.pop();
            this.refreshTemplates();
        }
        this.backButton.field_22763 = !this.pathStack.isEmpty();
    }

    private void openMoreOptions() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new BuildingMoreOptionsScreen(this));
        }
    }

    public static void updateConnectionLayer(boolean generateConnectionLayer) {
        cachedGenerateConnectionLayer = generateConnectionLayer;
    }

    public static boolean getCachedConnectionLayer() {
        return cachedGenerateConnectionLayer;
    }

    public static void updateBuildTime(long buildTime) {
        cachedBuildTime = buildTime;
    }

    public static long getCachedBuildTime() {
        return cachedBuildTime;
    }

    public static void updateTerrainCheck(boolean terrainCheck) {
        cachedTerrainCheck = terrainCheck;
    }

    public static boolean getCachedTerrainCheck() {
        return cachedTerrainCheck;
    }

    private void navigateToFolder(String folder) {
        this.pathStack.push(this.currentPath);
        this.currentPath = this.currentPath.isEmpty() ? folder : this.currentPath + "/" + folder;
        this.refreshTemplates();
        this.backButton.field_22763 = true;
    }

    private void filterTemplates() {
        String search = this.searchBox.method_1882().toLowerCase();
        if (this.templatesLoading) {
            this.templateList.updateEntries(Collections.emptyList());
            return;
        }
        if (search.isEmpty()) {
            this.templateList.updateEntries(this.currentEntries);
        } else {
            ArrayList<FileSystemEntry> filtered = new ArrayList<FileSystemEntry>();
            if (TemplateManager.getInstance() != null) {
                for (TemplateMetadata template : TemplateManager.getInstance().getAllMetadata()) {
                    if (!template.getName().toLowerCase().contains(search) && !template.getDescription().toLowerCase().contains(search) && !template.getCategory().toLowerCase().contains(search)) continue;
                    filtered.add(new TemplateEntry(template));
                }
            }
            this.templateList.updateEntries(filtered);
        }
    }

    private void refreshTemplates() {
        this.currentEntries.clear();
        if (this.templatesLoading) {
            this.templateList.updateEntries(Collections.emptyList());
            this.confirmButton.field_22763 = false;
            return;
        }
        if (TemplateManager.getInstance() != null) {
            HashMap<String, Set> folderStructure = new HashMap<String, Set>();
            ArrayList<TemplateMetadata> templatesInCurrentPath = new ArrayList<TemplateMetadata>();
            for (TemplateMetadata template : TemplateManager.getInstance().getAllMetadata()) {
                String templateId = template.getTemplateId();
                if (templateId != null && templateId.contains("/")) {
                    String[] parts = templateId.split("/");
                    String currentFolderPath = "";
                    for (int i = 0; i < parts.length - 1; ++i) {
                        String parentPath = currentFolderPath;
                        String folderName = parts[i];
                        if (folderName.equals("resource")) continue;
                        currentFolderPath = parentPath.isEmpty() ? folderName : parentPath + "/" + folderName;
                        folderStructure.computeIfAbsent(parentPath, k -> new HashSet()).add(folderName);
                    }
                    String templateDir = "";
                    if (parts.length > 1) {
                        int startIdx;
                        int n = startIdx = parts[0].equals("resource") ? 1 : 0;
                        if (parts.length - startIdx > 1) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = startIdx; i < parts.length - 1; ++i) {
                                if (sb.length() > 0) {
                                    sb.append("/");
                                }
                                sb.append(parts[i]);
                            }
                            templateDir = sb.toString();
                        }
                    }
                    if (!templateDir.equals(this.currentPath)) continue;
                    templatesInCurrentPath.add(template);
                    continue;
                }
                if (!this.currentPath.isEmpty()) continue;
                templatesInCurrentPath.add(template);
            }
            Set foldersHere = (Set)folderStructure.get(this.currentPath);
            if (foldersHere != null) {
                for (String folder : foldersHere) {
                    this.currentEntries.add(new FolderEntry(folder));
                }
            }
            for (TemplateMetadata template : templatesInCurrentPath) {
                this.currentEntries.add(new TemplateEntry(template));
            }
            this.currentEntries.sort((a, b) -> {
                if (a.isFolder() != b.isFolder()) {
                    return a.isFolder() ? -1 : 1;
                }
                return a.getName().compareTo(b.getName());
            });
            LOGGER.debug("Current path: '{}', Found {} folders and {} templates", new Object[]{this.currentPath, foldersHere != null ? foldersHere.size() : 0, templatesInCurrentPath.size()});
        }
        this.filterTemplates();
    }

    private void confirmSelection() {
        if (this.selectedTemplate != null) {
            String templateData = this.selectedTemplate.getTemplateId() + "|" + this.rotationButton.method_32603() + "|" + cachedBuildTime + "|" + cachedGenerateConnectionLayer + "|" + cachedTerrainCheck;
            BuildingToolItem.setSelectedTemplate(this.toolStack, templateData);
            cachedTemplateId = this.selectedTemplate.getTemplateId();
            cachedRotation = (Integer)this.rotationButton.method_32603();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_place.template_selected").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)this.selectedTemplate.getName()).method_27692(class_124.field_1065)), true);
            }
            this.method_25419();
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        int startX = (this.field_22789 - 320) / 2;
        int startY = (this.field_22790 - 240) / 2;
        graphics.method_25294(startX - 2, startY - 2, startX + 320 + 2, startY + 240 + 2, -16777216);
        graphics.method_25294(startX, startY, startX + 320, startY + 240, -3750202);
        graphics.method_25294(startX + 2, startY + 2, startX + 320 - 2, startY + 20, -11908534);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_place.select_template"), this.field_22789 / 2, startY + 7, 0xFFFFFF);
        if (!this.searchBox.method_1882().isEmpty()) {
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.hundred_years_war.building_place.global_search", (Object[])new Object[]{this.searchBox.method_1882()}), startX + 10, startY + 50, 0x60A060);
        }
        graphics.method_25294(startX + 8, startY + 53, startX + 320 - 8, startY + 172, -1);
        graphics.method_25294(startX + 9, startY + 54, startX + 320 - 9, startY + 171, -16777216);
        graphics.method_25294(startX + 10, startY + 55, startX + 320 - 10, startY + 170, -2039584);
        if (this.templateList != null) {
            graphics.method_44379(startX + 10, startY + 55, startX + 320 - 10, startY + 170);
            this.templateList.method_25394(graphics, mouseX, mouseY, partialTick);
            graphics.method_44380();
            if (this.templatesLoading) {
                graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading templates..."), startX + 160, startY + 115, 0x606060);
            } else if (this.templateList.isEmpty()) {
                graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No templates available"), startX + 160, startY + 115, 0x606060);
            }
        }
        if (this.selectedTemplate != null) {
            int infoY = startY + 200;
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.hundred_years_war.building_place.selected", (Object[])new Object[]{this.selectedTemplate.getName()}), startX + 10, infoY, 0xFFFFFF);
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.hundred_years_war.building_place.size", (Object[])new Object[]{this.selectedTemplate.getSize().method_23854()}), startX + 10, infoY + 10, 0xFFFFFF);
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.hundred_years_war.building_place.block_count", (Object[])new Object[]{this.selectedTemplate.getTotalBlocks()}), startX + 100, infoY + 10, 0xFFFFFF);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25421() {
        return false;
    }

    private void requestTemplateMetadata() {
        TemplateManager manager;
        this.templatesLoading = true;
        this.confirmButton.field_22763 = false;
        if (this.refreshButton != null) {
            this.refreshButton.field_22763 = false;
        }
        if (this.searchBox != null) {
            this.searchBox.method_1888(false);
        }
        if (this.backButton != null) {
            this.backButton.field_22763 = false;
        }
        if ((manager = TemplateManager.getInstance()) != null) {
            manager.clearClientMetadata();
        }
        if (this.templateList != null) {
            this.templateList.setSelected(null);
        }
        this.refreshTemplates();
        ClientPacketHandler.sendTemplateListRequest();
    }

    private void restoreCachedSelection() {
        TemplateMetadata cached;
        if (cachedTemplateId != null && TemplateManager.getInstance() != null && this.templateList != null && (cached = TemplateManager.getInstance().getMetadata(cachedTemplateId)) != null) {
            this.selectedTemplate = cached;
            this.confirmButton.field_22763 = true;
            this.templateList.selectTemplateById(cachedTemplateId);
        }
    }

    public void onTemplateListUpdated() {
        this.templatesLoading = false;
        if (this.refreshButton != null) {
            this.refreshButton.field_22763 = true;
        }
        if (this.searchBox != null) {
            this.searchBox.method_1888(true);
        }
        TemplateManager manager = TemplateManager.getInstance();
        TemplateMetadata toSelect = null;
        if (manager != null) {
            if (this.selectedTemplate != null) {
                toSelect = manager.getMetadata(this.selectedTemplate.getTemplateId());
            }
            if (toSelect == null && cachedTemplateId != null) {
                toSelect = manager.getMetadata(cachedTemplateId);
            }
        }
        this.selectedTemplate = toSelect;
        this.confirmButton.field_22763 = this.selectedTemplate != null;
        this.refreshTemplates();
        if (this.selectedTemplate != null && this.templateList != null) {
            this.templateList.selectTemplateById(this.selectedTemplate.getTemplateId());
        }
        if (this.backButton != null) {
            this.backButton.field_22763 = !this.pathStack.isEmpty();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class TemplateListWidget
    extends class_350<EntryWidget> {
        public TemplateListWidget(class_310 minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, y, y + height, 20);
            this.method_25333(x);
        }

        protected int method_25329() {
            return this.field_19088 + this.field_22742 - 6;
        }

        public int method_25322() {
            return this.field_22742 - 15;
        }

        public void method_37020(class_6382 narrationElementOutput) {
            if (this.method_25334() != null) {
                narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)("Selected: " + ((EntryWidget)this.method_25334()).entry.getName())));
            }
        }

        public void updateEntries(List<FileSystemEntry> entries) {
            this.method_25339();
            for (FileSystemEntry entry : entries) {
                this.method_25321(new EntryWidget(entry));
            }
        }

        public int getEntryCount() {
            return this.method_25396().size();
        }

        public boolean isEmpty() {
            return this.method_25396().isEmpty();
        }

        public void selectTemplateById(String templateId) {
            if (templateId == null) {
                this.setSelected(null);
                return;
            }
            for (EntryWidget widget : this.method_25396()) {
                TemplateEntry templateEntry;
                if (widget.entry.isFolder() || !templateId.equals((templateEntry = (TemplateEntry)widget.entry).getTemplate().getTemplateId())) continue;
                this.setSelected(widget);
                this.method_25328(widget);
                return;
            }
            this.setSelected(null);
        }

        public void setSelected(EntryWidget entry) {
            super.method_25313((class_350.class_351)entry);
            if (entry != null && !entry.entry.isFolder()) {
                BuildingPlaceScreen.this.selectedTemplate = ((TemplateEntry)entry.entry).getTemplate();
                BuildingPlaceScreen.this.confirmButton.field_22763 = true;
            } else {
                BuildingPlaceScreen.this.selectedTemplate = null;
                BuildingPlaceScreen.this.confirmButton.field_22763 = cachedTemplateId != null;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public class EntryWidget
        extends class_350.class_351<EntryWidget> {
            private final FileSystemEntry entry;
            private int cachedButtonX = -1;
            private int cachedButtonY = -1;
            private int cachedButtonWidth = 20;
            private int cachedButtonHeight = 12;

            public EntryWidget(FileSystemEntry entry) {
                this.entry = entry;
            }

            public void method_25343(@NotNull class_332 graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int top = y;
                int left = x;
                boolean onButton = false;
                if (!this.entry.isFolder()) {
                    this.cachedButtonX = left + width - this.cachedButtonWidth - 15;
                    this.cachedButtonY = top + 2;
                    boolean bl = onButton = mouseX >= this.cachedButtonX && mouseX <= this.cachedButtonX + this.cachedButtonWidth && mouseY >= this.cachedButtonY && mouseY <= this.cachedButtonY + this.cachedButtonHeight;
                }
                if (hovering && !onButton) {
                    graphics.method_25294(left, top, left + width - 10, top + height, 0x40FFFFFF);
                }
                if (this.entry.isFolder()) {
                    graphics.method_27535(BuildingPlaceScreen.this.field_22793, (class_2561)class_2561.method_43469((String)"gui.hundred_years_war.building_place.folder_prefix", (Object[])new Object[]{this.entry.getName()}), left + 5, top + 5, 26316);
                } else {
                    TemplateEntry templateEntry = (TemplateEntry)this.entry;
                    TemplateMetadata template = templateEntry.getTemplate();
                    graphics.method_25303(BuildingPlaceScreen.this.field_22793, template.getName(), left + 5, top + 2, 0xFFFFFF);
                    String info = class_2561.method_43469((String)"gui.hundred_years_war.building_place.template_info", (Object[])new Object[]{template.getSize().method_23854(), template.getTotalBlocks()}).getString();
                    graphics.method_25303(BuildingPlaceScreen.this.field_22793, info, left + 5, top + 11, 0xA0A0A0);
                    boolean buttonHover = mouseX >= this.cachedButtonX && mouseX <= this.cachedButtonX + this.cachedButtonWidth && mouseY >= this.cachedButtonY && mouseY <= this.cachedButtonY + this.cachedButtonHeight;
                    graphics.method_25294(this.cachedButtonX, this.cachedButtonY, this.cachedButtonX + this.cachedButtonWidth, this.cachedButtonY + this.cachedButtonHeight, buttonHover ? -10461088 : -12566464);
                    graphics.method_25294(this.cachedButtonX + 1, this.cachedButtonY + 1, this.cachedButtonX + this.cachedButtonWidth - 1, this.cachedButtonY + this.cachedButtonHeight - 1, buttonHover ? -8355712 : -10461088);
                    graphics.method_25300(BuildingPlaceScreen.this.field_22793, "...", this.cachedButtonX + this.cachedButtonWidth / 2, this.cachedButtonY + 2, 0xFFFFFF);
                }
                if (TemplateListWidget.this.method_25334() == this) {
                    graphics.method_25294(left, top, left + 2, top + height, -16744193);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (!this.entry.isFolder()) {
                        TemplateEntry templateEntry = (TemplateEntry)this.entry;
                        TemplateMetadata template = templateEntry.getTemplate();
                        if (this.cachedButtonX < 0 || this.cachedButtonY < 0) {
                            int entryIndex = BuildingPlaceScreen.this.templateList.method_25396().indexOf((Object)this);
                            int entryY = BuildingPlaceScreen.this.templateList.method_25337(entryIndex);
                            int entryX = BuildingPlaceScreen.this.templateList.field_19088;
                            int entryWidth = BuildingPlaceScreen.this.templateList.method_25322();
                            this.cachedButtonX = entryX + entryWidth - this.cachedButtonWidth - 15;
                            this.cachedButtonY = entryY + 2;
                        }
                        if (mouseX >= (double)(this.cachedButtonX - 2) && mouseX <= (double)(this.cachedButtonX + this.cachedButtonWidth + 2) && mouseY >= (double)(this.cachedButtonY - 2) && mouseY <= (double)(this.cachedButtonY + this.cachedButtonHeight + 2)) {
                            if (TemplateListWidget.this.field_22740 != null) {
                                TemplateListWidget.this.field_22740.method_1507((class_437)new TemplatePropertiesScreen(BuildingPlaceScreen.this, template.getTemplateId()));
                            }
                            return true;
                        }
                        TemplateListWidget.this.setSelected(this);
                        return true;
                    }
                    if (this.entry.isFolder()) {
                        if (BuildingPlaceScreen.this.searchBox.method_1882().isEmpty()) {
                            BuildingPlaceScreen.this.navigateToFolder(this.entry.getName());
                        }
                        return true;
                    }
                }
                return false;
            }

            private int getX() {
                return BuildingPlaceScreen.this.templateList.field_19088;
            }

            private int getY() {
                return BuildingPlaceScreen.this.templateList.method_25337(BuildingPlaceScreen.this.templateList.method_25396().indexOf((Object)this));
            }

            @NotNull
            public class_2561 getNarration() {
                return class_2561.method_43470((String)this.entry.getName());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class TemplateEntry
    extends FileSystemEntry {
        private final TemplateMetadata template;

        TemplateEntry(TemplateMetadata template) {
            this.template = template;
        }

        @Override
        String getName() {
            return this.template.getName();
        }

        @Override
        boolean isFolder() {
            return false;
        }

        @Override
        boolean matchesSearch(String search) {
            return search.isEmpty() || this.template.getName().toLowerCase().contains(search) || this.template.getDescription().toLowerCase().contains(search) || this.template.getCategory().toLowerCase().contains(search);
        }

        TemplateMetadata getTemplate() {
            return this.template;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class FolderEntry
    extends FileSystemEntry {
        private final String name;

        FolderEntry(String name) {
            this.name = name;
        }

        @Override
        String getName() {
            return this.name;
        }

        @Override
        boolean isFolder() {
            return true;
        }

        @Override
        boolean matchesSearch(String search) {
            return search.isEmpty() || this.name.toLowerCase().contains(search);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static abstract class FileSystemEntry {
        private FileSystemEntry() {
        }

        abstract String getName();

        abstract boolean isFolder();

        abstract boolean matchesSearch(String var1);
    }
}

