/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import ydmsama.hundred_years_war.client.gui.TemplatePropertiesScreen;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

@Environment(value=EnvType.CLIENT)
public class BuildingSaveScreen
extends class_437 {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final class_1799 toolStack;
    private class_342 nameBox;
    private class_342 categoryBox;
    private class_342 descriptionBox;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_4185 moreOptionsButton;
    private boolean isSaving = false;
    private CheckBox includeEntitiesBox;
    private CheckBox includeBlockDataBox;
    private CheckBox generateMirrorBox;
    private boolean cachedEnableGeneration = false;
    private int cachedGenerationWeight = 1;
    private int cachedConnectionLayerDepth = 10;
    private int cachedMinGenerationHeight = -64;
    private int cachedMaxGenerationHeight = 320;
    private boolean cachedGenerateOnSurface = true;
    private Map<String, JsonElement> cachedCustomAttributes = new LinkedHashMap<String, JsonElement>(TemplateMetadata.createDefaultAttributes());
    private String cachedName = "";
    private String cachedCategory = "";
    private String cachedDescription = "";
    private static final int WINDOW_WIDTH = 280;
    private static final int WINDOW_HEIGHT = 220;
    private static final int LABEL_MAX_WIDTH = 35;
    private int scrollOffset = 0;
    private int scrollDirection = 1;
    private int scrollDelay = 0;

    public BuildingSaveScreen(class_1799 toolStack) {
        super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.title"));
        this.toolStack = toolStack;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int startX = centerX - 140;
        int startY = centerY - 110;
        this.nameBox = new class_342(this.field_22793, startX + 70, startY + 30, 180, 16, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.name"));
        this.nameBox.method_1880(50);
        this.nameBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.name_hint"));
        this.nameBox.method_1852(this.cachedName);
        this.method_37063((class_364)this.nameBox);
        this.categoryBox = new class_342(this.field_22793, startX + 70, startY + 55, 180, 16, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.category"));
        this.categoryBox.method_1880(30);
        this.categoryBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.category_hint"));
        this.categoryBox.method_1852(this.cachedCategory);
        this.method_37063((class_364)this.categoryBox);
        this.descriptionBox = new class_342(this.field_22793, startX + 70, startY + 80, 180, 30, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.description"));
        this.descriptionBox.method_1880(200);
        this.descriptionBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.description_hint"));
        this.descriptionBox.method_1852(this.cachedDescription);
        this.method_37063((class_364)this.descriptionBox);
        this.includeEntitiesBox = new CheckBox(startX + 30, startY + 130, 200, 12, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.include_entities"), true, null, this.field_22793);
        this.method_37063((class_364)this.includeEntitiesBox);
        this.includeBlockDataBox = new CheckBox(startX + 30, startY + 145, 200, 12, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.include_block_data"), true, null, this.field_22793);
        this.method_37063((class_364)this.includeBlockDataBox);
        this.generateMirrorBox = new CheckBox(startX + 30, startY + 160, 200, 12, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.generate_mirror"), false, null, this.field_22793);
        this.method_37063((class_364)this.generateMirrorBox);
        this.moreOptionsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.more_options"), button -> this.openMoreOptions()).method_46433(startX + 10, startY + 220 - 30).method_46437(80, 20).method_46431();
        this.method_37063((class_364)this.moreOptionsButton);
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.save"), button -> this.saveBuilding()).method_46433(startX + 280 - 110, startY + 220 - 30).method_46437(50, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), button -> this.method_25419()).method_46433(startX + 280 - 55, startY + 220 - 30).method_46437(50, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
    }

    private void openMoreOptions() {
        if (this.field_22787 != null) {
            this.cachedName = this.nameBox.method_1882();
            this.cachedCategory = this.categoryBox.method_1882();
            this.cachedDescription = this.descriptionBox.method_1882();
            String templateName = this.cachedName.trim();
            if (templateName.isEmpty()) {
                templateName = class_2561.method_43471((String)"gui.hundred_years_war.building_save.unnamed").getString();
            }
            this.field_22787.method_1507((class_437)new TemplatePropertiesScreen(this, templateName, this.cachedEnableGeneration, this.cachedGenerationWeight, this.cachedConnectionLayerDepth, this.cachedMinGenerationHeight, this.cachedMaxGenerationHeight, this.cachedGenerateOnSurface, new LinkedHashMap<String, JsonElement>(this.cachedCustomAttributes), data -> {
                this.cachedEnableGeneration = data.enableGeneration();
                this.cachedGenerationWeight = data.generationWeight();
                this.cachedConnectionLayerDepth = data.connectionLayerDepth();
                this.cachedMinGenerationHeight = data.minGenerationHeight();
                this.cachedMaxGenerationHeight = data.maxGenerationHeight();
                this.cachedGenerateOnSurface = data.generateOnSurface();
                this.cachedCustomAttributes = new LinkedHashMap<String, JsonElement>();
                data.customAttributes().forEach((key, value) -> this.cachedCustomAttributes.put((String)key, (JsonElement)(value == null ? JsonNull.INSTANCE : value.deepCopy())));
            }));
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.nameBox != null) {
            this.nameBox.method_1865();
        }
        if (this.categoryBox != null) {
            this.categoryBox.method_1865();
        }
        if (this.descriptionBox != null) {
            this.descriptionBox.method_1865();
        }
        this.updateLabelScroll();
    }

    private void updateLabelScroll() {
        if (++this.scrollDelay >= 2) {
            this.scrollDelay = 0;
            this.scrollOffset += this.scrollDirection;
            if (Math.abs(this.scrollOffset) > 10) {
                this.scrollDirection = -this.scrollDirection;
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int startX = centerX - 140;
        int startY = centerY - 110;
        graphics.method_25294(startX, startY, startX + 280, startY + 220, -533712848);
        graphics.method_25294(startX + 1, startY + 1, startX + 280 - 1, startY + 220 - 1, -535818224);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.title"), centerX, startY + 8, 0xFFFFFF);
        this.drawScrollingLabel(graphics, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.name_label"), startX + 30, startY + 33, 35);
        this.drawScrollingLabel(graphics, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.category_label"), startX + 30, startY + 58, 35);
        this.drawScrollingLabel(graphics, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.description_label"), startX + 30, startY + 83, 35);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.save_options"), startX + 30, startY + 115, 0xFFFF00);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.nameBox.method_1882().isEmpty()) {
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.name_required"), startX + 30, startY + 220 - 45, 0xFF5555);
        }
    }

    private void drawScrollingLabel(class_332 graphics, class_2561 text, int x, int y, int maxWidth) {
        int textWidth = this.field_22793.method_27525((class_5348)text);
        if (textWidth <= maxWidth) {
            graphics.method_27535(this.field_22793, text, x, y, 0xFFFFFF);
        } else {
            Objects.requireNonNull(this.field_22793);
            graphics.method_44379(x, y - 2, x + maxWidth, y + 9 + 2);
            int totalWidth = textWidth + 20;
            int scrollPos = this.scrollOffset % totalWidth;
            graphics.method_27535(this.field_22793, text, x - scrollPos, y, 0xFFFFFF);
            graphics.method_27535(this.field_22793, text, x - scrollPos + totalWidth, y, 0xFFFFFF);
            graphics.method_44380();
        }
    }

    private void saveBuilding() {
        String name = this.nameBox.method_1882().trim();
        if (name.isEmpty()) {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.building_save.enter_name").method_27661().method_27692(class_124.field_1061), true);
            }
            return;
        }
        String category = this.categoryBox.method_1882().trim();
        String description = this.descriptionBox.method_1882().trim();
        JsonObject settings = new JsonObject();
        settings.addProperty("category", category);
        settings.addProperty("description", description);
        settings.addProperty("includeEntities", Boolean.valueOf(this.includeEntitiesBox.isChecked()));
        settings.addProperty("includeBlockData", Boolean.valueOf(this.includeBlockDataBox.isChecked()));
        settings.addProperty("generateMirror", Boolean.valueOf(this.generateMirrorBox.isChecked()));
        settings.addProperty("enableGeneration", Boolean.valueOf(this.cachedEnableGeneration));
        settings.addProperty("generationWeight", (Number)this.cachedGenerationWeight);
        settings.addProperty("connectionLayerDepth", (Number)this.cachedConnectionLayerDepth);
        settings.addProperty("minGenerationHeight", (Number)this.cachedMinGenerationHeight);
        settings.addProperty("maxGenerationHeight", (Number)this.cachedMaxGenerationHeight);
        settings.addProperty("generateOnSurface", Boolean.valueOf(this.cachedGenerateOnSurface));
        JsonObject attributes = new JsonObject();
        this.cachedCustomAttributes.forEach((key, value) -> attributes.add(key, (JsonElement)(value == null ? JsonNull.INSTANCE : value.deepCopy())));
        settings.add("customAttributes", (JsonElement)attributes);
        ClientPacketHandler.sendBuildingToolSaveBuilding(name, GSON.toJson((JsonElement)settings));
        BuildingToolItem.resetSaveState(this.toolStack);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"gui.hundred_years_war.building_save.saved", (Object[])new Object[]{name}).method_27661().method_27692(class_124.field_1060), true);
        }
        this.isSaving = true;
        this.method_25419();
    }

    public void method_25419() {
        class_1799 mainHand;
        super.method_25419();
        if (!this.isSaving && this.field_22787 != null && this.field_22787.field_1724 != null && (mainHand = this.field_22787.field_1724.method_6047()).method_7909() instanceof BuildingToolItem) {
            BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.NONE);
            BuildingToolItem.setFirstPos(mainHand, null);
            BuildingToolItem.setSecondPos(mainHand, null);
            BuildingToolItem.setEntrancePos(mainHand, null);
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static class CheckBox
    extends class_339 {
        private boolean checked;
        private final Runnable onChange;
        private final class_327 font;

        public CheckBox(int x, int y, int width, int height, class_2561 message, boolean defaultValue, Runnable onChange, class_327 font) {
            super(x, y, width, height, message);
            this.checked = defaultValue;
            this.onChange = onChange;
            this.font = font;
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            int boxSize = 10;
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + boxSize, this.method_46427() + boxSize, -1);
            graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + boxSize - 1, this.method_46427() + boxSize - 1, -16777216);
            if (this.checked) {
                graphics.method_25303(this.font, "\u2713", this.method_46426() + 2, this.method_46427() + 1, 65280);
            }
            graphics.method_27535(this.font, this.method_25369(), this.method_46426() + boxSize + 5, this.method_46427() + 1, 0xFFFFFF);
        }

        public void method_25348(double mouseX, double mouseY) {
            boolean bl = this.checked = !this.checked;
            if (this.onChange != null) {
                this.onChange.run();
            }
        }

        protected void method_47399(class_6382 output) {
        }

        public boolean isChecked() {
            return this.checked;
        }
    }
}

