/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeDefinition;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeType;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributes;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTagDefinition;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTags;

@Environment(value=EnvType.CLIENT)
public class TemplatePropertiesScreen
extends class_437 {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final int WINDOW_WIDTH = 360;
    private static final int WINDOW_HEIGHT = 280;
    private static final String BUILDING_TAGS_KEY = "building_tags";
    private static final List<String> BUILT_IN_KEYS = List.of("enable_generation", "require_pregen", "generation_weight", "connection_layer_depth", "min_generation_height", "max_generation_height", "generate_on_surface", "generate_underwater", "generate_on_water_surface", "author", "min_burial_rate", "max_burial_rate");
    private static final Set<String> REQUIRED_CUSTOM_KEYS = Set.of("biome_blacklist", "use_whitelist", "building_tags");
    private final class_437 parentScreen;
    private final String templateId;
    private final TemplateMetadata metadata;
    private final boolean isNewTemplate;
    private final PropertiesCallback callback;
    private boolean generationEnabled;
    private int generationWeight;
    private int connectionLayerDepth;
    private int minGenerationHeight;
    private int maxGenerationHeight;
    private boolean generateOnSurface;
    private boolean requirePregen;
    private boolean generateUnderwater;
    private boolean generateOnWaterSurface;
    private String templateAuthor = "";
    private double minBurialRate = 0.0;
    private double maxBurialRate = 1.0;
    private final Map<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
    private final List<BasePropertyModel> builtInProperties = new ArrayList<BasePropertyModel>();
    private final List<BasePropertyModel> allProperties = new ArrayList<BasePropertyModel>();
    private AttributeListWidget attributeList;
    private class_342 searchBox;
    private class_4185 addButton;
    private class_4185 saveButton;
    private class_4185 cancelButton;
    private class_2561 errorMessage;
    private String searchText = "";
    private String templateNameForDisplay = "";
    private int layoutLeft;
    private int layoutTop;
    private int layoutHeight;

    public TemplatePropertiesScreen(class_437 parentScreen, String templateId) {
        super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.title"));
        this.parentScreen = parentScreen;
        this.templateId = templateId;
        this.isNewTemplate = false;
        this.callback = null;
        this.metadata = TemplateManager.getInstance().getMetadata(templateId);
        if (this.metadata != null) {
            this.metadata.ensureCommonAttributes();
            this.initialiseState(this.metadata.isGenerationEnabled(), this.metadata.getGenerationWeight(), this.metadata.getConnectionLayerDepth(), this.metadata.getMinGenerationHeight(), this.metadata.getMaxGenerationHeight(), this.metadata.isGenerateOnSurface(), this.metadata.getCustomAttributes(), this.metadata.getName());
        } else {
            this.initialiseState(false, 1, 10, -64, 320, true, TemplateMetadata.createDefaultAttributes(), templateId);
        }
    }

    public TemplatePropertiesScreen(class_437 parentScreen, String templateName, boolean currentEnableGeneration, int currentGenerationWeight, int currentConnectionLayerDepth, int currentMinGenerationHeight, int currentMaxGenerationHeight, boolean currentGenerateOnSurface, Map<String, JsonElement> currentAttributes, PropertiesCallback callback) {
        super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.title"));
        this.parentScreen = parentScreen;
        this.templateId = null;
        this.metadata = null;
        this.isNewTemplate = true;
        this.callback = Objects.requireNonNull(callback);
        this.initialiseState(currentEnableGeneration, currentGenerationWeight, currentConnectionLayerDepth, currentMinGenerationHeight, currentMaxGenerationHeight, currentGenerateOnSurface, currentAttributes, templateName);
    }

    private void initialiseState(boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> attributes, String displayName) {
        this.generationEnabled = enableGeneration;
        this.generationWeight = generationWeight;
        this.connectionLayerDepth = connectionLayerDepth;
        this.minGenerationHeight = minGenerationHeight;
        this.maxGenerationHeight = maxGenerationHeight;
        this.generateOnSurface = generateOnSurface;
        this.templateNameForDisplay = displayName == null ? "" : displayName;
        this.customAttributes.clear();
        if (attributes != null) {
            attributes.forEach((key, value) -> this.customAttributes.put((String)key, TemplatePropertiesScreen.cloneJson(value)));
        }
        this.ensureDefaultAttributes();
        this.loadBuiltInAttributeFlags();
        this.initialiseBuiltInProperties();
        this.rebuildPropertyModels();
    }

    private void ensureDefaultAttributes() {
        TemplateMetadata.ensureDefaultAttributes(this.customAttributes);
    }

    private void loadBuiltInAttributeFlags() {
        this.requirePregen = this.getBooleanAttributeValue("require_pregen");
        this.generateUnderwater = this.getBooleanAttributeValue("generate_underwater");
        this.generateOnWaterSurface = this.getBooleanAttributeValue("generate_on_water_surface");
        this.templateAuthor = this.getStringAttributeValue("author");
        if ((this.templateAuthor == null || this.templateAuthor.isEmpty()) && this.metadata != null && this.metadata.getAuthor() != null) {
            this.templateAuthor = this.metadata.getAuthor();
            this.customAttributes.put("author", (JsonElement)new JsonPrimitive(this.templateAuthor));
        }
        this.minBurialRate = this.getDoubleAttributeValue("min_burial_rate", 0.0, 0.0, 1.0);
        this.maxBurialRate = this.getDoubleAttributeValue("max_burial_rate", 1.0, 0.0, 1.0);
    }

    private void syncBuiltInAttributeFlags() {
        this.customAttributes.put("require_pregen", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.requirePregen)));
        this.customAttributes.put("generate_underwater", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateUnderwater)));
        this.customAttributes.put("generate_on_water_surface", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateOnWaterSurface)));
        this.customAttributes.put("author", (JsonElement)new JsonPrimitive(this.templateAuthor == null ? "" : this.templateAuthor));
        this.customAttributes.put("min_burial_rate", (JsonElement)new JsonPrimitive((Number)class_3532.method_15350((double)this.minBurialRate, (double)0.0, (double)1.0)));
        this.customAttributes.put("max_burial_rate", (JsonElement)new JsonPrimitive((Number)class_3532.method_15350((double)this.maxBurialRate, (double)0.0, (double)1.0)));
    }

    private boolean getBooleanAttributeValue(String key) {
        JsonElement element = this.customAttributes.get(key);
        return element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean() && element.getAsBoolean();
    }

    private String getStringAttributeValue(String key) {
        JsonPrimitive primitive;
        JsonElement element = this.customAttributes.get(key);
        if (element == null || element.isJsonNull()) {
            return "";
        }
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            return primitive.getAsString();
        }
        return element.toString();
    }

    private double getDoubleAttributeValue(String key, double defaultValue, double min, double max) {
        JsonElement element = this.customAttributes.get(key);
        double value = defaultValue;
        if (element != null && element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                value = primitive.getAsDouble();
            } else if (primitive.isString()) {
                try {
                    value = Double.parseDouble(primitive.getAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return class_3532.method_15350((double)value, (double)min, (double)max);
    }

    private void initialiseBuiltInProperties() {
        this.builtInProperties.clear();
        this.builtInProperties.add(new BuiltInPropertyModel("enable_generation", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.enable_generation"), () -> new JsonPrimitive(Boolean.valueOf(this.generationEnabled)), element -> {
            this.generationEnabled = TemplatePropertiesScreen.expectBoolean(element, "enable_generation");
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("require_pregen", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.require_pregen"), () -> new JsonPrimitive(Boolean.valueOf(this.requirePregen)), element -> {
            this.requirePregen = TemplatePropertiesScreen.expectBoolean(element, "require_pregen");
            this.customAttributes.put("require_pregen", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.requirePregen)));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generation_weight", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.generation_weight"), () -> new JsonPrimitive((Number)this.generationWeight), element -> {
            this.generationWeight = TemplatePropertiesScreen.expectIntInRange(element, "generation_weight", 1, 9999999);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("connection_layer_depth", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.connection_layer_depth"), () -> new JsonPrimitive((Number)this.connectionLayerDepth), element -> {
            this.connectionLayerDepth = TemplatePropertiesScreen.expectIntInRange(element, "connection_layer_depth", 1, 255);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("min_generation_height", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.min_generation_height"), () -> new JsonPrimitive((Number)this.minGenerationHeight), element -> {
            this.minGenerationHeight = TemplatePropertiesScreen.expectIntInRange(element, "min_generation_height", -64, 320);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("max_generation_height", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.max_generation_height"), () -> new JsonPrimitive((Number)this.maxGenerationHeight), element -> {
            this.maxGenerationHeight = TemplatePropertiesScreen.expectIntInRange(element, "max_generation_height", -64, 320);
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generate_on_surface", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.generate_on_surface"), () -> new JsonPrimitive(Boolean.valueOf(this.generateOnSurface)), element -> {
            this.generateOnSurface = TemplatePropertiesScreen.expectBoolean(element, "generate_on_surface");
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generate_underwater", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.generate_underwater"), () -> new JsonPrimitive(Boolean.valueOf(this.generateUnderwater)), element -> {
            this.generateUnderwater = TemplatePropertiesScreen.expectBoolean(element, "generate_underwater");
            this.customAttributes.put("generate_underwater", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateUnderwater)));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("generate_on_water_surface", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.generate_on_water_surface"), () -> new JsonPrimitive(Boolean.valueOf(this.generateOnWaterSurface)), element -> {
            this.generateOnWaterSurface = TemplatePropertiesScreen.expectBoolean(element, "generate_on_water_surface");
            this.customAttributes.put("generate_on_water_surface", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.generateOnWaterSurface)));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("author", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.author"), () -> new JsonPrimitive(this.templateAuthor == null ? "" : this.templateAuthor), element -> {
            this.templateAuthor = TemplatePropertiesScreen.expectString(element, "author");
            this.customAttributes.put("author", (JsonElement)new JsonPrimitive(this.templateAuthor));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("min_burial_rate", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.min_burial_rate"), () -> new JsonPrimitive((Number)this.minBurialRate), element -> {
            this.minBurialRate = TemplatePropertiesScreen.expectDoubleInRange(element, "min_burial_rate", 0.0, 1.0);
            this.customAttributes.put("min_burial_rate", (JsonElement)new JsonPrimitive((Number)this.minBurialRate));
        }));
        this.builtInProperties.add(new BuiltInPropertyModel("max_burial_rate", (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.property.max_burial_rate"), () -> new JsonPrimitive((Number)this.maxBurialRate), element -> {
            this.maxBurialRate = TemplatePropertiesScreen.expectDoubleInRange(element, "max_burial_rate", 0.0, 1.0);
            this.customAttributes.put("max_burial_rate", (JsonElement)new JsonPrimitive((Number)this.maxBurialRate));
        }));
    }

    private void rebuildPropertyModels() {
        this.allProperties.clear();
        this.allProperties.addAll(this.builtInProperties);
        for (String key : new LinkedHashSet<String>(this.customAttributes.keySet())) {
            if (this.isBuiltInKey(key)) continue;
            this.allProperties.add(new CustomPropertyModel(key));
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (!this.isNewTemplate && this.metadata == null) {
            this.method_25419();
            return;
        }
        int availableHeight = Math.max(this.field_22790 - 20, 200);
        this.layoutHeight = Math.min(280, availableHeight);
        this.layoutHeight = Math.min(this.layoutHeight, this.field_22790 - 20);
        if (this.layoutHeight <= 0) {
            this.layoutHeight = Math.max(this.field_22790 - 20, 200);
        }
        this.layoutTop = Math.max(10, (this.field_22790 - this.layoutHeight) / 2);
        int left = this.layoutLeft = (this.field_22789 - 360) / 2;
        int top = this.layoutTop;
        this.searchBox = new class_342(this.field_22793, left + 12, top + 34, 230, 18, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.search_hint"));
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.search_hint"));
        this.searchBox.method_1863(text -> {
            this.searchText = text == null ? "" : text.toLowerCase(Locale.ROOT);
            this.refreshPropertyList();
        });
        this.method_37063((class_364)this.searchBox);
        this.addButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.add_attribute"), btn -> this.openAddAttribute()).method_46433(left + 360 - 110, top + 33).method_46437(98, 20).method_46431();
        this.method_37063((class_364)this.addButton);
        int listHeight = Math.max(80, this.layoutHeight - 98);
        int listTop = top + 60;
        int listBottom = listTop + listHeight;
        this.attributeList = new AttributeListWidget(this.field_22787, 336, listHeight, listTop, listBottom, 29);
        this.attributeList.method_25333(left + 12);
        this.method_37063((class_364)this.attributeList);
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.save"), btn -> this.saveProperties()).method_46433(left + 360 - 160, top + this.layoutHeight - 28).method_46437(70, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), btn -> this.method_25419()).method_46433(left + 360 - 82, top + this.layoutHeight - 28).method_46437(70, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.refreshPropertyList();
    }

    public void method_25393() {
        if (this.searchBox != null) {
            this.searchBox.method_1865();
        }
    }

    private void refreshPropertyList() {
        if (this.attributeList == null) {
            return;
        }
        String filter = this.searchText == null ? "" : this.searchText.trim();
        ArrayList<PropertyEntry> entries = new ArrayList<PropertyEntry>();
        for (BasePropertyModel model : this.allProperties) {
            if (!filter.isEmpty() && !this.matchesFilter(model, filter)) continue;
            entries.add(new PropertyEntry(model));
        }
        this.attributeList.setEntries(entries);
        this.attributeList.method_25313(null);
        this.attributeList.method_25307(0.0);
    }

    private boolean matchesFilter(BasePropertyModel model, String filter) {
        String lower = filter.toLowerCase(Locale.ROOT);
        if (model.key().toLowerCase(Locale.ROOT).contains(lower)) {
            return true;
        }
        return model.displayName().getString().toLowerCase(Locale.ROOT).contains(lower);
    }

    private void openAddAttribute() {
        this.field_22787.method_1507((class_437)new AddAttributeScreen(this));
    }

    private void openEditScreen(BasePropertyModel model) {
        TemplateAttributeDefinition definition = this.definitionFor(model.key());
        if (definition != null && definition.getType() == TemplateAttributeType.TAGS) {
            this.field_22787.method_1507((class_437)new TagEditorScreen(this, model.key()));
            return;
        }
        if (definition != null && "biome_blacklist".equals(definition.getKey())) {
            this.field_22787.method_1507((class_437)new BiomeBlacklistScreen(this));
            return;
        }
        this.field_22787.method_1507((class_437)new AttributeEditScreen(this, model, definition));
    }

    void onCustomAttributesChanged() {
        this.ensureDefaultAttributes();
        this.loadBuiltInAttributeFlags();
        this.rebuildPropertyModels();
        this.refreshPropertyList();
    }

    private void saveProperties() {
        this.errorMessage = null;
        if (this.maxGenerationHeight < this.minGenerationHeight) {
            this.errorMessage = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.error.height_range").method_27692(class_124.field_1061);
            return;
        }
        if (this.minBurialRate > this.maxBurialRate) {
            this.errorMessage = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.error.burial_range").method_27692(class_124.field_1061);
            return;
        }
        this.syncBuiltInAttributeFlags();
        this.ensureDefaultAttributes();
        if (this.isNewTemplate) {
            Map<String, JsonElement> attributesCopy = this.cloneMap(this.customAttributes);
            this.callback.onPropertiesSet(new TemplatePropertiesData(this.generationEnabled, this.generationWeight, this.connectionLayerDepth, this.minGenerationHeight, this.maxGenerationHeight, this.generateOnSurface, attributesCopy));
        } else if (this.metadata != null && this.templateId != null) {
            this.metadata.setGenerationEnabled(this.generationEnabled);
            this.metadata.setGenerationWeight(this.generationWeight);
            this.metadata.setConnectionLayerDepth(this.connectionLayerDepth);
            this.metadata.setMinGenerationHeight(this.minGenerationHeight);
            this.metadata.setMaxGenerationHeight(this.maxGenerationHeight);
            this.metadata.setGenerateOnSurface(this.generateOnSurface);
            this.metadata.setRequiresPregen(this.requirePregen);
            this.metadata.setGenerateUnderwater(this.generateUnderwater);
            this.metadata.setGenerateOnWaterSurface(this.generateOnWaterSurface);
            this.metadata.setCustomAttributes(this.customAttributes);
            this.metadata.ensureCommonAttributes();
            ClientPacketHandler.sendUpdateTemplateProperties(this.templateId, this.generationEnabled, this.generationWeight, this.connectionLayerDepth, this.minGenerationHeight, this.maxGenerationHeight, this.generateOnSurface, this.cloneMap(this.customAttributes));
        }
        this.method_25419();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchBox != null && this.searchBox.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.attributeList != null && this.attributeList.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.attributeList != null && this.attributeList.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.attributeList != null && this.attributeList.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.attributeList != null && this.attributeList.method_25401(mouseX, mouseY, delta)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        int left = this.layoutLeft;
        int top = this.layoutTop;
        int heightBounds = this.layoutHeight;
        graphics.method_25294(left - 4, top - 4, left + 360 + 4, top + heightBounds + 4, -16777216);
        graphics.method_25294(left, top, left + 360, top + heightBounds, -14803426);
        graphics.method_25294(left + 2, top + 2, left + 360 - 2, top + 20, -11908534);
        class_5250 title = this.isNewTemplate ? class_2561.method_43471((String)"gui.hundred_years_war.building_save_more_options.title_short") : class_2561.method_43471((String)"gui.hundred_years_war.template_properties.title_short");
        graphics.method_27534(this.field_22793, (class_2561)title, this.field_22789 / 2, top + 8, 0xFFFFFF);
        if (!this.templateNameForDisplay.isEmpty()) {
            class_5250 nameLabel = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.template_name", (Object[])new Object[]{this.templateNameForDisplay});
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, (class_2561)nameLabel, left + 12, top + 16 + 9, -3092272);
            if (!this.isNewTemplate && this.metadata != null) {
                class_5250 stats = class_2561.method_43470((String)String.format("  (%s / %d)", this.metadata.getSize().method_23854(), this.metadata.getTotalBlocks())).method_27692(class_124.field_1080);
                int n = left + 12 + this.field_22793.method_27525((class_5348)nameLabel) + 4;
                Objects.requireNonNull(this.field_22793);
                graphics.method_27535(this.field_22793, (class_2561)stats, n, top + 16 + 9, -5197648);
            }
        }
        if (this.errorMessage != null) {
            graphics.method_27535(this.field_22793, this.errorMessage, left + 12, top + heightBounds - 56, -43691);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private static JsonElement cloneJson(JsonElement element) {
        if (element == null) {
            return JsonNull.INSTANCE;
        }
        return element.deepCopy();
    }

    private static boolean expectBoolean(JsonElement element, String key) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isBoolean()) {
            throw new IllegalArgumentException(class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.type_boolean", (Object[])new Object[]{key}).getString());
        }
        return element.getAsBoolean();
    }

    private static int expectIntInRange(JsonElement element, String key, int min, int max) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalArgumentException(class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.type_integer", (Object[])new Object[]{key}).getString());
        }
        int value = element.getAsInt();
        if (value < min || value > max) {
            throw new IllegalArgumentException(class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.range", (Object[])new Object[]{key, min, max}).getString());
        }
        return value;
    }

    private static double expectDoubleInRange(JsonElement element, String key, double min, double max) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new IllegalArgumentException(class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.type_number", (Object[])new Object[]{key}).getString());
        }
        double value = element.getAsDouble();
        if (value < min || value > max) {
            throw new IllegalArgumentException(class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.range", (Object[])new Object[]{key, min, max}).getString());
        }
        return value;
    }

    private static String expectString(JsonElement element, String key) {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new IllegalArgumentException(class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.type_string", (Object[])new Object[]{key}).getString());
        }
        return element.getAsString();
    }

    private static JsonElement parseFlexibleJson(String input) {
        if (input == null) {
            return JsonNull.INSTANCE;
        }
        try {
            return JsonParser.parseString((String)input);
        }
        catch (JsonSyntaxException ignored) {
            return new JsonPrimitive(input);
        }
    }

    private Map<String, JsonElement> cloneMap(Map<String, JsonElement> source) {
        LinkedHashMap<String, JsonElement> copy = new LinkedHashMap<String, JsonElement>();
        source.forEach((key, value) -> copy.put((String)key, TemplatePropertiesScreen.cloneJson(value)));
        return copy;
    }

    private boolean isBuiltInKey(String key) {
        return BUILT_IN_KEYS.contains(key);
    }

    private boolean isRequiredCustomKey(String key) {
        return REQUIRED_CUSTOM_KEYS.contains(key);
    }

    private class_5250 resolveCustomLabel(String key) {
        String translationKey = "template_attribute." + key;
        if (class_1074.method_4663((String)translationKey)) {
            return class_2561.method_43471((String)translationKey);
        }
        return class_2561.method_43470((String)key);
    }

    private TemplateAttributeDefinition definitionFor(String key) {
        return TemplateAttributes.getDefinition(key);
    }

    private TemplateAttributeType typeOf(String key) {
        TemplateAttributeDefinition definition = this.definitionFor(key);
        return definition == null ? null : definition.getType();
    }

    private List<String> getCurrentBuildingTags() {
        ArrayList<String> tags = new ArrayList<String>();
        JsonElement element = this.customAttributes.get(BUILDING_TAGS_KEY);
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> {
                String value;
                if (item != null && item.isJsonPrimitive() && item.getAsJsonPrimitive().isString() && !(value = item.getAsString()).isEmpty()) {
                    tags.add(value);
                }
            });
        }
        return tags;
    }

    private List<class_2960> getCurrentBiomeBlacklist() {
        ArrayList<class_2960> biomes = new ArrayList<class_2960>();
        JsonElement element = this.customAttributes.get("biome_blacklist");
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(item -> {
                class_2960 id;
                if (item != null && item.isJsonPrimitive() && item.getAsJsonPrimitive().isString() && (id = class_2960.method_12829((String)item.getAsString())) != null) {
                    biomes.add(id);
                }
            });
        }
        return biomes;
    }

    private boolean isTagBoundAttribute(String key) {
        if (key == null) {
            return false;
        }
        for (String tagId : this.getCurrentBuildingTags()) {
            if (!TemplateTags.getAttributeKeys(tagId).contains(key)) continue;
            return true;
        }
        return false;
    }

    private class_2561 getTypeDisplayName(TemplateAttributeType type) {
        if (type == null) {
            return class_2561.method_43470((String)"-");
        }
        String key = "template_attribute_type." + type.name().toLowerCase(Locale.ROOT);
        if (class_1074.method_4663((String)key)) {
            return class_2561.method_43471((String)key);
        }
        return class_2561.method_43470((String)type.name().toLowerCase(Locale.ROOT));
    }

    @Environment(value=EnvType.CLIENT)
    public static interface PropertiesCallback {
        public void onPropertiesSet(TemplatePropertiesData var1);
    }

    @Environment(value=EnvType.CLIENT)
    private class BuiltInPropertyModel
    extends BasePropertyModel {
        private final String key;
        private final class_2561 label;
        private final Supplier<JsonElement> getter;
        private final Consumer<JsonElement> applier;

        private BuiltInPropertyModel(String key, class_2561 label, Supplier<JsonElement> getter, Consumer<JsonElement> applier) {
            this.key = key;
            this.label = label;
            this.getter = getter;
            this.applier = applier;
        }

        @Override
        String key() {
            return this.key;
        }

        @Override
        class_2561 displayName() {
            return this.label;
        }

        @Override
        JsonElement getValue() {
            return TemplatePropertiesScreen.cloneJson(this.getter.get());
        }

        @Override
        void applyValue(JsonElement value) throws IllegalArgumentException {
            this.applier.accept(value);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class CustomPropertyModel
    extends BasePropertyModel {
        private final String key;

        private CustomPropertyModel(String key) {
            this.key = key;
        }

        @Override
        String key() {
            return this.key;
        }

        @Override
        class_2561 displayName() {
            return TemplatePropertiesScreen.this.resolveCustomLabel(this.key);
        }

        @Override
        JsonElement getValue() {
            return TemplatePropertiesScreen.cloneJson(TemplatePropertiesScreen.this.customAttributes.get(this.key));
        }

        @Override
        void applyValue(JsonElement value) {
            TemplatePropertiesScreen.this.customAttributes.put(this.key, TemplateAttributes.normaliseValue(this.key, value));
        }

        @Override
        boolean isRemovable() {
            return !TemplatePropertiesScreen.this.isRequiredCustomKey(this.key) && !TemplatePropertiesScreen.this.isTagBoundAttribute(this.key);
        }

        @Override
        void remove() {
            if (this.isRemovable()) {
                TemplatePropertiesScreen.this.customAttributes.remove(this.key);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class AttributeListWidget
    extends class_4265<PropertyEntry> {
        AttributeListWidget(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
            this.method_31322(false);
            this.method_31323(false);
        }

        protected int method_25329() {
            return this.field_19088 + this.field_22742 - 6;
        }

        public int method_25322() {
            return this.field_22742 - 8;
        }

        void setEntries(List<PropertyEntry> entries) {
            this.method_25314(entries);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private abstract class BasePropertyModel {
        private BasePropertyModel() {
        }

        abstract String key();

        abstract class_2561 displayName();

        abstract JsonElement getValue();

        abstract void applyValue(JsonElement var1) throws IllegalArgumentException;

        boolean isRemovable() {
            return false;
        }

        void remove() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class PropertyEntry
    extends class_4265.class_4266<PropertyEntry> {
        private final BasePropertyModel model;
        private final List<class_339> widgets = new ArrayList<class_339>();
        private final class_4185 editButton;
        private final class_4185 removeButton;

        private PropertyEntry(BasePropertyModel model) {
            this.model = model;
            this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.edit"), btn -> TemplatePropertiesScreen.this.openEditScreen(model)).method_46437(58, 20).method_46431();
            this.widgets.add((class_339)this.editButton);
            this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.remove"), btn -> {
                model.remove();
                TemplatePropertiesScreen.this.onCustomAttributesChanged();
            }).method_46437(58, 20).method_46431();
            this.widgets.add((class_339)this.removeButton);
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public List<? extends class_6379> method_37025() {
            return this.widgets;
        }

        public void method_25343(@NotNull class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
            boolean removable;
            int valueAreaWidth = width - 136;
            graphics.method_25294(left, top, left + width, top + height, hovered ? -13684945 : -14342875);
            class_2561 label = this.model.displayName();
            graphics.method_27535(TemplatePropertiesScreen.this.field_22793, label, left + 6, top + 1, 0xFFFFFF);
            class_5250 keyComponent = class_2561.method_43470((String)this.model.key()).method_27692(class_124.field_1063);
            graphics.method_27535(TemplatePropertiesScreen.this.field_22793, (class_2561)keyComponent, left + 6, top + 17, -5592406);
            String valueString = GSON.toJson(this.model.getValue());
            String trimmedValue = TemplatePropertiesScreen.this.field_22793.method_27523(valueString, valueAreaWidth);
            graphics.method_25303(TemplatePropertiesScreen.this.field_22793, trimmedValue, left + 6, top + 10, -6369281);
            int buttonY = top + 3;
            this.editButton.method_48229(left + width - 132, buttonY);
            this.editButton.method_25394(graphics, mouseX, mouseY, partialTick);
            this.removeButton.field_22764 = removable = this.model.isRemovable();
            if (removable) {
                this.removeButton.method_48229(left + width - 66, buttonY);
                this.removeButton.method_25394(graphics, mouseX, mouseY, partialTick);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            for (class_339 widget : this.widgets) {
                if (!widget.method_25402(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class AddAttributeScreen
    extends class_437 {
        private final TemplatePropertiesScreen parent;
        private class_342 keyBox;
        private class_342 valueBox;
        private class_2561 localError;

        protected AddAttributeScreen(TemplatePropertiesScreen parent) {
            super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.add_attribute"));
            this.parent = parent;
        }

        protected void method_25426() {
            int dialogWidth = 300;
            int dialogHeight = 160;
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            this.keyBox = new class_342(this.field_22793, left + 16, top + 42, dialogWidth - 32, 18, (class_2561)class_2561.method_43473());
            this.keyBox.method_1880(64);
            this.method_37063((class_364)this.keyBox);
            this.valueBox = new class_342(this.field_22793, left + 16, top + 91, dialogWidth - 32, 18, (class_2561)class_2561.method_43473());
            this.valueBox.method_1880(512);
            this.valueBox.method_1852("\"\"");
            this.method_37063((class_364)this.valueBox);
            class_4185 createButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.create"), btn -> this.attemptCreate()).method_46433(left + dialogWidth - 128, top + dialogHeight - 28).method_46437(56, 20).method_46431();
            this.method_37063((class_364)createButton);
            class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), btn -> this.method_25419()).method_46433(left + dialogWidth - 64, top + dialogHeight - 28).method_46437(48, 20).method_46431();
            this.method_37063((class_364)cancelButton);
        }

        private void attemptCreate() {
            String rawKey = this.keyBox.method_1882();
            if (rawKey == null || rawKey.isBlank()) {
                this.localError = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.error.empty_key").method_27692(class_124.field_1061);
                return;
            }
            String normalisedKey = rawKey.trim().toLowerCase(Locale.ROOT).replace(' ', '_');
            if (!normalisedKey.matches("[a-z0-9_.:\\-]+")) {
                this.localError = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.invalid_key", (Object[])new Object[]{normalisedKey}).method_27692(class_124.field_1061);
                return;
            }
            if (this.parent.isBuiltInKey(normalisedKey)) {
                this.localError = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.duplicate_key", (Object[])new Object[]{normalisedKey}).method_27692(class_124.field_1061);
                return;
            }
            if (this.parent.customAttributes.containsKey(normalisedKey)) {
                this.localError = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.error.duplicate_key", (Object[])new Object[]{normalisedKey}).method_27692(class_124.field_1061);
                return;
            }
            try {
                JsonElement parsed = TemplatePropertiesScreen.parseFlexibleJson(this.valueBox.method_1882());
                this.parent.customAttributes.put(normalisedKey, TemplateAttributes.normaliseValue(normalisedKey, parsed));
                this.parent.onCustomAttributesChanged();
                this.method_25419();
            }
            catch (IllegalArgumentException e) {
                this.localError = class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061);
            }
        }

        public void method_25419() {
            this.field_22787.method_1507((class_437)this.parent);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.keyBox != null && this.keyBox.method_25404(keyCode, scanCode, modifiers) || this.valueBox != null && this.valueBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.attemptCreate();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.keyBox != null && this.keyBox.method_25400(chr, modifiers) || this.valueBox != null && this.valueBox.method_25400(chr, modifiers)) {
                return true;
            }
            return super.method_25400(chr, modifiers);
        }

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(graphics);
            int dialogWidth = 300;
            int dialogHeight = 160;
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            graphics.method_25294(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.method_25294(left, top, left + dialogWidth, top + dialogHeight, -14540254);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.add_attribute"), this.field_22789 / 2, top + 8, 0xFFFFFF);
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.attribute_key"), left + 16, top + 28, -4473925);
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.attribute_value"), left + 16, top + 78, -4473925);
            if (this.localError != null) {
                graphics.method_27535(this.field_22793, this.localError, left + 16, top + dialogHeight - 46, -43691);
            }
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class TagEditorScreen
    extends class_437 {
        private final TemplatePropertiesScreen parent;
        private final String attributeKey;
        private final List<String> initialTags;
        private final List<String> workingTags;
        private String searchText;
        private boolean rawMode;
        private String rawDraft;
        private class_342 inputBox;
        private class_342 rawInputBox;
        private TagSuggestionList suggestionList;
        private ActiveTagList activeTagList;
        private class_2561 feedback;
        private int feedbackColor;
        private class_2561 rawFeedback;
        private int rawFeedbackColor;

        protected TagEditorScreen(TemplatePropertiesScreen parent, String attributeKey) {
            super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.edit_tags"));
            this.workingTags = new ArrayList<String>();
            this.searchText = "";
            this.rawDraft = "";
            this.feedbackColor = -5197648;
            this.rawFeedbackColor = -5197648;
            this.parent = parent;
            this.attributeKey = attributeKey;
            this.initialTags = List.copyOf(parent.getCurrentBuildingTags());
            this.workingTags.addAll(this.initialTags);
        }

        protected void method_25426() {
            int dialogWidth = 360;
            int dialogHeight = this.rawMode ? 210 : 240;
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            this.inputBox = null;
            this.rawInputBox = null;
            this.suggestionList = null;
            this.activeTagList = null;
            class_4185 modeButton = class_4185.method_46430((class_2561)this.getModeButtonLabel(), btn -> this.toggleRawMode()).method_46433(left + dialogWidth - 98, top + 32).method_46437(82, 20).method_46431();
            this.method_37063((class_364)modeButton);
            if (!this.rawMode) {
                this.inputBox = new class_342(this.field_22793, left + 16, top + 34, dialogWidth - 134, 18, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.tag_input_hint"));
                this.inputBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.tag_input_hint"));
                this.inputBox.method_1852(this.searchText);
                this.inputBox.method_1863(text -> {
                    this.searchText = text == null ? "" : text;
                    this.refreshSuggestions();
                    this.refreshActiveList();
                });
                this.method_37063((class_364)this.inputBox);
                this.suggestionList = new TagSuggestionList(this.field_22787, dialogWidth / 2 - 20, 120, top + 70, top + 70 + 120, 28);
                this.suggestionList.method_25333(left + 16);
                this.method_37063((class_364)this.suggestionList);
                this.activeTagList = new ActiveTagList(this.field_22787, dialogWidth / 2 - 20, 120, top + 70, top + 70 + 120, 28);
                this.activeTagList.method_25333(left + dialogWidth / 2 + 4);
                this.method_37063((class_364)this.activeTagList);
            } else {
                if (this.rawDraft.isEmpty()) {
                    this.rawDraft = this.serialiseWorkingTags();
                }
                this.rawInputBox = new class_342(this.field_22793, left + 16, top + 78, dialogWidth - 32, 18, (class_2561)class_2561.method_43473());
                this.rawInputBox.method_1880(4096);
                this.rawInputBox.method_1852(this.rawDraft);
                this.rawInputBox.method_1863(text -> {
                    this.rawDraft = text == null ? "" : text;
                });
                this.method_37063((class_364)this.rawInputBox);
            }
            class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.save"), btn -> this.applyChanges()).method_46433(left + dialogWidth - 120, top + dialogHeight - 28).method_46437(52, 20).method_46431();
            this.method_37063((class_364)saveButton);
            class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), btn -> this.method_25419()).method_46433(left + dialogWidth - 64, top + dialogHeight - 28).method_46437(52, 20).method_46431();
            this.method_37063((class_364)cancelButton);
            this.refreshSuggestions();
            this.refreshActiveList();
        }

        public void method_25393() {
            if (this.rawMode) {
                if (this.rawInputBox != null) {
                    this.rawInputBox.method_1865();
                }
            } else if (this.inputBox != null) {
                this.inputBox.method_1865();
            }
        }

        private void refreshSuggestions() {
            if (this.suggestionList == null) {
                return;
            }
            String filter = this.searchText == null ? "" : this.searchText.trim().toLowerCase(Locale.ROOT);
            ArrayList<TagSuggestionEntry> entries = new ArrayList<TagSuggestionEntry>();
            for (TemplateTagDefinition definition : TemplateTags.all()) {
                if (!this.matches(definition, filter)) continue;
                entries.add(new TagSuggestionEntry(definition));
            }
            entries.sort(Comparator.comparing(entry -> entry.definition.getTranslationKey()));
            this.suggestionList.setEntries(entries);
        }

        private void refreshActiveList() {
            if (this.activeTagList == null) {
                return;
            }
            String filter = this.searchText == null ? "" : this.searchText.trim().toLowerCase(Locale.ROOT);
            ArrayList<ActiveTagEntry> entries = new ArrayList<ActiveTagEntry>();
            for (String tagId : this.orderTags(this.workingTags)) {
                TemplateTagDefinition definition = TemplateTags.get(tagId);
                if (definition == null || !this.matches(definition, filter)) continue;
                entries.add(new ActiveTagEntry(definition));
            }
            this.activeTagList.setEntries(entries);
        }

        private List<String> orderTags(List<String> source) {
            ArrayList<String> ordered = new ArrayList<String>(source);
            ordered.sort(Comparator.comparingInt(this::definitionIndex));
            return ordered;
        }

        private int definitionIndex(String tagId) {
            int index = 0;
            for (TemplateTagDefinition definition : TemplateTags.all()) {
                if (definition.getId().equals(tagId)) {
                    return index;
                }
                ++index;
            }
            return Integer.MAX_VALUE;
        }

        private boolean matches(TemplateTagDefinition definition, String filter) {
            if (filter == null || filter.isEmpty()) {
                return true;
            }
            String id = definition.getId();
            if (id.contains(filter)) {
                return true;
            }
            String translated = class_1074.method_4662((String)definition.getTranslationKey(), (Object[])new Object[0]);
            return translated != null && translated.toLowerCase(Locale.ROOT).contains(filter);
        }

        private void attemptQuickAdd() {
            TagSuggestionEntry first;
            if (this.inputBox == null) {
                return;
            }
            TemplateTagDefinition definition = this.resolveDefinition(this.inputBox.method_1882());
            if (definition == null && this.suggestionList != null && (first = this.suggestionList.firstEntry()) != null) {
                definition = first.definition;
            }
            if (definition != null) {
                this.addTag(definition);
            } else {
                this.feedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.tags.error.unknown");
                this.feedbackColor = -43691;
            }
        }

        private TemplateTagDefinition resolveDefinition(String raw) {
            if (raw == null) {
                return null;
            }
            String normalised = this.normaliseTagId(raw);
            TemplateTagDefinition definition = TemplateTags.get(normalised);
            if (definition != null) {
                return definition;
            }
            String cleaned = raw.trim().toLowerCase(Locale.ROOT);
            for (TemplateTagDefinition candidate : TemplateTags.all()) {
                String translated = class_1074.method_4662((String)candidate.getTranslationKey(), (Object[])new Object[0]).trim().toLowerCase(Locale.ROOT);
                if (!translated.equals(cleaned)) continue;
                return candidate;
            }
            return null;
        }

        private void addTag(TemplateTagDefinition definition) {
            if (definition == null) {
                return;
            }
            String id = definition.getId();
            if (this.workingTags.contains(id)) {
                this.feedback = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.tags.error.duplicate", (Object[])new Object[]{class_1074.method_4662((String)definition.getTranslationKey(), (Object[])new Object[0])});
                this.feedbackColor = -171;
                return;
            }
            this.workingTags.add(id);
            this.refreshActiveList();
            this.refreshSuggestions();
            this.feedback = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.tags.feedback.added", (Object[])new Object[]{class_1074.method_4662((String)definition.getTranslationKey(), (Object[])new Object[0])});
            this.feedbackColor = -11141291;
        }

        private void removeTag(TemplateTagDefinition definition) {
            if (definition == null) {
                return;
            }
            if (this.workingTags.remove(definition.getId())) {
                this.refreshActiveList();
                this.refreshSuggestions();
                this.feedback = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.tags.feedback.removed", (Object[])new Object[]{class_1074.method_4662((String)definition.getTranslationKey(), (Object[])new Object[0])});
                this.feedbackColor = -171;
            }
        }

        private void applyChanges() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            List<String> result = this.orderTags(this.workingTags);
            JsonArray array = new JsonArray();
            result.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            this.parent.customAttributes.put(this.attributeKey, TemplateAttributes.normaliseValue(this.attributeKey, (JsonElement)array));
            LinkedHashSet<String> before = new LinkedHashSet<String>(this.initialTags);
            LinkedHashSet<String> after = new LinkedHashSet<String>(result);
            for (String tagId : after) {
                if (before.contains(tagId)) continue;
                Map<String, JsonElement> values = TemplateTags.createAttributeValues(tagId);
                values.forEach((key, value) -> this.parent.customAttributes.putIfAbsent((String)key, TemplateAttributes.normaliseValue(key, value)));
            }
            for (String tagId : before) {
                TemplateTagDefinition definition;
                if (after.contains(tagId) || (definition = TemplateTags.get(tagId)) == null) continue;
                LinkedHashSet<String> remainingAttributes = new LinkedHashSet<String>();
                for (String remaining : after) {
                    remainingAttributes.addAll(TemplateTags.getAttributeKeys(remaining));
                }
                for (String attributeKey : definition.getAttributeKeys()) {
                    if (remainingAttributes.contains(attributeKey)) continue;
                    this.parent.customAttributes.remove(attributeKey);
                }
            }
            this.parent.onCustomAttributesChanged();
            this.method_25419();
        }

        private String normaliseTagId(String input) {
            if (input == null) {
                return "";
            }
            return input.trim().toLowerCase(Locale.ROOT).replace(' ', '_');
        }

        public void method_25419() {
            this.field_22787.method_1507((class_437)this.parent);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.method_25404(keyCode, scanCode, modifiers)) {
                    return true;
                }
                if (keyCode == 257 || keyCode == 335) {
                    this.commitRawInput();
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.inputBox != null && this.inputBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.attemptQuickAdd();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.method_25400(chr, modifiers)) {
                    return true;
                }
                return super.method_25400(chr, modifiers);
            }
            if (this.inputBox != null && this.inputBox.method_25400(chr, modifiers)) {
                return true;
            }
            return super.method_25400(chr, modifiers);
        }

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(graphics);
            int dialogWidth = 360;
            int dialogHeight = this.rawMode ? 210 : 240;
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            graphics.method_25294(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.method_25294(left, top, left + dialogWidth, top + dialogHeight, -14671840);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.edit_tags"), this.field_22789 / 2, top + 8, 0xFFFFFF);
            if (this.rawMode) {
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_label"), left + 16, top + 60, -4473925);
                if (this.rawFeedback != null) {
                    graphics.method_27535(this.field_22793, this.rawFeedback, left + 16, top + dialogHeight - 46, this.rawFeedbackColor);
                }
            } else {
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.tag_list_available"), left + 16, top + 57, -5592406);
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.tag_list_selected"), left + dialogWidth / 2 + 4, top + 57, -5592406);
                if (this.feedback != null) {
                    graphics.method_27535(this.field_22793, this.feedback, left + 16, top + dialogHeight - 46, this.feedbackColor);
                }
            }
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        private class_2561 getModeButtonLabel() {
            return class_2561.method_43471((String)(this.rawMode ? "gui.hundred_years_war.template_properties.input_mode.list" : "gui.hundred_years_war.template_properties.input_mode.raw"));
        }

        private void toggleRawMode() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            boolean bl = this.rawMode = !this.rawMode;
            if (this.rawMode) {
                this.rawFeedback = null;
                this.rawDraft = this.serialiseWorkingTags();
            }
            if (this.field_22787 != null) {
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }
        }

        private String serialiseWorkingTags() {
            JsonArray array = new JsonArray();
            this.orderTags(this.workingTags).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            return GSON.toJson((JsonElement)array);
        }

        private boolean commitRawInput() {
            JsonElement parsed;
            if (this.rawInputBox == null) {
                return true;
            }
            String value = this.rawInputBox.method_1882();
            if (value == null || value.isBlank()) {
                value = "[]";
            }
            if ((parsed = TemplatePropertiesScreen.parseFlexibleJson(value)) == null || !parsed.isJsonArray()) {
                this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_error_format");
                this.rawFeedbackColor = -43691;
                return false;
            }
            ArrayList<String> updated = new ArrayList<String>();
            for (JsonElement element : parsed.getAsJsonArray()) {
                if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    String normalised = this.normaliseTagId(element.getAsString());
                    if (normalised.isEmpty() || updated.contains(normalised)) continue;
                    updated.add(normalised);
                    continue;
                }
                this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_error_entry");
                this.rawFeedbackColor = -43691;
                return false;
            }
            this.workingTags.clear();
            this.workingTags.addAll(updated);
            this.rawDraft = GSON.toJson(parsed);
            this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_applied");
            this.rawFeedbackColor = -11141291;
            this.refreshActiveList();
            this.refreshSuggestions();
            return true;
        }

        @Environment(value=EnvType.CLIENT)
        private class TagSuggestionList
        extends class_4265<TagSuggestionEntry> {
            TagSuggestionList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
                super(minecraft, width, height, top, bottom, itemHeight);
                this.method_31322(false);
                this.method_31323(false);
            }

            protected int method_25329() {
                return this.field_19088 + this.field_22742 - 6;
            }

            public int method_25322() {
                return this.field_22742 - 8;
            }

            void setEntries(List<TagSuggestionEntry> entries) {
                this.method_25314(entries);
            }

            TagSuggestionEntry firstEntry() {
                List children = this.method_25396();
                return children.isEmpty() ? null : (TagSuggestionEntry)((Object)children.get(0));
            }
        }

        @Environment(value=EnvType.CLIENT)
        private class ActiveTagList
        extends class_4265<ActiveTagEntry> {
            ActiveTagList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
                super(minecraft, width, height, top, bottom, itemHeight);
                this.method_31322(false);
                this.method_31323(false);
            }

            protected int method_25329() {
                return this.field_19088 + this.field_22742 - 6;
            }

            public int method_25322() {
                return this.field_22742 - 8;
            }

            void setEntries(List<ActiveTagEntry> entries) {
                this.method_25314(entries);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private class TagSuggestionEntry
        extends class_4265.class_4266<TagSuggestionEntry> {
            private final TemplateTagDefinition definition;
            private int lastLeft;
            private int lastTop;
            private int lastRight;
            private int lastBottom;

            private TagSuggestionEntry(TemplateTagDefinition definition) {
                this.definition = definition;
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }

            public void method_25343(@NotNull class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.lastLeft = left;
                this.lastTop = top;
                this.lastRight = left + width;
                this.lastBottom = top + height;
                graphics.method_25294(left, top, left + width, top + height, hovered ? -13681617 : -14800866);
                class_5250 displayName = class_2561.method_43471((String)this.definition.getTranslationKey());
                class_5250 idComponent = class_2561.method_43470((String)this.definition.getId()).method_27692(class_124.field_1063);
                int textLeft = left + 6;
                int textRight = left + width - 6;
                class_327 class_3272 = TagEditorScreen.this.field_22793;
                Objects.requireNonNull(TagEditorScreen.this.field_22793);
                ScrollingTextRenderer.render(graphics, class_3272, (class_2561)displayName, textLeft, top + 2, textRight, top + 2 + 9, 0xFFFFFF);
                class_327 class_3273 = TagEditorScreen.this.field_22793;
                Objects.requireNonNull(TagEditorScreen.this.field_22793);
                ScrollingTextRenderer.render(graphics, class_3273, (class_2561)idComponent, textLeft, top + 12, textRight, top + 12 + 9, -5197648);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button == 0 && mouseX >= (double)this.lastLeft && mouseX <= (double)this.lastRight && mouseY >= (double)this.lastTop && mouseY <= (double)this.lastBottom) {
                    TagEditorScreen.this.addTag(this.definition);
                    return true;
                }
                return false;
            }
        }

        @Environment(value=EnvType.CLIENT)
        private class ActiveTagEntry
        extends class_4265.class_4266<ActiveTagEntry> {
            private final TemplateTagDefinition definition;
            private int lastLeft;
            private int lastTop;
            private int lastRight;
            private int lastBottom;

            private ActiveTagEntry(TemplateTagDefinition definition) {
                this.definition = definition;
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }

            public void method_25343(@NotNull class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.lastLeft = left;
                this.lastTop = top;
                this.lastRight = left + width;
                this.lastBottom = top + height;
                graphics.method_25294(left, top, left + width, top + height, hovered ? -12376538 : -13688800);
                class_5250 displayName = class_2561.method_43471((String)this.definition.getTranslationKey());
                class_5250 idComponent = class_2561.method_43470((String)this.definition.getId()).method_27692(class_124.field_1063);
                int textLeft = left + 6;
                int textRight = left + width - 6;
                class_327 class_3272 = TagEditorScreen.this.field_22793;
                Objects.requireNonNull(TagEditorScreen.this.field_22793);
                ScrollingTextRenderer.render(graphics, class_3272, (class_2561)displayName, textLeft, top + 2, textRight, top + 2 + 9, 0xFFFFFF);
                class_327 class_3273 = TagEditorScreen.this.field_22793;
                Objects.requireNonNull(TagEditorScreen.this.field_22793);
                ScrollingTextRenderer.render(graphics, class_3273, (class_2561)idComponent, textLeft, top + 12, textRight, top + 12 + 9, -5197648);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button == 0 && mouseX >= (double)this.lastLeft && mouseX <= (double)this.lastRight && mouseY >= (double)this.lastTop && mouseY <= (double)this.lastBottom) {
                    TagEditorScreen.this.removeTag(this.definition);
                    return true;
                }
                return false;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class BiomeBlacklistScreen
    extends class_437 {
        private final TemplatePropertiesScreen parent;
        private final List<class_2960> initialBiomes;
        private final List<class_2960> workingBiomes;
        private final List<BiomeDescriptor> descriptors;
        private final Map<class_2960, class_2561> nameCache;
        private String filterText;
        private boolean rawMode;
        private String rawDraft;
        private class_342 filterBox;
        private class_342 rawInputBox;
        private SelectedBiomeList selectedList;
        private class_4185 pickerButton;
        private class_2561 feedback;
        private int feedbackColor;
        private class_2561 rawFeedback;
        private int rawFeedbackColor;

        protected BiomeBlacklistScreen(TemplatePropertiesScreen parent) {
            super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_blacklist.title"));
            this.workingBiomes = new ArrayList<class_2960>();
            this.nameCache = new HashMap<class_2960, class_2561>();
            this.filterText = "";
            this.rawDraft = "";
            this.feedbackColor = -5197648;
            this.rawFeedbackColor = -5197648;
            this.parent = parent;
            this.initialBiomes = List.copyOf(parent.getCurrentBiomeBlacklist());
            this.workingBiomes.addAll(this.initialBiomes);
            this.descriptors = this.loadDescriptors();
        }

        protected void method_25426() {
            int dialogWidth = 360;
            int dialogHeight = this.dialogHeight();
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            this.filterBox = null;
            this.rawInputBox = null;
            this.selectedList = null;
            this.pickerButton = null;
            class_4185 modeButton = class_4185.method_46430((class_2561)this.getModeButtonLabel(), btn -> this.toggleRawMode()).method_46433(left + dialogWidth - 98, top + 32).method_46437(82, 20).method_46431();
            this.method_37063((class_364)modeButton);
            if (!this.rawMode) {
                int addButtonSize = 20;
                int modeButtonWidth = 82;
                int searchWidth = dialogWidth - 32 - addButtonSize - modeButtonWidth - 8;
                this.filterBox = new class_342(this.field_22793, left + 16, top + 34, searchWidth, 18, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_blacklist.search_hint"));
                this.filterBox.method_47404((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_blacklist.search_hint"));
                this.filterBox.method_1852(this.filterText);
                this.filterBox.method_1863(text -> {
                    this.filterText = text == null ? "" : text;
                    this.refreshSelectedList();
                });
                this.method_37063((class_364)this.filterBox);
                this.pickerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), btn -> this.openPicker()).method_46433(left + 16 + searchWidth + 4, top + 33).method_46437(addButtonSize, 20).method_46431();
                this.pickerButton.field_22763 = this.hasAvailableBiomes();
                this.method_37063((class_364)this.pickerButton);
                int listHeight = Math.max(120, dialogHeight - 110);
                this.selectedList = new SelectedBiomeList(this.field_22787, dialogWidth - 32, listHeight, top + 70, top + 70 + listHeight, 26);
                this.selectedList.method_25333(left + 16);
                this.method_37063((class_364)this.selectedList);
            } else {
                if (this.rawDraft.isEmpty()) {
                    this.rawDraft = this.serialiseWorkingBiomes();
                }
                this.rawInputBox = new class_342(this.field_22793, left + 16, top + 78, dialogWidth - 32, 18, (class_2561)class_2561.method_43473());
                this.rawInputBox.method_1880(4096);
                this.rawInputBox.method_1852(this.rawDraft);
                this.rawInputBox.method_1863(text -> {
                    this.rawDraft = text == null ? "" : text;
                });
                this.method_37063((class_364)this.rawInputBox);
            }
            class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.save"), btn -> this.applyChanges()).method_46433(left + dialogWidth - 120, top + dialogHeight - 28).method_46437(52, 20).method_46431();
            this.method_37063((class_364)saveButton);
            class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), btn -> this.method_25419()).method_46433(left + dialogWidth - 64, top + dialogHeight - 28).method_46437(52, 20).method_46431();
            this.method_37063((class_364)cancelButton);
            this.refreshSelectedList();
        }

        public void method_25393() {
            if (this.rawMode) {
                if (this.rawInputBox != null) {
                    this.rawInputBox.method_1865();
                }
            } else if (this.filterBox != null) {
                this.filterBox.method_1865();
            }
        }

        private void refreshSelectedList() {
            if (this.selectedList == null) {
                return;
            }
            String filter = this.filterText == null ? "" : this.filterText.trim().toLowerCase(Locale.ROOT);
            ArrayList<SelectedBiomeEntry> entries = new ArrayList<SelectedBiomeEntry>();
            for (class_2960 id : this.workingBiomes) {
                if (!filter.isEmpty() && !this.matches(id, filter)) continue;
                entries.add(new SelectedBiomeEntry(id));
            }
            this.selectedList.setEntries(entries);
            this.updatePickerAvailability();
        }

        private boolean matches(class_2960 id, String filter) {
            if (filter == null || filter.isEmpty()) {
                return true;
            }
            class_2561 name = this.displayNameFor(id);
            return id.toString().toLowerCase(Locale.ROOT).contains(filter) || name.getString().toLowerCase(Locale.ROOT).contains(filter);
        }

        private void addBiome(class_2960 id) {
            if (id == null) {
                return;
            }
            if (this.workingBiomes.contains(id)) {
                this.feedback = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.biome_blacklist.duplicate", (Object[])new Object[]{id.toString()});
                this.feedbackColor = -171;
                return;
            }
            this.workingBiomes.add(id);
            this.refreshSelectedList();
            this.feedback = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.biome_blacklist.added", (Object[])new Object[]{this.displayNameFor(id)});
            this.feedbackColor = -11141291;
        }

        private void removeBiome(class_2960 id) {
            if (id == null) {
                return;
            }
            if (this.workingBiomes.remove(id)) {
                this.refreshSelectedList();
                this.feedback = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.biome_blacklist.removed", (Object[])new Object[]{this.displayNameFor(id)});
                this.feedbackColor = -171;
            }
        }

        private void openPicker() {
            if (this.descriptors.isEmpty() || !this.hasAvailableBiomes()) {
                return;
            }
            this.field_22787.method_1507((class_437)new BiomePickerScreen(this, this.descriptors));
        }

        private void applyChanges() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            JsonArray array = new JsonArray();
            this.workingBiomes.forEach(id -> array.add(id.toString()));
            this.parent.customAttributes.put("biome_blacklist", TemplateAttributes.normaliseValue("biome_blacklist", (JsonElement)array));
            this.parent.onCustomAttributesChanged();
            this.method_25419();
        }

        private class_2561 displayNameFor(class_2960 id) {
            return this.nameCache.computeIfAbsent(id, key -> {
                String translationKey = "biome." + key.method_12836() + "." + key.method_12832();
                if (class_1074.method_4663((String)translationKey)) {
                    return class_2561.method_43471((String)translationKey);
                }
                return class_2561.method_43470((String)key.toString());
            });
        }

        private int dialogHeight() {
            return this.rawMode ? 210 : 250;
        }

        private void updatePickerAvailability() {
            if (this.pickerButton != null) {
                this.pickerButton.field_22763 = this.hasAvailableBiomes();
            }
        }

        private boolean hasAvailableBiomes() {
            for (BiomeDescriptor descriptor : this.descriptors) {
                if (this.workingBiomes.contains(descriptor.id())) continue;
                return true;
            }
            return false;
        }

        private List<BiomeDescriptor> loadDescriptors() {
            ArrayList<BiomeDescriptor> list = new ArrayList<BiomeDescriptor>();
            class_2378<class_1959> registry = this.resolveBiomeRegistry();
            for (class_2960 id : registry.method_10235()) {
                class_2561 name = this.displayNameFor(id);
                list.add(new BiomeDescriptor(id, name, name.getString().toLowerCase(Locale.ROOT), id.toString().toLowerCase(Locale.ROOT)));
            }
            list.sort(Comparator.comparing(descriptor -> descriptor.displayName().getString()));
            return list;
        }

        private class_2378<class_1959> resolveBiomeRegistry() {
            class_634 connection;
            class_310 mc = class_310.method_1551();
            if (mc != null && mc.field_1687 != null) {
                return mc.field_1687.method_30349().method_30530(class_7924.field_41236);
            }
            if (mc != null && (connection = mc.method_1562()) != null) {
                return connection.method_29091().method_30530(class_7924.field_41236);
            }
            return class_5455.method_40302((class_2378)class_7923.field_41167).method_30530(class_7924.field_41236);
        }

        private class_2561 getModeButtonLabel() {
            return class_2561.method_43471((String)(this.rawMode ? "gui.hundred_years_war.template_properties.input_mode.list" : "gui.hundred_years_war.template_properties.input_mode.raw"));
        }

        private void toggleRawMode() {
            if (this.rawMode && !this.commitRawInput()) {
                return;
            }
            boolean bl = this.rawMode = !this.rawMode;
            if (this.rawMode) {
                this.rawFeedback = null;
                this.rawDraft = this.serialiseWorkingBiomes();
            }
            if (this.field_22787 != null) {
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }
        }

        private String serialiseWorkingBiomes() {
            JsonArray array = new JsonArray();
            this.workingBiomes.forEach(id -> array.add(id.toString()));
            return GSON.toJson((JsonElement)array);
        }

        private boolean commitRawInput() {
            JsonElement parsed;
            if (this.rawInputBox == null) {
                return true;
            }
            String value = this.rawInputBox.method_1882();
            if (value == null || value.isBlank()) {
                value = "[]";
            }
            if ((parsed = TemplatePropertiesScreen.parseFlexibleJson(value)) == null || !parsed.isJsonArray()) {
                this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_error_format");
                this.rawFeedbackColor = -43691;
                return false;
            }
            ArrayList<class_2960> updated = new ArrayList<class_2960>();
            for (JsonElement element : parsed.getAsJsonArray()) {
                if (element != null && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    class_2960 id = class_2960.method_12829((String)element.getAsString());
                    if (id != null) {
                        if (updated.contains(id)) continue;
                        updated.add(id);
                        continue;
                    }
                    this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_error_entry");
                    this.rawFeedbackColor = -43691;
                    return false;
                }
                this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_error_entry");
                this.rawFeedbackColor = -43691;
                return false;
            }
            this.workingBiomes.clear();
            this.workingBiomes.addAll(updated);
            this.rawDraft = GSON.toJson(parsed);
            this.rawFeedback = class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_applied");
            this.rawFeedbackColor = -11141291;
            this.refreshSelectedList();
            return true;
        }

        public void method_25419() {
            this.field_22787.method_1507((class_437)this.parent);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.method_25404(keyCode, scanCode, modifiers)) {
                    return true;
                }
                if (keyCode == 257 || keyCode == 335) {
                    this.commitRawInput();
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.filterBox != null && this.filterBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.rawMode) {
                if (this.rawInputBox != null && this.rawInputBox.method_25400(chr, modifiers)) {
                    return true;
                }
                return super.method_25400(chr, modifiers);
            }
            if (this.filterBox != null && this.filterBox.method_25400(chr, modifiers)) {
                return true;
            }
            return super.method_25400(chr, modifiers);
        }

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(graphics);
            int dialogWidth = 360;
            int dialogHeight = this.dialogHeight();
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            graphics.method_25294(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.method_25294(left, top, left + dialogWidth, top + dialogHeight, -14671840);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_blacklist.title"), this.field_22789 / 2, top + 8, 0xFFFFFF);
            if (this.rawMode) {
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.raw_input_label"), left + 16, top + 60, -4473925);
                if (this.rawFeedback != null) {
                    graphics.method_27535(this.field_22793, this.rawFeedback, left + 16, top + dialogHeight - 46, this.rawFeedbackColor);
                }
            } else {
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_blacklist.selected"), left + 16, top + 57, -5592406);
                if (this.feedback != null) {
                    graphics.method_27535(this.field_22793, this.feedback, left + 16, top + dialogHeight - 46, this.feedbackColor);
                }
            }
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        @Environment(value=EnvType.CLIENT)
        private class SelectedBiomeList
        extends class_4265<SelectedBiomeEntry> {
            SelectedBiomeList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
                super(minecraft, width, height, top, bottom, itemHeight);
                this.method_31322(false);
                this.method_31323(false);
            }

            protected int method_25329() {
                return this.field_19088 + this.field_22742 - 6;
            }

            public int method_25322() {
                return this.field_22742 - 8;
            }

            void setEntries(List<SelectedBiomeEntry> entries) {
                this.method_25314(entries);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private class SelectedBiomeEntry
        extends class_4265.class_4266<SelectedBiomeEntry> {
            private final class_2960 id;
            private final class_2561 displayName;
            private final class_4185 removeButton;

            private SelectedBiomeEntry(class_2960 id) {
                this.id = id;
                this.displayName = BiomeBlacklistScreen.this.displayNameFor(id);
                this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), btn -> BiomeBlacklistScreen.this.removeBiome(id)).method_46437(20, 20).method_46431();
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.removeButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.removeButton);
            }

            public void method_25343(@NotNull class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                graphics.method_25294(left, top, left + width, top + height, hovered ? -12961222 : -14013910);
                graphics.method_27535(BiomeBlacklistScreen.this.field_22793, this.displayName, left + 6, top + 6, 0xFFFFFF);
                graphics.method_27535(BiomeBlacklistScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.id.toString()).method_27692(class_124.field_1063), left + 6, top + 16, -5197648);
                this.removeButton.method_48229(left + width - 24, top + 3);
                this.removeButton.method_25394(graphics, mouseX, mouseY, partialTick);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.removeButton.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        }

        @Environment(value=EnvType.CLIENT)
        private class BiomePickerScreen
        extends class_437 {
            private final BiomeBlacklistScreen parent;
            private final List<BiomeDescriptor> descriptors;
            private final List<BiomeDescriptor> working;
            private final Set<class_2960> selectedBiomes;
            private class_342 searchBox;
            private BiomeSelectionList selectionList;
            private class_4185 confirmButton;
            private String searchFilter;

            protected BiomePickerScreen(BiomeBlacklistScreen parent, List<BiomeDescriptor> descriptors) {
                super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_picker.title"));
                this.working = new ArrayList<BiomeDescriptor>();
                this.selectedBiomes = new LinkedHashSet<class_2960>();
                this.searchFilter = "";
                this.parent = parent;
                this.descriptors = descriptors;
            }

            protected void method_25426() {
                int dialogWidth = 360;
                int dialogHeight = 240;
                int left = (this.field_22789 - dialogWidth) / 2;
                int top = (this.field_22790 - dialogHeight) / 2;
                this.searchBox = new class_342(this.field_22793, left + 16, top + 34, dialogWidth - 32, 18, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_picker.search_hint"));
                this.searchBox.method_1852(this.searchFilter);
                this.searchBox.method_1863(text -> {
                    this.searchFilter = text == null ? "" : text;
                    this.refreshEntries();
                });
                this.method_37063((class_364)this.searchBox);
                this.selectionList = new BiomeSelectionList(this.field_22787, dialogWidth - 32, 150, top + 64, top + 64 + 150, 26);
                this.selectionList.method_25333(left + 16);
                this.method_37063((class_364)this.selectionList);
                this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.add"), btn -> this.confirmSelection()).method_46433(left + dialogWidth - 120, top + dialogHeight - 28).method_46437(52, 20).method_46431();
                this.method_37063((class_364)this.confirmButton);
                class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), btn -> this.method_25419()).method_46433(left + dialogWidth - 64, top + dialogHeight - 28).method_46437(52, 20).method_46431();
                this.method_37063((class_364)cancelButton);
                this.refreshEntries();
            }

            private void refreshEntries() {
                if (this.selectionList == null) {
                    return;
                }
                String filter = this.searchFilter == null ? "" : this.searchFilter.trim().toLowerCase(Locale.ROOT);
                this.working.clear();
                for (BiomeDescriptor descriptor : this.descriptors) {
                    if (this.parent.workingBiomes.contains(descriptor.id()) || !descriptor.matches(filter)) continue;
                    this.working.add(descriptor);
                }
                ArrayList<BiomeSelectionEntry> entries = new ArrayList<BiomeSelectionEntry>();
                for (BiomeDescriptor descriptor : this.working) {
                    entries.add(new BiomeSelectionEntry(descriptor));
                }
                this.selectionList.setEntries(entries);
                this.updateConfirmState();
            }

            private void confirmSelection() {
                if (this.selectedBiomes.isEmpty()) {
                    return;
                }
                ArrayList<class_2960> ids = new ArrayList<class_2960>(this.selectedBiomes);
                this.selectedBiomes.clear();
                for (class_2960 id : ids) {
                    this.parent.addBiome(id);
                }
                this.field_22787.method_1507((class_437)this.parent);
            }

            private void toggleSelection(class_2960 id) {
                if (this.selectedBiomes.contains(id)) {
                    this.selectedBiomes.remove(id);
                } else {
                    this.selectedBiomes.add(id);
                }
                this.updateConfirmState();
            }

            private void updateConfirmState() {
                if (this.confirmButton != null) {
                    this.confirmButton.field_22763 = !this.selectedBiomes.isEmpty();
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.selectionList != null && this.selectionList.method_25402(mouseX, mouseY, button)) {
                    this.updateConfirmState();
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
                this.method_25420(graphics);
                int dialogWidth = 360;
                int dialogHeight = 240;
                int left = (this.field_22789 - dialogWidth) / 2;
                int top = (this.field_22790 - dialogHeight) / 2;
                graphics.method_25294(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
                graphics.method_25294(left, top, left + dialogWidth, top + dialogHeight, -14671840);
                graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.biome_picker.title"), this.field_22789 / 2, top + 8, 0xFFFFFF);
                super.method_25394(graphics, mouseX, mouseY, partialTick);
            }

            public void method_25419() {
                this.field_22787.method_1507((class_437)this.parent);
            }

            @Environment(value=EnvType.CLIENT)
            private class BiomeSelectionList
            extends class_4265<BiomeSelectionEntry> {
                BiomeSelectionList(class_310 minecraft, int width, int height, int top, int bottom, int itemHeight) {
                    super(minecraft, width, height, top, bottom, itemHeight);
                    this.method_31322(false);
                    this.method_31323(false);
                }

                protected int method_25329() {
                    return this.field_19088 + this.field_22742 - 6;
                }

                public int method_25322() {
                    return this.field_22742 - 8;
                }

                void setEntries(List<BiomeSelectionEntry> entries) {
                    this.method_25314(entries);
                }
            }

            @Environment(value=EnvType.CLIENT)
            private class BiomeSelectionEntry
            extends class_4265.class_4266<BiomeSelectionEntry> {
                private final BiomeDescriptor descriptor;
                private int lastLeft;
                private int lastTop;
                private int lastRight;
                private int lastBottom;

                private BiomeSelectionEntry(BiomeDescriptor descriptor) {
                    this.descriptor = descriptor;
                }

                public List<? extends class_364> method_25396() {
                    return List.of();
                }

                public List<? extends class_6379> method_37025() {
                    return List.of();
                }

                public void method_25343(@NotNull class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTick) {
                    this.lastLeft = left;
                    this.lastTop = top;
                    this.lastRight = left + width;
                    this.lastBottom = top + height;
                    boolean selected = BiomePickerScreen.this.selectedBiomes.contains(this.descriptor.id());
                    int color = selected ? (hovered ? -11849937 : -13677777) : (hovered ? -12961222 : -14013910);
                    graphics.method_25294(left, top, left + width, top + height, color);
                    graphics.method_27535(BiomePickerScreen.this.field_22793, this.descriptor.displayName(), left + 6, top + 6, 0xFFFFFF);
                    graphics.method_27535(BiomePickerScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.descriptor.id().toString()).method_27692(class_124.field_1063), left + 6, top + 16, -5197648);
                }

                public boolean method_25402(double mouseX, double mouseY, int button) {
                    if (button == 0 && mouseX >= (double)this.lastLeft && mouseX <= (double)this.lastRight && mouseY >= (double)this.lastTop && mouseY <= (double)this.lastBottom) {
                        BiomePickerScreen.this.toggleSelection(this.descriptor.id());
                        return true;
                    }
                    return false;
                }
            }
        }

        @Environment(value=EnvType.CLIENT)
        private record BiomeDescriptor(class_2960 id, class_2561 displayName, String lowerName, String lowerId) {
            boolean matches(String filter) {
                if (filter == null || filter.isEmpty()) {
                    return true;
                }
                return this.lowerName.contains(filter) || this.lowerId.contains(filter);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class AttributeEditScreen
    extends class_437 {
        private final TemplatePropertiesScreen parent;
        private final BasePropertyModel model;
        private final TemplateAttributeDefinition definition;
        private class_342 valueBox;
        private class_2561 localError;

        protected AttributeEditScreen(TemplatePropertiesScreen parent, BasePropertyModel model, TemplateAttributeDefinition definition) {
            super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.edit_attribute"));
            this.parent = parent;
            this.model = model;
            this.definition = definition;
        }

        protected void method_25426() {
            int dialogWidth = 260;
            int dialogHeight = 150;
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            this.valueBox = new class_342(this.field_22793, left + 16, top + 95, dialogWidth - 32, 18, (class_2561)class_2561.method_43473());
            this.valueBox.method_1880(512);
            this.valueBox.method_1852(GSON.toJson(this.model.getValue()));
            this.method_37063((class_364)this.valueBox);
            class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.save"), btn -> this.attemptSave()).method_46433(left + dialogWidth - 116, top + dialogHeight - 28).method_46437(48, 20).method_46431();
            this.method_37063((class_364)saveButton);
            class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.common.cancel"), btn -> this.method_25419()).method_46433(left + dialogWidth - 60, top + dialogHeight - 28).method_46437(48, 20).method_46431();
            this.method_37063((class_364)cancelButton);
        }

        private void attemptSave() {
            try {
                JsonElement parsed = TemplatePropertiesScreen.parseFlexibleJson(this.valueBox.method_1882());
                this.model.applyValue(parsed);
                this.parent.onCustomAttributesChanged();
                this.method_25419();
            }
            catch (IllegalArgumentException e) {
                this.localError = class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061);
            }
        }

        public void method_25419() {
            this.field_22787.method_1507((class_437)this.parent);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.valueBox != null && this.valueBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.attemptSave();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            if (this.valueBox != null && this.valueBox.method_25400(chr, modifiers)) {
                return true;
            }
            return super.method_25400(chr, modifiers);
        }

        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(graphics);
            int dialogWidth = 260;
            int dialogHeight = 140;
            int left = (this.field_22789 - dialogWidth) / 2;
            int top = (this.field_22790 - dialogHeight) / 2;
            graphics.method_25294(left - 4, top - 4, left + dialogWidth + 4, top + dialogHeight + 4, -16777216);
            graphics.method_25294(left, top, left + dialogWidth, top + dialogHeight, -14671840);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.edit_attribute"), this.field_22789 / 2, top + 8, 0xFFFFFF);
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.attribute_key"), left + 16, top + 32, -4473925);
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)this.model.key()), left + 16, top + 44, 0xFFFFFF);
            if (this.definition != null) {
                class_5250 typeLabel = class_2561.method_43469((String)"gui.hundred_years_war.template_properties.attribute_type", (Object[])new Object[]{TemplatePropertiesScreen.this.getTypeDisplayName(this.definition.getType()).method_27661().method_27692(class_124.field_1075)});
                graphics.method_27535(this.field_22793, (class_2561)typeLabel, left + 16, top + 58, -6250336);
            }
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.template_properties.attribute_value"), left + 16, top + 72, -4473925);
            if (this.localError != null) {
                graphics.method_27535(this.field_22793, this.localError, left + 16, top + dialogHeight - 46, -43691);
            }
            super.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record TemplatePropertiesData(boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> customAttributes) {
    }

    @Environment(value=EnvType.CLIENT)
    private static class ScrollingTextRenderer
    extends class_339 {
        private ScrollingTextRenderer() {
            super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
        }

        static void render(class_332 graphics, class_327 font, class_2561 text, int left, int top, int right, int bottom, int color) {
            ScrollingTextRenderer.method_49605((class_332)graphics, (class_327)font, (class_2561)text, (int)left, (int)top, (int)right, (int)bottom, (int)color);
        }

        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        }
    }
}

