/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.handler;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.item.CommandStaffHandler;
import ydmsama.hundred_years_war.client.models.siege.BombardCartModel;
import ydmsama.hundred_years_war.client.models.siege.CannonModel;
import ydmsama.hundred_years_war.client.models.siege.CulverinModel;
import ydmsama.hundred_years_war.client.models.siege.GreatBombardCartModel;
import ydmsama.hundred_years_war.client.models.siege.MangonelsCartModel;
import ydmsama.hundred_years_war.client.models.siege.RibauldequinModel;
import ydmsama.hundred_years_war.client.models.siege.SpringaldModel;
import ydmsama.hundred_years_war.client.models.siege.TrebuchetsCartModel;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.renderer.blockentity.BreedingWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.FarmingWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.FishingWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.LumberWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.MiningWorkstationRenderer;
import ydmsama.hundred_years_war.client.utils.ClientCreativeModeSettings;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;

@Environment(value=EnvType.CLIENT)
public final class ClientTickHandler {
    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(ClientTickHandler::onStartTick);
        ClientTickEvents.END_CLIENT_TICK.register(ClientTickHandler::onEndTick);
    }

    private static void onStartTick(class_310 client) {
        Freecam.preTick(client);
    }

    private static void onEndTick(class_310 client) {
        Freecam.postTick(client);
        CommandStaffHandler.getInstance().clientTick();
        CommandWheelHandler.getInstance().tick();
        ClientTickHandler.handleTransportActionKey(client);
        ClientTickHandler.handleSummonRelationToggleKey(client);
        ClientTickHandler.clearWorkstationRenderers();
        if (client.field_1687 == null && client.field_1724 == null) {
            ClientTickHandler.clearSiegeModelsCache();
        }
    }

    private static void handleTransportActionKey(class_310 mc) {
        if (mc.field_1724 == null) {
            return;
        }
        while (HotKeyManager.getTransportActionKey().method_1436()) {
            class_1799 mainHand = mc.field_1724.method_6047();
            class_1799 offHand = mc.field_1724.method_6079();
            if (mainHand.method_7909() instanceof TransportOrderItem) {
                ClientPacketHandler.sendTransportActionPacket(true);
                continue;
            }
            if (!(offHand.method_7909() instanceof TransportOrderItem)) continue;
            ClientPacketHandler.sendTransportActionPacket(false);
        }
    }

    private static void handleSummonRelationToggleKey(class_310 mc) {
        if (mc.field_1724 == null) {
            return;
        }
        while (HotKeyManager.getSummonRelationToggleKey().method_1436()) {
            if (!mc.field_1724.method_7337() || !ClientCreativeModeSettings.shouldShowSummonIndicator()) continue;
            boolean newValue = !ClientCreativeModeSettings.isSummonFriendly();
            ClientCreativeModeSettings.setSummonFriendly(newValue);
            ClientPacketHandler.sendCreativeSettingsUpdate(newValue, ClientCreativeModeSettings.canControlAllUnits());
            class_5250 feedback = class_2561.method_43471((String)(newValue ? "message.hundred_years_war.creative_summon_relation.friendly" : "message.hundred_years_war.creative_summon_relation.hostile")).method_27692(newValue ? class_124.field_1060 : class_124.field_1061);
            mc.field_1724.method_7353((class_2561)feedback, true);
        }
    }

    private static void clearWorkstationRenderers() {
        LumberWorkstationRenderer.clearRenderedEntities();
        FarmingWorkstationRenderer.clearRenderedEntities();
        MiningWorkstationRenderer.clearRenderedEntities();
        BreedingWorkstationRenderer.clearRenderedEntities();
        FishingWorkstationRenderer.clearRenderedEntities();
    }

    public static void clearSiegeModelsCache() {
        RibauldequinModel.clearUnusedEntities();
        CulverinModel.clearUnusedEntities();
        CannonModel.clearUnusedEntities();
        MangonelsCartModel.clearUnusedEntities();
        TrebuchetsCartModel.clearUnusedEntities();
        BombardCartModel.clearUnusedEntities();
        GreatBombardCartModel.clearUnusedEntities();
        SpringaldModel.clearUnusedEntities();
    }

    private ClientTickHandler() {
    }
}

