/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_6539;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

@Environment(value=EnvType.CLIENT)
public class BuildingPreviewRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingPreviewRenderer.class);
    private static final Map<String, PreviewData> previewCache = new HashMap<String, PreviewData>();
    private static String currentTemplateId = null;
    private static PreviewData currentPreview = null;
    private static boolean isLoading = false;
    private static class_2338 previewPos = class_2338.field_10980;
    private static int rotation = 0;
    private static RenderCache currentRenderCache = null;
    private static int lastRotation = -1;
    private static String lastCacheKey = null;
    private static RenderMode currentRenderMode = RenderMode.CUTOUT;

    public static void setTemplate(String templateId) {
        if (templateId == null) {
            currentTemplateId = null;
            currentPreview = null;
            currentRenderCache = null;
            isLoading = false;
            return;
        }
        if (!templateId.equals(currentTemplateId)) {
            currentRenderCache = null;
            lastCacheKey = null;
        }
        if (templateId.equals(currentTemplateId)) {
            if (currentPreview == null && !isLoading) {
                BuildingPreviewRenderer.loadTemplate(templateId);
            }
            return;
        }
        currentTemplateId = templateId;
        currentPreview = null;
        isLoading = false;
        if (previewCache.containsKey(templateId)) {
            currentPreview = previewCache.get(templateId);
        } else {
            BuildingPreviewRenderer.loadTemplate(templateId);
        }
    }

    private static void loadTemplate(String templateId) {
        if (isLoading) {
            return;
        }
        isLoading = true;
        BuildingPreviewRenderer.requestTemplateFromServer(templateId);
    }

    private static void requestTemplateFromServer(String templateId) {
        ClientPacketHandler.sendTemplateDataRequest(templateId);
    }

    public static void receiveTemplateData(String templateId, class_2338 size, class_2338 entrance, Map<class_2338, class_2680> blocks, float playerYaw) {
        PreviewData data = new PreviewData(blocks, size, entrance, playerYaw);
        previewCache.put(templateId, data);
        if (templateId.equals(currentTemplateId)) {
            currentPreview = data;
            currentRenderCache = null;
            lastCacheKey = null;
        }
        isLoading = false;
    }

    public static void receiveTemplateData(String templateId, class_2338 size, class_2338 entrance, Map<class_2338, class_2680> blocks) {
        BuildingPreviewRenderer.receiveTemplateData(templateId, size, entrance, blocks, 0.0f);
    }

    public static void setPreviewPosition(class_2338 pos) {
        previewPos = pos;
    }

    public static void setRotation(int rot) {
        rotation = rot % 360;
        if (rotation != lastRotation) {
            currentRenderCache = null;
        }
    }

    public static void render(class_4587 poseStack, class_4597 bufferSource, class_243 cameraPos) {
        if (currentPreview == null || previewPos == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_776 blockRenderer = minecraft.method_1541();
        float currentPlayerYaw = minecraft.field_1724 != null ? minecraft.field_1724.method_36454() : 0.0f;
        float savedYaw = BuildingPreviewRenderer.currentPreview.playerYaw;
        float relativeYaw = BuildingPreviewRenderer.normalizeAngle(savedYaw - currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildingPreviewRenderer.normalizeRotation(relativeRotation);
        int totalRotation = BuildingPreviewRenderer.normalizeRotation(rotation + relativeRotation);
        String cacheKey = currentTemplateId + "_" + totalRotation;
        if (currentRenderCache == null || !cacheKey.equals(lastCacheKey)) {
            BuildingPreviewRenderer.buildRenderCache(currentPreview, totalRotation);
            lastCacheKey = cacheKey;
            lastRotation = rotation;
        }
        if (currentRenderCache == null || BuildingPreviewRenderer.currentRenderCache.allBlocks.isEmpty()) {
            return;
        }
        class_2338 entrance = BuildingPreviewRenderer.currentPreview.entrance != null ? BuildingPreviewRenderer.currentPreview.entrance : class_2338.field_10980;
        class_2338 transformedEntrance = BuildingPreviewRenderer.transformPosition(entrance, BuildingPreviewRenderer.currentPreview.size, totalRotation);
        class_2338 offset = previewPos.method_10059((class_2382)transformedEntrance);
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        switch (currentRenderMode) {
            case WIREFRAME: {
                BuildingPreviewRenderer.renderWireframe(poseStack, bufferSource, currentRenderCache, offset);
                break;
            }
            case HYBRID: {
                BuildingPreviewRenderer.renderHybrid(poseStack, bufferSource, blockRenderer, currentRenderCache, offset);
                break;
            }
            default: {
                class_1921 renderType = BuildingPreviewRenderer.currentRenderMode.renderType != null ? BuildingPreviewRenderer.currentRenderMode.renderType : class_1921.method_23581();
                for (Map.Entry<class_2680, List<RenderCache.RenderableBlock>> entry : BuildingPreviewRenderer.currentRenderCache.blocksByType.entrySet()) {
                    class_2680 blockState = entry.getKey();
                    List<RenderCache.RenderableBlock> blocks = entry.getValue();
                    class_1087 model = blockRenderer.method_3349(blockState);
                    class_4588 consumer = bufferSource.getBuffer(renderType);
                    for (RenderCache.RenderableBlock block : blocks) {
                        BuildingPreviewRenderer.renderCachedBlock(poseStack, consumer, model, block, offset);
                    }
                }
            }
        }
        poseStack.method_22909();
        if (BuildingPreviewRenderer.currentRenderCache.minBounds != null && BuildingPreviewRenderer.currentRenderCache.maxBounds != null) {
            BuildingPreviewRenderer.renderBoundingBox(poseStack, bufferSource, offset.method_10081((class_2382)BuildingPreviewRenderer.currentRenderCache.minBounds), offset.method_10081((class_2382)BuildingPreviewRenderer.currentRenderCache.maxBounds), cameraPos);
        }
        BuildingPreviewRenderer.renderEntranceMarker(poseStack, bufferSource, previewPos, cameraPos);
    }

    private static void buildRenderCache(PreviewData preview, int totalRotation) {
        long startTime = System.currentTimeMillis();
        HashMap<class_2338, class_2680> transformedBlocks = new HashMap<class_2338, class_2680>();
        for (Map.Entry<class_2338, class_2680> entry : preview.blocks.entrySet()) {
            class_2338 relativePos = entry.getKey();
            class_2680 state = entry.getValue();
            if (state.method_26215()) continue;
            class_2338 transformedPos = BuildingPreviewRenderer.transformPosition(relativePos, preview.size, totalRotation);
            class_2680 transformedState = BuildingPreviewRenderer.transformBlockState(state, totalRotation);
            transformedBlocks.put(transformedPos, transformedState);
        }
        VirtualBlockGetter virtualWorld = new VirtualBlockGetter(transformedBlocks);
        currentRenderCache = new RenderCache();
        currentRenderCache.build(transformedBlocks, virtualWorld);
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.info("Built render cache in {}ms for {} blocks", (Object)totalTime, (Object)transformedBlocks.size());
    }

    private static void renderCachedBlock(class_4587 poseStack, class_4588 consumer, class_1087 model, RenderCache.RenderableBlock block, class_2338 offset) {
        class_2338 worldPos = offset.method_10081((class_2382)block.worldPos);
        poseStack.method_22903();
        poseStack.method_46416((float)worldPos.method_10263(), (float)worldPos.method_10264(), (float)worldPos.method_10260());
        class_5819 random = class_5819.method_43047();
        random.method_43052(42L);
        for (class_2350 direction : block.visibleFaces) {
            List quads = model.method_4707(block.state, direction, random);
            for (class_777 quad : quads) {
                consumer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 0xF00000, class_4608.field_21444);
            }
        }
        List quads = model.method_4707(block.state, null, random);
        for (class_777 quad : quads) {
            consumer.method_22919(poseStack.method_23760(), quad, 1.0f, 1.0f, 1.0f, 0xF00000, class_4608.field_21444);
        }
        poseStack.method_22909();
    }

    private static void renderBoundingBox(class_4587 poseStack, class_4597 bufferSource, class_2338 minPos, class_2338 maxPos, class_243 cameraPos) {
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minPos.method_10263(), (double)minPos.method_10264(), (double)minPos.method_10260(), (double)(maxPos.method_10263() + 1), (double)(maxPos.method_10264() + 1), (double)(maxPos.method_10260() + 1), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        poseStack.method_22909();
    }

    private static void renderEntranceMarker(class_4587 poseStack, class_4597 bufferSource, class_2338 entrancePos, class_243 cameraPos) {
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_238 box = new class_238(entrancePos).method_1014(0.1);
        class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)0.0f, (float)0.5f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
    }

    private static class_2338 transformPosition(class_2338 pos, class_2338 size, int rotation) {
        class_2338 result = pos;
        class_2338 currentSize = size;
        for (int i = 0; i < rotation / 90; ++i) {
            int newX = result.method_10260();
            int newZ = currentSize.method_10263() - 1 - result.method_10263();
            result = new class_2338(newX, result.method_10264(), newZ);
            int temp = currentSize.method_10263();
            currentSize = new class_2338(currentSize.method_10260(), currentSize.method_10264(), temp);
        }
        return result;
    }

    private static class_2680 transformBlockState(class_2680 state, int rotation) {
        class_2470 rot = switch (rotation) {
            case 90 -> class_2470.field_11465;
            case 180 -> class_2470.field_11464;
            case 270 -> class_2470.field_11463;
            default -> class_2470.field_11467;
        };
        return state.method_26186(rot);
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    private static void renderWireframe(class_4587 poseStack, class_4597 bufferSource, RenderCache cache, class_2338 offset) {
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        for (RenderCache.RenderableBlock block : cache.allBlocks) {
            class_2338 worldPos = offset.method_10081((class_2382)block.worldPos);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)worldPos.method_10263(), (double)worldPos.method_10264(), (double)worldPos.method_10260(), (double)(worldPos.method_10263() + 1), (double)(worldPos.method_10264() + 1), (double)(worldPos.method_10260() + 1), (float)0.5f, (float)0.5f, (float)1.0f, (float)0.8f);
        }
    }

    private static void renderHybrid(class_4587 poseStack, class_4597 bufferSource, class_776 blockRenderer, RenderCache cache, class_2338 offset) {
        for (Map.Entry<class_2680, List<RenderCache.RenderableBlock>> entry : cache.blocksByType.entrySet()) {
            class_2680 blockState = entry.getKey();
            List<RenderCache.RenderableBlock> blocks = entry.getValue();
            class_1087 model = blockRenderer.method_3349(blockState);
            class_4588 consumer = bufferSource.getBuffer(class_1921.method_23581());
            for (RenderCache.RenderableBlock block : blocks) {
                BuildingPreviewRenderer.renderCachedBlock(poseStack, consumer, model, block, offset);
            }
        }
        class_4588 lineConsumer = bufferSource.getBuffer(class_1921.method_23594());
        for (RenderCache.RenderableBlock block : cache.allBlocks) {
            class_2338 worldPos = offset.method_10081((class_2382)block.worldPos);
            if (block.visibleFaces.isEmpty()) continue;
            class_761.method_22980((class_4587)poseStack, (class_4588)lineConsumer, (double)((double)worldPos.method_10263() + 0.002), (double)((double)worldPos.method_10264() + 0.002), (double)((double)worldPos.method_10260() + 0.002), (double)((double)worldPos.method_10263() + 0.998), (double)((double)worldPos.method_10264() + 0.998), (double)((double)worldPos.method_10260() + 0.998), (float)0.2f, (float)0.2f, (float)0.6f, (float)0.3f);
        }
    }

    public static void setRenderMode(RenderMode mode) {
        if (currentRenderMode != mode) {
            currentRenderMode = mode;
            LOGGER.info("Preview render mode changed to: {}", (Object)mode.displayName);
        }
    }

    public static RenderMode getRenderMode() {
        return currentRenderMode;
    }

    public static void cycleRenderMode() {
        RenderMode[] modes = RenderMode.values();
        int currentIndex = currentRenderMode.ordinal();
        int nextIndex = (currentIndex + 1) % modes.length;
        BuildingPreviewRenderer.setRenderMode(modes[nextIndex]);
    }

    public static void clearCache() {
        previewCache.clear();
        currentTemplateId = null;
        currentPreview = null;
        currentRenderCache = null;
        lastCacheKey = null;
    }

    public static boolean isPreviewReady() {
        return currentPreview != null;
    }

    @Environment(value=EnvType.CLIENT)
    private static class PreviewData {
        final Map<class_2338, class_2680> blocks;
        final class_2338 size;
        final class_2338 entrance;
        final float playerYaw;

        PreviewData(Map<class_2338, class_2680> blocks, class_2338 size, class_2338 entrance, float playerYaw) {
            this.blocks = blocks;
            this.size = size;
            this.entrance = entrance;
            this.playerYaw = playerYaw;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class RenderCache {
        final Map<class_2680, List<RenderableBlock>> blocksByType = new HashMap<class_2680, List<RenderableBlock>>();
        final List<RenderableBlock> allBlocks = new ArrayList<RenderableBlock>();
        class_2338 minBounds;
        class_2338 maxBounds;

        private RenderCache() {
        }

        void build(Map<class_2338, class_2680> transformedBlocks, VirtualBlockGetter virtualWorld) {
            long startTime = System.currentTimeMillis();
            this.blocksByType.clear();
            this.allBlocks.clear();
            int totalFaces = 0;
            int culledFaces = 0;
            for (Map.Entry<class_2338, class_2680> entry : transformedBlocks.entrySet()) {
                class_2338 worldPos = entry.getKey();
                class_2680 state = entry.getValue();
                if (state.method_26215()) continue;
                HashSet<class_2350> visibleFaces = new HashSet<class_2350>();
                for (class_2350 direction : class_2350.values()) {
                    ++totalFaces;
                    class_2338 neighborPos = worldPos.method_10093(direction);
                    if (class_2248.method_9607((class_2680)state, (class_1922)virtualWorld, (class_2338)worldPos, (class_2350)direction, (class_2338)neighborPos)) {
                        visibleFaces.add(direction);
                        continue;
                    }
                    ++culledFaces;
                }
                if (!visibleFaces.isEmpty()) {
                    RenderableBlock renderableBlock = new RenderableBlock(worldPos, state, visibleFaces);
                    this.allBlocks.add(renderableBlock);
                    this.blocksByType.computeIfAbsent(state, k -> new ArrayList()).add(renderableBlock);
                }
                if (this.minBounds == null) {
                    this.minBounds = worldPos;
                    this.maxBounds = worldPos;
                    continue;
                }
                this.minBounds = new class_2338(Math.min(this.minBounds.method_10263(), worldPos.method_10263()), Math.min(this.minBounds.method_10264(), worldPos.method_10264()), Math.min(this.minBounds.method_10260(), worldPos.method_10260()));
                this.maxBounds = new class_2338(Math.max(this.maxBounds.method_10263(), worldPos.method_10263()), Math.max(this.maxBounds.method_10264(), worldPos.method_10264()), Math.max(this.maxBounds.method_10260(), worldPos.method_10260()));
            }
            long buildTime = System.currentTimeMillis() - startTime;
            float cullPercent = totalFaces > 0 ? (float)culledFaces * 100.0f / (float)totalFaces : 0.0f;
            LOGGER.info("Render cache built in {}ms: {} blocks, {} visible faces, {} culled ({:.1f}% reduction)", new Object[]{buildTime, this.allBlocks.size(), totalFaces - culledFaces, culledFaces, Float.valueOf(cullPercent)});
        }

        @Environment(value=EnvType.CLIENT)
        static class RenderableBlock {
            final class_2338 worldPos;
            final class_2680 state;
            final Set<class_2350> visibleFaces;

            RenderableBlock(class_2338 worldPos, class_2680 state, Set<class_2350> faces) {
                this.worldPos = worldPos;
                this.state = state;
                this.visibleFaces = faces;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum RenderMode {
        TRANSLUCENT("\u534a\u900f\u660e", class_1921.method_23583()),
        CUTOUT("\u526a\u5207", class_1921.method_23581()),
        WIREFRAME("\u7ebf\u6846", class_1921.method_23594()),
        HYBRID("\u6df7\u5408", null);

        final String displayName;
        final class_1921 renderType;

        private RenderMode(String displayName, class_1921 renderType) {
            this.displayName = displayName;
            this.renderType = renderType;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class VirtualBlockGetter
    implements class_1920 {
        private final Map<class_2338, class_2680> blocks;

        VirtualBlockGetter(Map<class_2338, class_2680> blocks) {
            this.blocks = blocks;
        }

        public class_2680 method_8320(class_2338 pos) {
            class_2680 state = this.blocks.get(pos);
            return state != null ? state : class_2246.field_10124.method_9564();
        }

        public class_3610 method_8316(class_2338 pos) {
            return class_3612.field_15906.method_15785();
        }

        @Nullable
        public class_2586 method_8321(class_2338 pos) {
            return null;
        }

        public int method_23752(class_2338 blockPos, class_6539 colorResolver) {
            return -1;
        }

        public int method_8317(class_2338 pos) {
            return 15;
        }

        public int method_31605() {
            return 384;
        }

        public int method_31607() {
            return -64;
        }

        public float method_24852(class_2350 direction, boolean bl) {
            return 1.0f;
        }

        public class_3568 method_22336() {
            return null;
        }

        public int method_8314(class_1944 lightLayer, class_2338 blockPos) {
            return 15;
        }

        public int method_22335(class_2338 blockPos, int i) {
            return 15;
        }

        public boolean method_8311(class_2338 blockPos) {
            return true;
        }
    }
}

