/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_761;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.network.packets.PlacedBuildingSyncPacket;

@Environment(value=EnvType.CLIENT)
public class PlacedBuildingRenderer {
    private static final PlacedBuildingRenderer INSTANCE = new PlacedBuildingRenderer();
    private final Map<UUID, PlacedBuildingSyncPacket.BuildingData> buildings = new ConcurrentHashMap<UUID, PlacedBuildingSyncPacket.BuildingData>();
    private final Map<class_1923, Set<UUID>> chunkToBuildingsMap = new ConcurrentHashMap<class_1923, Set<UUID>>();
    private boolean lastRenderState = false;
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 500L;

    private PlacedBuildingRenderer() {
    }

    public static PlacedBuildingRenderer getInstance() {
        return INSTANCE;
    }

    public void addBuilding(PlacedBuildingSyncPacket.BuildingData building) {
        PlacedBuildingSyncPacket.BuildingData oldBuilding = this.buildings.get(building.buildingId);
        if (oldBuilding != null) {
            this.removeFromChunkMappings(oldBuilding);
        }
        this.buildings.put(building.buildingId, building);
        this.updateChunkMappings(building);
    }

    public void removeBuilding(UUID buildingId) {
        PlacedBuildingSyncPacket.BuildingData building = this.buildings.remove(buildingId);
        if (building != null) {
            this.removeFromChunkMappings(building);
        }
    }

    public void clear() {
        this.buildings.clear();
        this.chunkToBuildingsMap.clear();
        this.lastRenderState = false;
        this.lastUpdateTime = 0L;
    }

    public void forceRefresh() {
        this.lastUpdateTime = 0L;
    }

    private void updateChunkMappings(PlacedBuildingSyncPacket.BuildingData building) {
        int minChunkX = building.minPos.method_10263() >> 4;
        int maxChunkX = building.maxPos.method_10263() >> 4;
        int minChunkZ = building.minPos.method_10260() >> 4;
        int maxChunkZ = building.maxPos.method_10260() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                this.chunkToBuildingsMap.computeIfAbsent(chunkPos, k -> ConcurrentHashMap.newKeySet()).add(building.buildingId);
            }
        }
    }

    private void removeFromChunkMappings(PlacedBuildingSyncPacket.BuildingData building) {
        int minChunkX = building.minPos.method_10263() >> 4;
        int maxChunkX = building.maxPos.method_10263() >> 4;
        int minChunkZ = building.minPos.method_10260() >> 4;
        int maxChunkZ = building.maxPos.method_10260() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                Set<UUID> chunkBuildings = this.chunkToBuildingsMap.get(chunkPos);
                if (chunkBuildings == null) continue;
                chunkBuildings.remove(building.buildingId);
                if (!chunkBuildings.isEmpty()) continue;
                this.chunkToBuildingsMap.remove(chunkPos);
            }
        }
    }

    public void renderBuildings(class_4587 poseStack, class_4597 bufferSource, class_243 cameraPos) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null || minecraft.field_1687 == null) {
            return;
        }
        boolean shouldRender = false;
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        if (mainHand.method_7909() instanceof BuildingToolItem || offHand.method_7909() instanceof BuildingToolItem) {
            shouldRender = true;
        }
        if (Freecam.isEnabled()) {
            shouldRender = true;
        }
        if (!shouldRender) {
            this.lastRenderState = false;
            return;
        }
        this.lastRenderState = true;
        int maxBuildingRenderDistance = 256;
        double maxDistanceSqr = maxBuildingRenderDistance * maxBuildingRenderDistance;
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        for (Map.Entry<UUID, PlacedBuildingSyncPacket.BuildingData> entry : this.buildings.entrySet()) {
            double centerZ;
            double centerY;
            PlacedBuildingSyncPacket.BuildingData building = entry.getValue();
            double centerX = (double)(building.minPos.method_10263() + building.maxPos.method_10263()) * 0.5;
            double distanceSqr = (centerX - cameraPos.field_1352) * (centerX - cameraPos.field_1352) + ((centerY = (double)(building.minPos.method_10264() + building.maxPos.method_10264()) * 0.5) - cameraPos.field_1351) * (centerY - cameraPos.field_1351) + ((centerZ = (double)(building.minPos.method_10260() + building.maxPos.method_10260()) * 0.5) - cameraPos.field_1350) * (centerZ - cameraPos.field_1350);
            if (distanceSqr > maxDistanceSqr) continue;
            int centerChunkX = (int)centerX >> 4;
            int centerChunkZ = (int)centerZ >> 4;
            if (!minecraft.field_1687.method_2935().method_12123(centerChunkX, centerChunkZ)) continue;
            this.renderBuildingOutline(poseStack, vertexConsumer, building, cameraPos);
        }
    }

    private void renderBuildingOutline(class_4587 poseStack, class_4588 vertexConsumer, PlacedBuildingSyncPacket.BuildingData building, class_243 cameraPos) {
        float red = 0.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float alpha = 0.8f;
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_238 aabb = new class_238((double)building.minPos.method_10263(), (double)building.minPos.method_10264(), (double)building.minPos.method_10260(), (double)(building.maxPos.method_10263() + 1), (double)(building.maxPos.method_10264() + 1), (double)(building.maxPos.method_10260() + 1)).method_1014(0.002);
        class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)aabb.field_1323, (double)aabb.field_1322, (double)aabb.field_1321, (double)aabb.field_1320, (double)aabb.field_1325, (double)aabb.field_1324, (float)red, (float)green, (float)blue, (float)alpha);
        poseStack.method_22909();
    }

    public PlacedBuildingSyncPacket.BuildingData getBuildingAt(class_2338 pos) {
        for (PlacedBuildingSyncPacket.BuildingData building : this.buildings.values()) {
            if (pos.method_10263() < building.minPos.method_10263() || pos.method_10263() > building.maxPos.method_10263() || pos.method_10264() < building.minPos.method_10264() || pos.method_10264() > building.maxPos.method_10264() || pos.method_10260() < building.minPos.method_10260() || pos.method_10260() > building.maxPos.method_10260()) continue;
            return building;
        }
        return null;
    }

    public List<PlacedBuildingSyncPacket.BuildingData> getBuildingsInArea(class_2338 center, int radius) {
        ArrayList<PlacedBuildingSyncPacket.BuildingData> result = new ArrayList<PlacedBuildingSyncPacket.BuildingData>();
        class_2338 minPos = center.method_10069(-radius, -radius, -radius);
        class_2338 maxPos = center.method_10069(radius, radius, radius);
        for (PlacedBuildingSyncPacket.BuildingData building : this.buildings.values()) {
            class_238 searchBox;
            class_238 buildingBox = new class_238(building.minPos, building.maxPos.method_10069(1, 1, 1));
            if (!buildingBox.method_994(searchBox = new class_238(minPos, maxPos.method_10069(1, 1, 1)))) continue;
            result.add(building);
        }
        return result;
    }
}

