/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.joml.Matrix3f;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;

@Environment(value=EnvType.CLIENT)
public class FreecamTargetRenderer {
    public static void register() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            boolean shouldRender;
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 == null) {
                return;
            }
            boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
            if (!shouldRender) {
                return;
            }
            class_4587 poseStack = context.matrixStack();
            class_4184 camera = context.camera();
            FreecamTargetRenderer.renderEntityTargets(poseStack, camera, mc);
        });
    }

    private static void renderEntityTargets(class_4587 poseStack, class_4184 camera, class_310 mc) {
        class_638 level = mc.field_1687;
        if (level == null) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Object entity : level.method_18112()) {
            CopyOnWriteArraySet<TargetInfo> copyOnWriteArraySet;
            if (!(entity instanceof BaseCombatEntity) || (copyOnWriteArraySet = SelectionHandler.getInstance().getCombinedTargetMap().get(entity)) == null) continue;
            for (TargetInfo target : copyOnWriteArraySet) {
                String type = target.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                class_2338 targetPos = target.getPosition();
                String formationKey = (String)type + "_" + targetPos.method_23854();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        HashSet<class_2338> renderedPositions = new HashSet<class_2338>();
        for (Map.Entry entry : formationMap.entrySet()) {
            List formationEntities = (List)entry.getValue();
            class_243 formationCenter = FreecamTargetRenderer.calculateCenterPosition(formationEntities);
            for (class_1297 entity : formationEntities) {
                CopyOnWriteArraySet<TargetInfo> targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity);
                if (targets == null) continue;
                FreecamTargetRenderer.renderTargetPositions(poseStack, entity, targets, formationCenter, renderedPositions, formationEntities);
            }
        }
        for (class_1297 class_12972 : level.method_18112()) {
            class_2338 unloadTarget;
            class_2338 bombardTarget;
            SelectionHandler selectionHandler;
            CopyOnWriteArraySet<TargetInfo> targets;
            if (!(class_12972 instanceof BaseCombatEntity)) continue;
            boolean inFormation = formationMap.values().stream().anyMatch(list -> list.contains(entity));
            if (!inFormation && (targets = SelectionHandler.getInstance().getCombinedTargetMap().get(class_12972)) != null) {
                List<class_1297> singleEntityList = Collections.singletonList(class_12972);
                FreecamTargetRenderer.renderTargetPositions(poseStack, class_12972, targets, class_12972.method_19538(), renderedPositions, singleEntityList);
            }
            if ((selectionHandler = SelectionHandler.getInstance()).getPatrolPointsMap().containsKey(class_12972)) {
                FreecamTargetRenderer.renderPatrolPositions(poseStack, class_12972, selectionHandler.getPatrolPointsMap().get(class_12972));
            }
            if (class_12972 instanceof PositionAttackable && selectionHandler.getSelectedEntities().contains(class_12972) && (bombardTarget = selectionHandler.getBombardTarget(class_12972)) != null) {
                FreecamTargetRenderer.renderBombardTarget(poseStack, class_12972, bombardTarget);
            }
            if (!(class_12972 instanceof UnloadPassengerable) || !selectionHandler.getSelectedEntities().contains(class_12972) || (unloadTarget = selectionHandler.getUnloadTarget(class_12972)) == null) continue;
            FreecamTargetRenderer.renderUnloadTarget(poseStack, class_12972, unloadTarget);
        }
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        bufferSource.method_22994(class_1921.method_23594());
    }

    private static void renderTargetPositions(class_4587 poseStack, class_1297 entity, CopyOnWriteArraySet<TargetInfo> targets, class_243 formationCenter, Set<class_2338> renderedPositions, List<class_1297> formationEntities) {
        boolean shouldRender;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        AtomicReference<class_243> entityPreviousPos = new AtomicReference<class_243>(entity.method_19538().method_1020(cameraPos));
        AtomicReference<class_243> previousPos = new AtomicReference<class_243>(new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321()).method_1020(cameraPos));
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<class_1297> selectedEntities = selectionHandler.getSelectedEntities();
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!selectedEntities.contains(entity) || !shouldRender) {
            return;
        }
        for (TargetInfo target : targets) {
            float b;
            float g;
            float r;
            class_2338 pos = target.getPosition();
            String type = target.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                float b2;
                float g2;
                float r2;
                class_243 targetPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.1, (double)pos.method_10260() + 0.5);
                class_243 centerPos = targetPos.method_1020(cameraPos);
                double outerMinX = centerPos.method_10216() - 0.5;
                double outerMinZ = centerPos.method_10215() - 0.5;
                double outerMaxX = centerPos.method_10216() + 0.5;
                double outerMaxZ = centerPos.method_10215() + 0.5;
                double innerMinX = centerPos.method_10216() - 0.3;
                double innerMinZ = centerPos.method_10215() - 0.3;
                double innerMaxX = centerPos.method_10216() + 0.3;
                double innerMaxZ = centerPos.method_10215() + 0.3;
                class_238 outerBox = new class_238(outerMinX, centerPos.method_10214(), outerMinZ, outerMaxX, centerPos.method_10214(), outerMaxZ);
                class_238 innerBox = new class_238(innerMinX, centerPos.method_10214(), innerMinZ, innerMaxX, centerPos.method_10214(), innerMaxZ);
                if (Objects.equals(type, "target") || Objects.equals(type, "formTarget")) {
                    r2 = 0.0f;
                    g2 = 1.0f;
                    b2 = 0.0f;
                } else {
                    r2 = 1.0f;
                    g2 = 0.0f;
                    b2 = 0.0f;
                }
                if (!renderedPositions.contains(pos)) {
                    class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)outerBox.field_1323, (double)outerBox.field_1322, (double)outerBox.field_1321, (double)outerBox.field_1320, (double)outerBox.field_1325, (double)outerBox.field_1324, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)innerBox.field_1323, (double)innerBox.field_1322, (double)innerBox.field_1321, (double)innerBox.field_1320, (double)innerBox.field_1325, (double)innerBox.field_1324, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    renderedPositions.add(pos);
                }
                if (previousPos != null && previousPos.get() != null) {
                    Matrix3f normalMatrix = poseStack.method_23760().method_23762();
                    vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)previousPos.get().method_10216(), (float)previousPos.get().method_10214(), (float)previousPos.get().method_10215()).method_22915(r2, g2, b2, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                    vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)centerPos.method_10216(), (float)centerPos.method_10214(), (float)centerPos.method_10215()).method_22915(r2, g2, b2, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                }
                previousPos.set(centerPos);
                entityPreviousPos.set(centerPos);
                continue;
            }
            class_1297 targetEntity = target.getHywTarget();
            if (!targetEntity.method_5805()) continue;
            class_243 entityPos = targetEntity.method_19538().method_1020(cameraPos);
            if (Objects.equals(type, "entityTarget")) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else if (Objects.equals(type, "followTarget")) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            }
            if (entityPreviousPos.get() != null) {
                Matrix3f normalMatrix = poseStack.method_23760().method_23762();
                vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)entityPreviousPos.get().method_10216(), (float)entityPreviousPos.get().method_10214(), (float)entityPreviousPos.get().method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)entityPos.method_10216(), (float)entityPos.method_10214(), (float)entityPos.method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            }
            entityPreviousPos.set(entityPos);
            previousPos.set(new class_243(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321()).method_1020(cameraPos));
        }
    }

    private static void renderPatrolPositions(class_4587 poseStack, class_1297 entity, CopyOnWriteArrayList<class_2338> patrolPoints) {
        boolean shouldRender;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<class_1297> selectedEntities = selectionHandler.getSelectedEntities();
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!selectedEntities.contains(entity) || !shouldRender) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        class_243 previousPos = null;
        for (class_2338 patrolPoint : patrolPoints) {
            class_243 targetPos = new class_243((double)patrolPoint.method_10263() + 0.5, (double)patrolPoint.method_10264() + 1.1, (double)patrolPoint.method_10260() + 0.5);
            class_243 centerPos = targetPos.method_1020(cameraPos);
            double outerMinX = centerPos.method_10216() - 0.5;
            double outerMinZ = centerPos.method_10215() - 0.5;
            double outerMaxX = centerPos.method_10216() + 0.5;
            double outerMaxZ = centerPos.method_10215() + 0.5;
            double innerMinX = centerPos.method_10216() - 0.3;
            double innerMinZ = centerPos.method_10215() - 0.3;
            double innerMaxX = centerPos.method_10216() + 0.3;
            double innerMaxZ = centerPos.method_10215() + 0.3;
            class_238 outerBox = new class_238(outerMinX, centerPos.method_10214(), outerMinZ, outerMaxX, centerPos.method_10214(), outerMaxZ);
            class_238 innerBox = new class_238(innerMinX, centerPos.method_10214(), innerMinZ, innerMaxX, centerPos.method_10214(), innerMaxZ);
            float r = 0.0f;
            float g = 0.0f;
            float b = 1.0f;
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)outerBox.field_1323, (double)outerBox.field_1322, (double)outerBox.field_1321, (double)outerBox.field_1320, (double)outerBox.field_1325, (double)outerBox.field_1324, (float)r, (float)g, (float)b, (float)1.0f);
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)innerBox.field_1323, (double)innerBox.field_1322, (double)innerBox.field_1321, (double)innerBox.field_1320, (double)innerBox.field_1325, (double)innerBox.field_1324, (float)r, (float)g, (float)b, (float)1.0f);
            if (previousPos != null) {
                Matrix3f normalMatrix = poseStack.method_23760().method_23762();
                vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)previousPos.method_10216(), (float)previousPos.method_10214(), (float)previousPos.method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
                vertexConsumer.method_22918(poseStack.method_23760().method_23761(), (float)centerPos.method_10216(), (float)centerPos.method_10214(), (float)centerPos.method_10215()).method_22915(r, g, b, 1.0f).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
            }
            previousPos = centerPos;
        }
    }

    private static void renderUnloadTarget(class_4587 poseStack, class_1297 entity, class_2338 unloadTarget) {
        boolean shouldRender;
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!SelectionHandler.getInstance().getSelectedEntities().contains(entity) || !shouldRender) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        class_243 centerPos = new class_243((double)unloadTarget.method_10263() + 0.5, (double)unloadTarget.method_10264() + 0.5, (double)unloadTarget.method_10260() + 0.5).method_1020(cameraPos);
        float innerSize = 0.5f;
        float outerSizeXZ = 1.5f;
        float outerSizeY = 0.5f;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float alpha = 1.0f;
        class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)innerSize), (double)(centerPos.field_1351 - (double)innerSize), (double)(centerPos.field_1350 - (double)innerSize), (double)(centerPos.field_1352 + (double)innerSize), (double)(centerPos.field_1351 + (double)innerSize), (double)(centerPos.field_1350 + (double)innerSize), (float)red, (float)green, (float)blue, (float)alpha);
        class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)outerSizeXZ), (double)(centerPos.field_1351 - (double)outerSizeY), (double)(centerPos.field_1350 - (double)outerSizeXZ), (double)(centerPos.field_1352 + (double)outerSizeXZ), (double)(centerPos.field_1351 + (double)outerSizeY), (double)(centerPos.field_1350 + (double)outerSizeXZ), (float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void renderBombardTarget(class_4587 poseStack, class_1297 entity, class_2338 bombardTarget) {
        boolean shouldRender;
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!SelectionHandler.getInstance().getSelectedEntities().contains(entity) || !shouldRender) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4588 vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23594());
        class_243 centerPos = new class_243((double)bombardTarget.method_10263() + 0.5, (double)bombardTarget.method_10264() + 0.5, (double)bombardTarget.method_10260() + 0.5).method_1020(cameraPos);
        float smallSize = 0.5f;
        float largeSize = 1.5f;
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float alpha = 1.0f;
        class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)smallSize), (double)(centerPos.field_1351 - (double)smallSize), (double)(centerPos.field_1350 - (double)smallSize), (double)(centerPos.field_1352 + (double)smallSize), (double)(centerPos.field_1351 + (double)smallSize), (double)(centerPos.field_1350 + (double)smallSize), (float)red, (float)green, (float)blue, (float)alpha);
        class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)(centerPos.field_1352 - (double)largeSize), (double)(centerPos.field_1351 - (double)largeSize), (double)(centerPos.field_1350 - (double)largeSize), (double)(centerPos.field_1352 + (double)largeSize), (double)(centerPos.field_1351 + (double)largeSize), (double)(centerPos.field_1350 + (double)largeSize), (float)red, (float)green, (float)blue, (float)alpha);
    }

    private static class_243 calculateCenterPosition(List<class_1297> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return class_243.field_1353;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (class_1297 entity : selectedEntities) {
            class_243 entityPos = entity.method_19538();
            sumX += entityPos.field_1352;
            sumY += entityPos.field_1351;
            sumZ += entityPos.field_1350;
        }
        double centerX = sumX / (double)selectedEntities.size();
        double centerY = sumY / (double)selectedEntities.size();
        double centerZ = sumZ / (double)selectedEntities.size();
        return new class_243(centerX, centerY, centerZ);
    }
}

