/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.blockentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

@Environment(value=EnvType.CLIENT)
public class SpawnPointRenderer
implements class_827<SpawnPointBlockEntity> {
    public SpawnPointRenderer(class_5614.class_5615 context) {
    }

    public void render(SpawnPointBlockEntity entity, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        if (!this.shouldDisplay(entity)) {
            return;
        }
        this.renderNameplate(entity, poseStack, bufferSource, combinedLight);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float alpha = 1.0f;
        double flatHeight = 0.09375;
        class_238 flatOuter = new class_238(0.4, 0.0, 0.4, 0.6, flatHeight, 0.6);
        class_761.method_22981((class_4587)poseStack, (class_4588)bufferSource.getBuffer(class_1921.method_23594()), (double)flatOuter.field_1323, (double)flatOuter.field_1322, (double)flatOuter.field_1321, (double)flatOuter.field_1320, (double)flatOuter.field_1325, (double)flatOuter.field_1324, (float)red, (float)green, (float)blue, (float)alpha, (float)red, (float)green, (float)blue);
        class_238 flatInner = new class_238(0.2, 0.0, 0.2, 0.8, flatHeight, 0.8);
        class_761.method_22981((class_4587)poseStack, (class_4588)bufferSource.getBuffer(class_1921.method_23594()), (double)flatInner.field_1323, (double)flatInner.field_1322, (double)flatInner.field_1321, (double)flatInner.field_1320, (double)flatInner.field_1325, (double)flatInner.field_1324, (float)red, (float)green, (float)blue, (float)alpha, (float)red, (float)green, (float)blue);
        if (entity.isShowActivationRange()) {
            this.renderActivationRange(entity, poseStack, bufferSource);
        }
    }

    private boolean shouldDisplay(SpawnPointBlockEntity entity) {
        if (entity.isShowActivationRange()) {
            return true;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        return this.isHighlightStack(player.method_6047()) || this.isHighlightStack(player.method_6079());
    }

    private boolean isHighlightStack(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        return itemId.equals("hundred_years_war:spawn_point") || stack.method_7909() instanceof BuildingToolItem;
    }

    private void renderNameplate(SpawnPointBlockEntity entity, class_4587 poseStack, class_4597 bufferSource, int light) {
        if (entity == null) {
            return;
        }
        class_2561 nameComponent = entity.getPrimaryEntryName();
        if (nameComponent == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft == null || minecraft.field_1687 == null) {
            return;
        }
        double distanceSq = minecraft.method_1561().method_3959((double)entity.method_11016().method_10263() + 0.5, (double)entity.method_11016().method_10264() + 0.5, (double)entity.method_11016().method_10260() + 0.5);
        if (distanceSq > 4096.0) {
            return;
        }
        class_327 font = minecraft.field_1772;
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.6, 0.5);
        poseStack.method_22907(minecraft.method_1561().method_24197());
        poseStack.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float background = minecraft.field_1690.method_19343(0.25f);
        int backgroundColor = (int)(background * 255.0f) << 24;
        float xOffset = (float)(-font.method_27525((class_5348)nameComponent)) / 2.0f;
        font.method_30882(nameComponent, xOffset, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, class_327.class_6415.field_33994, backgroundColor, light);
        font.method_30882(nameComponent, xOffset, 0.0f, -1, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, light);
        poseStack.method_22909();
    }

    private void renderActivationRange(SpawnPointBlockEntity entity, class_4587 poseStack, class_4597 bufferSource) {
        double localZ;
        int z;
        double localX;
        int x;
        double radius = Math.max(0.0, entity.getActivationDistance());
        if (radius <= 0.0) {
            return;
        }
        class_2338 pos = entity.method_11016();
        double centerX = (double)pos.method_10263() + 0.5;
        double centerY = (double)pos.method_10264() + 0.5;
        double centerZ = (double)pos.method_10260() + 0.5;
        double minX = centerX - radius;
        double minY = centerY - radius;
        double minZ = centerZ - radius;
        double maxX = centerX + radius;
        double maxY = centerY + radius;
        double maxZ = centerZ + radius;
        double localMinX = minX - (double)pos.method_10263();
        double localMaxX = maxX - (double)pos.method_10263();
        double localMinY = minY - (double)pos.method_10264();
        double localMaxY = maxY - (double)pos.method_10264();
        double localMinZ = minZ - (double)pos.method_10260();
        double localMaxZ = maxZ - (double)pos.method_10260();
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float alpha = 0.6f;
        float gridAlpha = alpha * 0.3f;
        int gridSpacing = 2;
        class_238 box = new class_238(localMinX, localMinY, localMinZ, localMaxX, localMaxY, localMaxZ).method_1014(0.002);
        class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)r, (float)g, (float)b, (float)alpha);
        int gridMinX = class_3532.method_15357((double)minX);
        int gridMaxX = class_3532.method_15384((double)maxX);
        int gridMinY = class_3532.method_15357((double)minY);
        int gridMaxY = class_3532.method_15384((double)maxY);
        int gridMinZ = class_3532.method_15357((double)minZ);
        int gridMaxZ = class_3532.method_15384((double)maxZ);
        for (x = gridMinX + gridSpacing; x < gridMaxX; x += gridSpacing) {
            localX = x - pos.method_10263();
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localX, (double)localMinY, (double)localMinZ, (double)localX, (double)localMinY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localX, (double)localMaxY, (double)localMinZ, (double)localX, (double)localMaxY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = gridMinZ + gridSpacing; z < gridMaxZ; z += gridSpacing) {
            localZ = z - pos.method_10260();
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMinX, (double)localMinY, (double)localZ, (double)localMaxX, (double)localMinY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMinX, (double)localMaxY, (double)localZ, (double)localMaxX, (double)localMaxY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (int y = gridMinY + gridSpacing; y < gridMaxY; y += gridSpacing) {
            double localY = y - pos.method_10264();
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMinX, (double)localY, (double)localMinZ, (double)localMinX, (double)localY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMaxX, (double)localY, (double)localMinZ, (double)localMaxX, (double)localY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMinX, (double)localY, (double)localMinZ, (double)localMaxX, (double)localY, (double)localMinZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMinX, (double)localY, (double)localMaxZ, (double)localMaxX, (double)localY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (x = gridMinX + gridSpacing; x < gridMaxX; x += gridSpacing) {
            localX = x - pos.method_10263();
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localX, (double)localMinY, (double)localMinZ, (double)localX, (double)localMaxY, (double)localMinZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localX, (double)localMinY, (double)localMaxZ, (double)localX, (double)localMaxY, (double)localMaxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = gridMinZ + gridSpacing; z < gridMaxZ; z += gridSpacing) {
            localZ = z - pos.method_10260();
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMinX, (double)localMinY, (double)localZ, (double)localMinX, (double)localMaxY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)localMaxX, (double)localMinY, (double)localZ, (double)localMaxX, (double)localMaxY, (double)localZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
    }

    public int method_33893() {
        return 256;
    }

    public boolean shouldRenderOffScreen(SpawnPointBlockEntity blockEntity) {
        return false;
    }
}

